/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.groupadmin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.beans.MutableGroup;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.utils.HierarchyAnnotatedDAOFactory;
import se.unlogic.hierarchy.foregroundmodules.groupadmin.GroupAccessHandler;
import se.unlogic.hierarchy.foregroundmodules.groupadmin.GroupAdminMapping;
import se.unlogic.hierarchy.foregroundmodules.groupadmin.GroupAdminModule;
import se.unlogic.hierarchy.foregroundmodules.groupadmin.SimpleGroupFactory;
import se.unlogic.hierarchy.foregroundmodules.groupadmin.cruds.GroupAccessCRUD;
import se.unlogic.hierarchy.foregroundmodules.groupadmin.cruds.GroupCRUD;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.factory.BeanFactory;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;

public class GroupAccessAdminModule
extends GroupAdminModule
implements GroupAccessHandler {
    protected AnnotatedDAO<GroupAdminMapping> groupAdminMappingDAO;
    protected QueryParameterFactory<GroupAdminMapping, Group> groupParamFactory;
    protected QueryParameterFactory<GroupAdminMapping, User> userParamFactory;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
        if (!this.systemInterface.getInstanceHandler().addInstance(GroupAccessHandler.class, this)) {
            throw new RuntimeException("Unable to register module in global instance handler using key " + GroupAccessHandler.class.getSimpleName() + ", another instance is already registered using this key.");
        }
    }

    @Override
    public void unload() throws Exception {
        if (this.equals(this.systemInterface.getInstanceHandler().getInstance(GroupAccessHandler.class))) {
            this.systemInterface.getInstanceHandler().removeInstance(GroupAccessHandler.class);
        }
        super.unload();
    }

    @Override
    protected void createDAOs(DataSource dataSource) throws Exception {
        UpgradeResult upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)GroupAccessAdminModule.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(this.getClass().getResourceAsStream("dbscripts/GroupAccessAdminModule.xml")));
        if (upgradeResult.isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
        this.groupAdminMappingDAO = new HierarchyAnnotatedDAOFactory(dataSource, this.getUserHandler(), this.getGroupHandler()).getDAO(GroupAdminMapping.class);
        this.groupParamFactory = this.groupAdminMappingDAO.getParamFactory("group", Group.class);
        this.userParamFactory = this.groupAdminMappingDAO.getParamFactory("user", User.class);
        super.createDAOs(dataSource);
    }

    @Override
    protected GroupCRUD<? extends GroupAdminModule> getGroupCRUD() {
        AnnotatedRequestPopulator populator = new AnnotatedRequestPopulator(MutableGroup.class);
        populator.setBeanFactory((BeanFactory)new SimpleGroupFactory());
        return new GroupAccessCRUD((BeanRequestPopulator<MutableGroup>)populator, "Group", "group", this);
    }

    public List<User> getGroupAdminUsers(Group group) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addExcludedField(GroupAdminMapping.GROUP_FIELD);
        query.addParameter(this.groupParamFactory.getParameter((Object)group));
        List mappings = this.groupAdminMappingDAO.getAll(query);
        if (mappings == null) {
            return null;
        }
        ArrayList<User> users = new ArrayList<User>(mappings.size());
        for (GroupAdminMapping groupAdminMapping : mappings) {
            if (groupAdminMapping.getUser() == null) continue;
            users.add(groupAdminMapping.getUser());
        }
        if (users.isEmpty()) {
            return null;
        }
        return users;
    }

    @Override
    protected void appendShowFormData(Group group, Element showGroupElement, Document doc) throws SQLException {
        XMLUtils.append((Document)doc, (Element)showGroupElement, (String)"AdminUsers", this.getGroupAdminUsers(group));
    }

    public void deleteGroupAccessMappings(MutableGroup group, TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.groupParamFactory.getParameter((Object)group));
        if (transactionHandler != null) {
            this.groupAdminMappingDAO.delete(query, transactionHandler);
        } else {
            this.groupAdminMappingDAO.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupAccessMappings(MutableGroup group, HttpServletRequest req) throws SQLException {
        ArrayList userIDs = NumberUtils.toInt((String[])req.getParameterValues("admin_user"));
        if (userIDs == null) {
            this.deleteGroupAccessMappings(group, null);
            return;
        }
        List<User> users = this.getUserHandler().getUsers(userIDs, false, false);
        if (users == null) {
            this.deleteGroupAccessMappings(group, null);
            return;
        }
        ArrayList<GroupAdminMapping> adminMappings = new ArrayList<GroupAdminMapping>(users.size());
        for (User user : users) {
            adminMappings.add(new GroupAdminMapping(group, user));
        }
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.deleteGroupAccessMappings(group, transactionHandler);
            this.groupAdminMappingDAO.addAll(adminMappings, transactionHandler, null);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
    }

    @Override
    public boolean isGroupAdmin(User user, Group group) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addParameter(this.groupParamFactory.getParameter((Object)group));
        query.addParameter(this.userParamFactory.getParameter((Object)user));
        return this.groupAdminMappingDAO.getBoolean(query);
    }

    @Override
    public List<Group> getUserAdminGroups(User user) throws SQLException {
        HighLevelQuery query = new HighLevelQuery();
        query.addExcludedField(GroupAdminMapping.USER_FIELD);
        query.addParameter(this.userParamFactory.getParameter((Object)user));
        List groupAdminMappings = this.groupAdminMappingDAO.getAll(query);
        if (groupAdminMappings == null) {
            return null;
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        for (GroupAdminMapping adminMapping : groupAdminMappings) {
            if (adminMapping.getGroup() == null) continue;
            groups.add(adminMapping.getGroup());
        }
        if (groups.isEmpty()) {
            return null;
        }
        return groups;
    }
}

