/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.fileviewer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.exceptions.ModuleConfigurationException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.URIParser;

public class FileViewModule
extends AnnotatedForegroundModule {
    private static final ArrayList<SettingDescriptor> SETTINGDESCRIPTORS = new ArrayList(4);
    @ModuleSetting
    protected boolean displayFilpathAndLineCount = false;
    @ModuleSetting
    protected String filePath;

    @Override
    public void init(ForegroundModuleDescriptor moduleDescriptor, SectionInterface sectionInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, sectionInterface, dataSource);
    }

    @Override
    public void update(ForegroundModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleForegroundModuleResponse defaultMethod(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws ModuleConfigurationException {
        if (this.filePath == null || StringUtils.isEmpty((String)this.filePath)) {
            throw new ModuleConfigurationException("No file path set");
        }
        File file = new File(this.filePath);
        if (!file.exists()) {
            this.log.warn((Object)("The file " + this.filePath + " does not exist (" + this.moduleDescriptor + ")"));
            return this.createSimpleResponse("FileNotFound", req, uriParser);
        }
        if (file.isDirectory()) {
            this.log.warn((Object)("The file " + this.filePath + " is a directory (" + this.moduleDescriptor + ")"));
            return this.createSimpleResponse("FileIsDirectory", req, uriParser);
        }
        if (!file.canRead()) {
            this.log.warn((Object)("The file " + this.filePath + " is not readable (" + this.moduleDescriptor + ")"));
            return this.createSimpleResponse("UnableToAccessFile", req, uriParser);
        }
        this.log.info((Object)("Displaying file " + this.filePath + " for user " + user));
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            Document doc = this.createDocument(req, uriParser);
            Element fileElement = doc.createElement("File");
            doc.getFirstChild().appendChild(fileElement);
            if (this.displayFilpathAndLineCount) {
                fileElement.appendChild(XMLUtils.createCDATAElement((String)"FilePath", (Object)this.filePath, (Document)doc));
            }
            Element linesElement = doc.createElement("Lines");
            fileElement.appendChild(linesElement);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                linesElement.appendChild(XMLUtils.createCDATAElement((String)"Line", (Object)line, (Document)doc));
            }
            SimpleForegroundModuleResponse simpleForegroundModuleResponse = new SimpleForegroundModuleResponse(doc, ((ForegroundModuleDescriptor)this.moduleDescriptor).getName(), this.getDefaultBreadcrumb());
            return simpleForegroundModuleResponse;
        }
        catch (FileNotFoundException e) {
            this.log.warn((Object)("The file " + this.filePath + " does not exist (" + this.moduleDescriptor + ")"));
            SimpleForegroundModuleResponse simpleForegroundModuleResponse = this.createSimpleResponse("FileNotFound", req, uriParser);
            return simpleForegroundModuleResponse;
        }
        catch (IOException e) {
            this.log.error((Object)("Error reading file " + this.filePath + " (" + this.moduleDescriptor + ")"));
            SimpleForegroundModuleResponse simpleForegroundModuleResponse = this.createSimpleResponse("UnableToAccessFile", req, uriParser);
            return simpleForegroundModuleResponse;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (fileReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private SimpleForegroundModuleResponse createSimpleResponse(String elementName, HttpServletRequest req, URIParser uriParser) {
        Document doc = this.createDocument(req, uriParser);
        doc.getFirstChild().appendChild(doc.createElement(elementName));
        return new SimpleForegroundModuleResponse(doc, this.getDefaultBreadcrumb());
    }

    public Document createDocument(HttpServletRequest req, URIParser uriParser) {
        Document doc = XMLUtils.createDomDocument();
        Element document = doc.createElement("Document");
        document.appendChild(((ForegroundModuleDescriptor)this.moduleDescriptor).toXML(doc));
        doc.appendChild(document);
        return doc;
    }

    @Override
    public List<SettingDescriptor> getSettings() {
        return SETTINGDESCRIPTORS;
    }

    static {
        SETTINGDESCRIPTORS.add(SettingDescriptor.createCheckboxSetting("displayFilpathAndLineCount", "Display filepath and linecount", "Displays the path to the file and the number of lines in the file", false));
        SETTINGDESCRIPTORS.add(SettingDescriptor.createTextFieldSetting("filePath", "File path", "Path to the file to be displayed", true, null, null));
    }
}

