/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.blog.populators;

import java.util.Arrays;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import se.unlogic.hierarchy.foregroundmodules.blog.beans.BlogPost;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator;

public class BlogPostPopulator
extends AnnotatedRequestPopulator<BlogPost>
implements BeanRequestPopulator<BlogPost> {
    public BlogPostPopulator() {
        super(BlogPost.class);
    }

    public BlogPost populate(HttpServletRequest req) throws ValidationException {
        return this.populate(new BlogPost(), req);
    }

    public BlogPost populate(BlogPost blogPost, HttpServletRequest req) throws ValidationException {
        String newTags;
        if ((blogPost = (BlogPost)super.populate((Object)blogPost, req)).getMessage().contains("split-post</p>")) {
            blogPost.setSplit(true);
        } else {
            blogPost.setSplit(false);
        }
        TreeSet<String> tagSet = new TreeSet<String>();
        String[] tags = req.getParameterValues("tag");
        if (tags != null) {
            tagSet.addAll(Arrays.asList(tags));
        }
        if ((newTags = req.getParameter("newtags")) != null) {
            String[] newTagArray;
            for (String newTag : newTagArray = newTags.split("\n")) {
                newTag = newTag.replace("\n", "");
                if (StringUtils.isEmpty((String)(newTag = newTag.replace("\r", "")))) continue;
                tagSet.add(newTag);
            }
        }
        if (!tagSet.isEmpty()) {
            blogPost.setTags(tagSet);
        } else {
            blogPost.setTags(null);
        }
        return blogPost;
    }
}

