/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.blog.daos.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.daos.BaseDAO;
import se.unlogic.hierarchy.core.handlers.UserHandler;
import se.unlogic.hierarchy.core.populators.UserTypePopulator;
import se.unlogic.hierarchy.foregroundmodules.blog.beans.ArchiveEntry;
import se.unlogic.hierarchy.foregroundmodules.blog.beans.BlogPost;
import se.unlogic.hierarchy.foregroundmodules.blog.beans.TagEntry;
import se.unlogic.hierarchy.foregroundmodules.blog.daos.BlogPostDAO;
import se.unlogic.hierarchy.foregroundmodules.blog.daos.mysql.MySQLCommentDAO;
import se.unlogic.hierarchy.foregroundmodules.blog.populators.ArchiveEntryPopulator;
import se.unlogic.hierarchy.foregroundmodules.blog.populators.TagEntryPopulator;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.GeneratedKeyCollector;
import se.unlogic.standardutils.dao.querys.IntegerKeyCollector;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.enums.Month;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.populators.StringPopulator;
import se.unlogic.standardutils.populators.annotated.AnnotatedResultSetPopulator;

public class MySQLBlogPostDAO
extends BaseDAO
implements BlogPostDAO {
    private static final ArchiveEntryPopulator ARCHIVE_ENTRY_POPULATOR = new ArchiveEntryPopulator();
    private static final TagEntryPopulator TAG_ENTRY_POPULATOR = new TagEntryPopulator();
    private final AnnotatedResultSetPopulator<BlogPost> blogPostPopulator;
    private final MySQLCommentDAO commentDAO;

    public MySQLBlogPostDAO(DataSource ds, UserHandler userHandler, MySQLCommentDAO mySQLCommentDAO) {
        super(ds);
        this.blogPostPopulator = new AnnotatedResultSetPopulator(BlogPost.class, new BeanStringPopulator[]{new UserTypePopulator(userHandler, false, false)});
        this.commentDAO = mySQLCommentDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlogPost> getPosts(int startIndex, int postCount, String blogID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM blog_posts WHERE blogID = ? ORDER BY added DESC LIMIT " + startIndex + "," + postCount, this.blogPostPopulator);
            query.setString(1, blogID);
            ArrayList posts = query.executeQuery();
            this.getRelations(connection, posts);
            ArrayList arrayList = posts;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    private void getRelations(Connection connection, ArrayList<BlogPost> posts) throws SQLException {
        if (posts != null) {
            for (BlogPost post : posts) {
                this.getRelations(connection, post);
            }
        }
    }

    private void getRelations(Connection connection, BlogPost post) throws SQLException {
        if (post != null) {
            post.setComments(this.commentDAO.getBlogPostComments(connection, post.getPostID()));
            ArrayListQuery tagQuery = new ArrayListQuery(connection, false, "SELECT tag FROM blog_tags WHERE postID = ? ORDER BY tag", (BeanResultSetPopulator)StringPopulator.getPopulator());
            tagQuery.setInt(1, post.getPostID().intValue());
            post.setTags(tagQuery.executeQuery());
        }
    }

    @Override
    public int getPostCount(String blogID) throws SQLException {
        ObjectQuery query = new ObjectQuery(this.dataSource, "SELECT COUNT(postID) FROM blog_posts WHERE blogID = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setString(1, blogID);
        return (Integer)query.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlogPost getPost(int postID, boolean relations, String blogID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ObjectQuery query = new ObjectQuery(connection, false, "SELECT * FROM blog_posts WHERE postID = ? AND blogID = ?", this.blogPostPopulator);
            query.setInt(1, postID);
            query.setString(2, blogID);
            BlogPost post = (BlogPost)query.executeQuery();
            if (relations) {
                this.getRelations(connection, post);
            }
            BlogPost blogPost = post;
            return blogPost;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlogPost getPost(String alias, boolean relations, String blogID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ObjectQuery query = new ObjectQuery(connection, false, "SELECT * FROM blog_posts WHERE alias = ? AND blogID = ?", this.blogPostPopulator);
            query.setString(1, alias);
            query.setString(2, blogID);
            BlogPost post = (BlogPost)query.executeQuery();
            if (relations) {
                this.getRelations(connection, post);
            }
            BlogPost blogPost = post;
            return blogPost;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    @Override
    public List<ArchiveEntry> getLatestArchiveEntries(int archiveBundleLimit, String blogID) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT YEAR(added) as yearNr, MONTH(added) as monthNr, count(postID) as postCount FROM blog_posts WHERE blogID = ? GROUP BY yearNr, monthNr ORDER BY yearNr DESC, monthNr DESC LIMIT " + archiveBundleLimit, (BeanResultSetPopulator)ARCHIVE_ENTRY_POPULATOR);
        query.setString(1, blogID);
        return query.executeQuery();
    }

    @Override
    public List<TagEntry> getTagEntries(int tagBundleLimit, String blogID) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT blog_tags.tag, COUNT(blog_posts.postID) AS postCount FROM blog_tags INNER JOIN blog_posts ON (blog_tags.postID=blog_posts.postID) WHERE blogID = ?  GROUP BY blog_tags.tag ORDER BY postCount DESC, tag LIMIT " + tagBundleLimit, (BeanResultSetPopulator)TAG_ENTRY_POPULATOR);
        query.setString(1, blogID);
        return query.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(BlogPost blogPost, String blogID) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO blog_posts VALUES (null,?,?,?,?,?,?,?,?,?,?)");
            query.setString(1, blogPost.getAlias());
            query.setTimestamp(2, blogPost.getAdded());
            query.setTimestamp(3, blogPost.getUpdated());
            query.setString(4, blogPost.getTitle());
            query.setString(5, blogPost.getMessage());
            query.setInt(6, blogPost.getPoster().getUserID().intValue());
            if (blogPost.getEditor() != null) {
                query.setInt(7, blogPost.getEditor().getUserID().intValue());
            } else {
                query.setObject(7, null);
            }
            query.setInt(8, blogPost.getReadCount());
            query.setBoolean(9, blogPost.isSplit());
            query.setString(10, blogID);
            IntegerKeyCollector keyCollector = new IntegerKeyCollector();
            query.executeUpdate(new GeneratedKeyCollector[]{keyCollector});
            blogPost.setPostID(keyCollector.getKeyValue());
            if (blogPost.getTags() != null) {
                this.setTags(blogPost, transactionHandler);
            }
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
    }

    private void setTags(BlogPost blogPost, TransactionHandler transactionHandler) throws SQLException {
        for (String tag : blogPost.getTags()) {
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO blog_tags VALUES (?,?)");
            query.setInt(1, blogPost.getPostID().intValue());
            query.setString(2, tag);
            query.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(BlogPost blogPost) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            UpdateQuery query = transactionHandler.getUpdateQuery("UPDATE blog_posts SET alias = ?, added = ?, updated = ?, title = ?, message = ?, posterID = ?, editorID = ?, readCount = ?, split = ? WHERE postID = ?");
            query.setString(1, blogPost.getAlias());
            query.setTimestamp(2, blogPost.getAdded());
            query.setTimestamp(3, blogPost.getUpdated());
            query.setString(4, blogPost.getTitle());
            query.setString(5, blogPost.getMessage());
            query.setInt(6, blogPost.getPoster().getUserID().intValue());
            if (blogPost.getEditor() != null) {
                query.setInt(7, blogPost.getEditor().getUserID().intValue());
            } else {
                query.setObject(7, null);
            }
            query.setInt(8, blogPost.getReadCount());
            query.setBoolean(9, blogPost.isSplit());
            query.setInt(10, blogPost.getPostID().intValue());
            query.executeUpdate();
            this.clearTags(blogPost, transactionHandler);
            if (blogPost.getTags() != null) {
                this.setTags(blogPost, transactionHandler);
            }
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
    }

    private void clearTags(BlogPost blogPost, TransactionHandler transactionHandler) throws SQLException {
        UpdateQuery query = transactionHandler.getUpdateQuery("DELETE FROM blog_tags WHERE postID = ?");
        query.setInt(1, blogPost.getPostID().intValue());
        query.executeUpdate();
    }

    @Override
    public void delete(BlogPost blogPost, String blogID) throws SQLException {
        UpdateQuery query = new UpdateQuery(this.dataSource, "DELETE FROM blog_posts WHERE postID = ? and blogID = ?");
        query.setInt(1, blogPost.getPostID().intValue());
        query.setString(2, blogID);
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlogPost> getPosts(Integer year, String blogID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM blog_posts WHERE YEAR(added) = ? AND blogID = ? ORDER BY added DESC", this.blogPostPopulator);
            query.setInt(1, year.intValue());
            query.setString(2, blogID);
            ArrayList posts = query.executeQuery();
            this.getRelations(connection, posts);
            ArrayList arrayList = posts;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    @Override
    public List<TagEntry> getTagEntries(String blogID) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT DISTINCT(tag), COUNT(blog_tags.postID) as postCount FROM blog_tags INNER JOIN blog_posts ON (blog_tags.postID=blog_posts.postID) WHERE blogID = ? GROUP BY tag ORDER BY tag", (BeanResultSetPopulator)TAG_ENTRY_POPULATOR);
        query.setString(1, blogID);
        return query.executeQuery();
    }

    @Override
    public List<String> getTags(String blogID) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT DISTINCT(tag) FROM blog_tags INNER JOIN blog_posts ON (blog_tags.postID=blog_posts.postID) WHERE blogID = ? GROUP BY tag ORDER BY tag", (BeanResultSetPopulator)StringPopulator.getPopulator());
        query.setString(1, blogID);
        return query.executeQuery();
    }

    @Override
    public List<ArchiveEntry> getArchiveEntries(String blogID) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT YEAR(added) as yearNr, MONTH(added) as monthNr, count(postID) as postCount FROM blog_posts WHERE blogID = ? GROUP BY yearNr, monthNr ORDER BY yearNr DESC, monthNr DESC", (BeanResultSetPopulator)ARCHIVE_ENTRY_POPULATOR);
        query.setString(1, blogID);
        return query.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlogPost> getPosts(String tag, String blogID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT blog_posts.* FROM blog_tags INNER JOIN blog_posts ON (blog_tags.postID=blog_posts.postID) WHERE blog_tags.tag = ? AND blogID = ? ORDER BY added DESC", this.blogPostPopulator);
            query.setString(1, tag);
            query.setString(2, blogID);
            ArrayList posts = query.executeQuery();
            this.getRelations(connection, posts);
            ArrayList arrayList = posts;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlogPost> getPosts(int year, Month month, String blogID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM blog_posts WHERE YEAR(added) = ? AND MONTH(added) = ? AND blogID = ? ORDER BY added DESC", this.blogPostPopulator);
            query.setInt(1, year);
            query.setInt(2, month.ordinal() + 1);
            query.setString(3, blogID);
            ArrayList posts = query.executeQuery();
            this.getRelations(connection, posts);
            ArrayList arrayList = posts;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlogPost> getLatestPosts(int limit, String blogID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM blog_posts WHERE blogID = ? ORDER BY added DESC LIMIT 0," + limit, this.blogPostPopulator);
            query.setString(1, blogID);
            ArrayList posts = query.executeQuery();
            this.getRelations(connection, posts);
            ArrayList arrayList = posts;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    @Override
    public void incrementReadCount(int postID) throws SQLException {
        UpdateQuery query = new UpdateQuery(this.dataSource, "UPDATE blog_posts SET readCount=readCount + 1 WHERE postID = ?");
        query.setInt(1, postID);
        query.executeUpdate();
    }
}

