/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.blog.daos.mysql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import se.unlogic.hierarchy.core.handlers.UserHandler;
import se.unlogic.hierarchy.foregroundmodules.blog.daos.BlogDAOFactory;
import se.unlogic.hierarchy.foregroundmodules.blog.daos.mysql.MySQLBlogPostDAO;
import se.unlogic.hierarchy.foregroundmodules.blog.daos.mysql.MySQLCommentDAO;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.db.tableversionhandler.DBScriptProvider;
import se.unlogic.standardutils.db.tableversionhandler.TableUpgradeException;
import se.unlogic.standardutils.db.tableversionhandler.TableVersionHandler;
import se.unlogic.standardutils.db.tableversionhandler.UpgradeResult;
import se.unlogic.standardutils.db.tableversionhandler.XMLDBScriptProvider;
import se.unlogic.standardutils.string.StringUtils;

public class MySQLBlogDAOFactory
extends BlogDAOFactory {
    private Logger log = Logger.getLogger(this.getClass());
    private MySQLBlogPostDAO mySQLBlogPostDAO;
    private MySQLCommentDAO mySQLCommentDAO;

    @Override
    public void init(DataSource dataSource, UserHandler userHandler) throws SQLException, IOException, TableUpgradeException, SAXException, ParserConfigurationException {
        UpgradeResult upgradeResult;
        this.log.debug((Object)("Checking for blog tables in datasource " + dataSource));
        if (TableVersionHandler.getTableGroupVersion((DataSource)dataSource, (String)MySQLBlogDAOFactory.class.getName()) == null) {
            String sql;
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"blogposts")) {
                this.log.info((Object)("Creating blogposts table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/BlogPostsTable.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"blogcomments")) {
                this.log.info((Object)("Creating blogcomments table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/BlogCommentsTable.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
            if (!DBUtils.tableExists((DataSource)dataSource, (String)"blogtags")) {
                this.log.info((Object)("Creating blogtags table in datasource " + dataSource));
                sql = StringUtils.readStreamAsString((InputStream)this.getClass().getResourceAsStream("dbscripts/BlogTagsTable.sql"));
                new UpdateQuery(dataSource.getConnection(), true, sql).executeUpdate();
            }
        }
        if ((upgradeResult = TableVersionHandler.upgradeDBTables((DataSource)dataSource, (String)MySQLBlogDAOFactory.class.getName(), (DBScriptProvider)new XMLDBScriptProvider(this.getClass().getResourceAsStream("dbscripts/DB script.xml")))).isUpgrade()) {
            this.log.info((Object)upgradeResult.toString());
        }
        this.mySQLCommentDAO = new MySQLCommentDAO(dataSource, userHandler);
        this.mySQLBlogPostDAO = new MySQLBlogPostDAO(dataSource, userHandler, this.mySQLCommentDAO);
    }

    @Override
    public MySQLBlogPostDAO getBlogPostDAO() {
        return this.mySQLBlogPostDAO;
    }

    @Override
    public MySQLCommentDAO getCommentDAO() {
        return this.mySQLCommentDAO;
    }
}

