/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.blog.beans;

import java.sql.Timestamp;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.date.DateUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLUtils;

public class Comment {
    @DAOManaged
    private Integer commentID;
    @DAOManaged
    private Timestamp added;
    @DAOManaged
    private Timestamp updated;
    @DAOManaged
    @WebPopulate(required=true, maxLength=0x1000000L)
    private String message;
    @DAOManaged(columnName="posterID")
    private User poster;
    @DAOManaged(columnName="editorID")
    private User editor;
    @DAOManaged
    @WebPopulate(required=true, maxLength=255L)
    private String posterName;
    @DAOManaged
    @WebPopulate(required=true, maxLength=255L, populatorID="email")
    private String posterEmail;
    @DAOManaged
    @WebPopulate(maxLength=255L, populatorID="url")
    private String posterWebsite;
    @DAOManaged
    private Integer postID;

    public Integer getCommentID() {
        return this.commentID;
    }

    public void setCommentID(Integer commentID) {
        this.commentID = commentID;
    }

    public Timestamp getAdded() {
        return this.added;
    }

    public void setAdded(Timestamp added) {
        this.added = added;
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    public void setUpdated(Timestamp updated) {
        this.updated = updated;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String content) {
        this.message = content;
    }

    public User getPoster() {
        return this.poster;
    }

    public void setPoster(User poster) {
        this.poster = poster;
    }

    public User getEditor() {
        return this.editor;
    }

    public void setEditor(User editor) {
        this.editor = editor;
    }

    public String getPosterName() {
        return this.posterName;
    }

    public void setPosterName(String posterName) {
        this.posterName = posterName;
    }

    public String getPosterEmail() {
        return this.posterEmail;
    }

    public void setPosterEmail(String posterEmail) {
        this.posterEmail = posterEmail;
    }

    public String getPosterWebsite() {
        return this.posterWebsite;
    }

    public void setPosterWebsite(String posterWebsite) {
        this.posterWebsite = posterWebsite;
    }

    public Integer getPostID() {
        return this.postID;
    }

    public void setPostID(Integer blogPostID) {
        this.postID = blogPostID;
    }

    public Element toXML(Document doc) {
        Element commentElement = doc.createElement("Comment");
        commentElement.appendChild(XMLUtils.createElement((String)"commentID", (Object)(this.commentID + ""), (Document)doc));
        commentElement.appendChild(XMLUtils.createElement((String)"added", (Object)DateUtils.DATE_TIME_FORMATTER.format((Date)this.added), (Document)doc));
        if (this.updated != null) {
            commentElement.appendChild(XMLUtils.createElement((String)"updated", (Object)DateUtils.DATE_TIME_FORMATTER.format((Date)this.updated), (Document)doc));
        }
        commentElement.appendChild(XMLUtils.createCDATAElement((String)"message", (Object)this.message, (Document)doc));
        if (this.poster != null) {
            Element posterElement = doc.createElement("poster");
            posterElement.appendChild(this.poster.toXML(doc));
            commentElement.appendChild(posterElement);
        }
        if (this.editor != null) {
            Element editorElement = doc.createElement("editor");
            editorElement.appendChild(this.editor.toXML(doc));
            commentElement.appendChild(editorElement);
        }
        if (this.posterName != null) {
            commentElement.appendChild(XMLUtils.createCDATAElement((String)"posterName", (Object)this.posterName, (Document)doc));
        }
        if (this.posterEmail != null) {
            commentElement.appendChild(XMLUtils.createCDATAElement((String)"posterEmail", (Object)this.posterEmail, (Document)doc));
        }
        if (this.posterWebsite != null) {
            commentElement.appendChild(XMLUtils.createCDATAElement((String)"posterWebsite", (Object)this.posterWebsite, (Document)doc));
        }
        commentElement.appendChild(XMLUtils.createElement((String)"postID", (Object)this.postID.toString(), (Document)doc));
        return commentElement;
    }

    public String toString() {
        return StringUtils.substring((String)this.message, (int)30, (String)"...") + " (ID: " + this.commentID + ")";
    }
}

