/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.foregroundmodules.blog.beans;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.foregroundmodules.blog.beans.Comment;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.date.DateUtils;
import se.unlogic.standardutils.rss.RSSItem;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.string.Stringyfier;
import se.unlogic.standardutils.xml.XMLUtils;

public class BlogPost
implements RSSItem,
Serializable {
    private static final long serialVersionUID = -534789322203347389L;
    public static final String SPLIT_TAG = "split-post</p>";
    @DAOManaged
    private Integer postID;
    @WebPopulate(required=true, maxLength=255L)
    @DAOManaged
    private String alias;
    @DAOManaged
    private Timestamp added;
    @DAOManaged
    private Timestamp updated;
    @WebPopulate(required=true, maxLength=255L)
    @DAOManaged
    private String title;
    @WebPopulate(required=true, maxLength=0x1000000L)
    @DAOManaged
    private String message;
    @DAOManaged(columnName="posterID", dontUpdateIfNull=true)
    private User poster;
    @DAOManaged(columnName="editorID", dontUpdateIfNull=true)
    private User editor;
    @DAOManaged
    private int readCount;
    @DAOManaged
    private boolean split;
    private String link;
    private Stringyfier<User> userStringyfier;
    private List<Comment> comments;
    private Collection<String> tags;

    public Integer getPostID() {
        return this.postID;
    }

    public void setPostID(Integer postID) {
        this.postID = postID;
    }

    public Timestamp getAdded() {
        return this.added;
    }

    public void setAdded(Timestamp added) {
        this.added = added;
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    public void setUpdated(Timestamp updated) {
        this.updated = updated;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String text) {
        this.message = text;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public User getPoster() {
        return this.poster;
    }

    public void setPoster(User poster) {
        this.poster = poster;
    }

    public User getEditor() {
        return this.editor;
    }

    public void setEditor(User editor) {
        this.editor = editor;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public void setTags(Collection<String> tags) {
        this.tags = tags;
    }

    public Element toXML(Document doc) {
        Element blogPostElement = doc.createElement("BlogPost");
        blogPostElement.appendChild(XMLUtils.createElement((String)"postID", (Object)this.postID.toString(), (Document)doc));
        blogPostElement.appendChild(XMLUtils.createElement((String)"alias", (Object)this.alias, (Document)doc));
        blogPostElement.appendChild(XMLUtils.createElement((String)"added", (Object)DateUtils.DATE_TIME_FORMATTER.format((Date)this.added), (Document)doc));
        if (this.updated != null) {
            blogPostElement.appendChild(XMLUtils.createElement((String)"updated", (Object)DateUtils.DATE_TIME_FORMATTER.format((Date)this.updated), (Document)doc));
        }
        blogPostElement.appendChild(XMLUtils.createElement((String)"title", (Object)this.title, (Document)doc));
        if (this.split) {
            int splitTagIndex = this.message.indexOf(SPLIT_TAG);
            int lastOpenParagraphTag = this.message.substring(0, splitTagIndex).lastIndexOf("<p>");
            int splitIndex = lastOpenParagraphTag != 1 ? lastOpenParagraphTag : splitTagIndex;
            blogPostElement.appendChild(XMLUtils.createCDATAElement((String)"textPart1", (Object)this.message.substring(0, splitIndex), (Document)doc));
            if (this.message.length() > splitTagIndex + SPLIT_TAG.length()) {
                blogPostElement.appendChild(XMLUtils.createCDATAElement((String)"textPart2", (Object)this.message.substring(splitTagIndex + SPLIT_TAG.length()), (Document)doc));
            }
        } else {
            blogPostElement.appendChild(XMLUtils.createCDATAElement((String)"textPart1", (Object)this.message, (Document)doc));
        }
        blogPostElement.appendChild(XMLUtils.createCDATAElement((String)"message", (Object)this.message, (Document)doc));
        if (this.poster != null) {
            Element posterElement = doc.createElement("poster");
            posterElement.appendChild(this.poster.toXML(doc));
            blogPostElement.appendChild(posterElement);
        }
        if (this.editor != null) {
            Element editorElement = doc.createElement("editor");
            editorElement.appendChild(this.editor.toXML(doc));
            blogPostElement.appendChild(editorElement);
        }
        if (this.comments != null) {
            Element commentsElement = doc.createElement("comments");
            blogPostElement.appendChild(commentsElement);
            for (Comment comment : this.comments) {
                commentsElement.appendChild(comment.toXML(doc));
            }
        }
        if (this.tags != null) {
            Element tagsElement = doc.createElement("tags");
            blogPostElement.appendChild(tagsElement);
            for (String tag : this.tags) {
                tagsElement.appendChild(XMLUtils.createCDATAElement((String)"tag", (Object)tag, (Document)doc));
            }
        }
        XMLUtils.appendNewElement((Document)doc, (Element)blogPostElement, (String)"readCount", (Object)this.readCount);
        return blogPostElement;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public String toString() {
        return this.title + " (ID: " + this.postID + ")";
    }

    public Collection<String> getCategories() {
        return this.getTags();
    }

    public String getAuthor() {
        if (this.editor != null) {
            return this.userStringyfier.format((Object)this.editor);
        }
        if (this.poster != null) {
            return this.userStringyfier.format((Object)this.poster);
        }
        return null;
    }

    public String getGuid() {
        return this.link;
    }

    public Date getPubDate() {
        return this.updated == null ? this.added : this.updated;
    }

    public String getDescription() {
        String description;
        if (this.split) {
            int splitTagIndex = this.message.indexOf(SPLIT_TAG);
            int lastOpenParagraphTag = this.message.substring(0, splitTagIndex).lastIndexOf("<p>");
            int splitIndex = lastOpenParagraphTag != 1 ? lastOpenParagraphTag : splitTagIndex;
            description = this.message.substring(0, splitIndex);
        } else {
            description = this.message;
        }
        description = StringUtils.removeHTMLTags((String)description);
        return description;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String blogURL) {
        this.link = blogURL + "/post/" + this.getAlias();
    }

    public String getCommentsLink() {
        return this.link + "#comments";
    }

    public void setUserStringyfier(Stringyfier<User> userStringyfier) {
        this.userStringyfier = userStringyfier;
    }
}

