/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.filtermodules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.FilterChain;
import se.unlogic.hierarchy.core.interfaces.FilterModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.filtermodules.AnnotatedFilterModule;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.webutils.http.URIParser;

public class URLRewriteModule
extends AnnotatedFilterModule {
    private static final String description = "The rules (regular expressions) matching and rewriting the requested URL. Rules are given as \"<search> <replace>\", where <search> is the pattern matched against the requested URL and <replace> is the replacement pattern. Tip: Use $ for backreferences in <replace>. Rules are applied topdown.";
    @ModuleSetting
    @TextAreaSettingDescriptor(name="Rules", description="The rules (regular expressions) matching and rewriting the requested URL. Rules are given as \"<search> <replace>\", where <search> is the pattern matched against the requested URL and <replace> is the replacement pattern. Tip: Use $ for backreferences in <replace>. Rules are applied topdown.")
    protected String rules;
    @ModuleSetting
    @CheckboxSettingDescriptor(name="Return on first match", description="Whether to stop rewriting the URL after the first matched rule, or continue applying the following rules")
    protected boolean returnOnFirstMatch;
    protected List<Map.Entry<Pattern, String>> patterns = new ArrayList<Map.Entry<Pattern, String>>();

    @Override
    public void init(FilterModuleDescriptor moduleDescriptor, SystemInterface systemInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, systemInterface, dataSource);
        this.compilePatterns();
    }

    @Override
    public void update(FilterModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
        this.compilePatterns();
    }

    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, FilterChain filterChain) throws Exception {
        CharSequence rewrittenURL = null;
        for (Map.Entry<Pattern, String> entry : this.patterns) {
            Matcher matcher = entry.getKey().matcher(rewrittenURL == null ? req.getRequestURL() : rewrittenURL);
            if (!matcher.find()) continue;
            rewrittenURL = matcher.replaceFirst(entry.getValue());
            if (!this.returnOnFirstMatch) continue;
            this.log.info((Object)("URL " + req.getRequestURL() + " rewritten to " + (String)rewrittenURL));
            this.sendRedirect(res, user, (String)rewrittenURL);
            return;
        }
        if (rewrittenURL != null) {
            this.log.info((Object)("URL " + req.getRequestURL() + " rewritten to " + (String)rewrittenURL));
            this.sendRedirect(res, user, (String)rewrittenURL);
            return;
        }
        filterChain.doFilter(req, res, user, uriParser);
    }

    private void sendRedirect(HttpServletResponse res, User user, String rewrittenURL) {
        try {
            res.sendRedirect(rewrittenURL);
        }
        catch (IOException e) {
            this.log.warn((Object)("Error redirecting user " + user + " to " + rewrittenURL));
        }
    }

    private void compilePatterns() {
        this.patterns.clear();
        if (!StringUtils.isEmpty((String)this.rules)) {
            String[] rules;
            for (String rule : rules = this.rules.split("\\n")) {
                String[] ruleParts = rule.split(" ");
                if (ruleParts.length == 2) {
                    this.patterns.add((Map.Entry<Pattern, String>)new SimpleEntry((Object)Pattern.compile(ruleParts[0]), (Object)ruleParts[1]));
                    continue;
                }
                this.log.warn((Object)("Rule expressed in invalid syntax, ignoring rule " + rule));
            }
        }
    }
}

