/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.filtermodules;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import se.unlogic.hierarchy.basemodules.FieldInstanceListener;
import se.unlogic.hierarchy.basemodules.MethodInstanceListener;
import se.unlogic.hierarchy.basemodules.ReflectionInstanceListener;
import se.unlogic.hierarchy.core.annotations.InstanceManagerDependency;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.FilterChain;
import se.unlogic.hierarchy.core.interfaces.FilterModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MutableSettingHandler;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.core.utils.ModuleUtils;
import se.unlogic.hierarchy.filtermodules.SimpleFilterModule;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.webutils.http.URIParser;

public abstract class AnnotatedFilterModule
extends SimpleFilterModule {
    protected List<ReflectionInstanceListener<?>> instanceListeners;
    protected boolean hasRequiredDependencies;
    protected ReentrantReadWriteLock dependencyLock;
    protected Lock readLock;

    @Override
    public void init(FilterModuleDescriptor moduleDescriptor, SystemInterface systemInterface, DataSource dataSource) throws Exception {
        super.init(moduleDescriptor, systemInterface, dataSource);
        this.parseSettings(moduleDescriptor.getMutableSettingHandler());
        ReentrantReadWriteLock dependencyLock = new ReentrantReadWriteLock();
        this.instanceListeners = this.getInstanceListeners(dependencyLock.writeLock());
        if (this.instanceListeners != null) {
            for (ReflectionInstanceListener<?> instanceListener : this.instanceListeners) {
                this.log.debug((Object)("Adding instance listener for class " + instanceListener.getRawKey()));
                systemInterface.getInstanceHandler().addInstanceListener(instanceListener.getRawKey(), instanceListener);
                if (this.hasRequiredDependencies || !instanceListener.isRequired()) continue;
                this.hasRequiredDependencies = true;
            }
            this.dependencyLock = dependencyLock;
            this.readLock = dependencyLock.readLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, FilterChain filterChain) throws Exception {
        if (this.dependencyLock != null) {
            this.readLock.lock();
            try {
                if (this.hasRequiredDependencies && !this.checkRequiredDependencies()) {
                    filterChain.doFilter(req, res, user, uriParser);
                }
                this.processFilterRequest(req, res, user, uriParser, filterChain);
            }
            finally {
                this.readLock.unlock();
            }
        } else {
            this.processFilterRequest(req, res, user, uriParser, filterChain);
        }
    }

    public void processFilterRequest(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, FilterChain filterChain) {
    }

    public boolean checkRequiredDependencies() {
        for (ReflectionInstanceListener<?> instanceListener : this.instanceListeners) {
            if (!instanceListener.isRequired() || instanceListener.hasInstance()) continue;
            this.log.error((Object)("Module " + this.moduleDescriptor + " is missing required dependency " + instanceListener.getRawKey().getSimpleName()));
            return false;
        }
        return true;
    }

    @Override
    public void update(FilterModuleDescriptor moduleDescriptor, DataSource dataSource) throws Exception {
        super.update(moduleDescriptor, dataSource);
        this.parseSettings(moduleDescriptor.getMutableSettingHandler());
    }

    @Override
    public void unload() throws Exception {
        if (this.instanceListeners != null) {
            for (ReflectionInstanceListener<?> instanceListener : this.instanceListeners) {
                this.log.debug((Object)("Removing instance listener for class " + instanceListener.getRawKey()));
                this.systemInterface.getInstanceHandler().removeInstanceListener(instanceListener.getRawKey(), instanceListener);
            }
        }
        super.unload();
    }

    protected void parseSettings(MutableSettingHandler mutableSettingHandler) {
        ModuleUtils.setModuleSettings(this, AnnotatedFilterModule.class, mutableSettingHandler, this.systemInterface);
    }

    @Override
    public List<SettingDescriptor> getSettings() {
        ArrayList<SettingDescriptor> settingDescriptors = new ArrayList<SettingDescriptor>();
        ModuleUtils.addSettings(settingDescriptors, super.getSettings());
        try {
            ModuleUtils.addSettings(settingDescriptors, ModuleUtils.getAnnotatedSettingDescriptors(this, AnnotatedFilterModule.class, this.systemInterface));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return settingDescriptors;
    }

    private List<ReflectionInstanceListener<?>> getInstanceListeners(Lock writeLock) {
        ArrayList instanceListeners = new ArrayList();
        List fields = ReflectionUtils.getFields(this.getClass());
        for (Field field : fields) {
            InstanceManagerDependency annotation = field.getAnnotation(InstanceManagerDependency.class);
            if (annotation == null) continue;
            instanceListeners.add(new FieldInstanceListener(this, field, annotation.required(), writeLock));
        }
        List methods = ReflectionUtils.getMethods(this.getClass());
        for (Method method : methods) {
            InstanceManagerDependency annotation = method.getAnnotation(InstanceManagerDependency.class);
            if (annotation == null) continue;
            instanceListeners.add(new MethodInstanceListener(this, method, annotation.required(), writeLock));
        }
        if (instanceListeners.isEmpty()) {
            return null;
        }
        return instanceListeners;
    }
}

