/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.validationerrors;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.standardutils.io.BinarySizeFormater;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLUtils;

@XMLElement(name="validationError")
public class RequestSizeLimitExceededValidationError
extends ValidationError {
    private final long actualSize;
    private final long maxAllowedSize;

    public RequestSizeLimitExceededValidationError(long actualSize, long maxAllowedSize) {
        super("RequestSizeLimitExceeded");
        this.actualSize = actualSize;
        this.maxAllowedSize = maxAllowedSize;
    }

    public long getActualSize() {
        return this.actualSize;
    }

    public long getMaxAllowedSize() {
        return this.maxAllowedSize;
    }

    public Element toXML(Document doc) {
        Element validationErrorElement = super.toXML(doc);
        XMLUtils.appendNewElement((Document)doc, (Element)validationErrorElement, (String)"actualSize", (String)BinarySizeFormater.getFormatedSize((long)this.actualSize));
        XMLUtils.appendNewElement((Document)doc, (Element)validationErrorElement, (String)"maxAllowedSize", (String)BinarySizeFormater.getFormatedSize((long)this.maxAllowedSize));
        return validationErrorElement;
    }
}

