/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.validationerrors;

import java.util.Collection;
import java.util.Collections;
import se.unlogic.hierarchy.core.validationerrors.FileValidationError;
import se.unlogic.standardutils.xml.XMLElement;

@XMLElement(name="validationError")
public class InvalidFileExtensionValidationError
extends FileValidationError {
    @XMLElement(fixCase=true, childName="Extension")
    private final Collection<String> allowedExtensions;

    public InvalidFileExtensionValidationError(String filename) {
        super("InvalidFileExtension", filename);
        this.allowedExtensions = null;
    }

    public InvalidFileExtensionValidationError(String filename, Collection<String> allowedExtensions) {
        super("InvalidFileExtension", filename);
        this.allowedExtensions = allowedExtensions;
    }

    public InvalidFileExtensionValidationError(String filename, String allowedExtension) {
        super("InvalidFileExtension", filename);
        this.allowedExtensions = Collections.singletonList(allowedExtension);
    }

    public Collection<String> getAllowedExtensions() {
        return this.allowedExtensions;
    }
}

