/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.validationerrors;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.validationerrors.FileValidationError;
import se.unlogic.standardutils.io.BinarySizeFormater;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLUtils;

@XMLElement(name="validationError")
public class FileSizeLimitExceededValidationError
extends FileValidationError {
    private final long size;
    private final long maxFileSize;

    public FileSizeLimitExceededValidationError(String filename, long size, long maxFileSize) {
        super("FileSizeLimitExceeded", filename);
        this.size = size;
        this.maxFileSize = maxFileSize;
    }

    public Element toXML(Document doc) {
        Element validationErrorElement = super.toXML(doc);
        XMLUtils.appendNewElement((Document)doc, (Element)validationErrorElement, (String)"size", (String)BinarySizeFormater.getFormatedSize((long)this.size));
        XMLUtils.appendNewElement((Document)doc, (Element)validationErrorElement, (String)"maxFileSize", (String)BinarySizeFormater.getFormatedSize((long)this.maxFileSize));
        return validationErrorElement;
    }

    public long getSize() {
        return this.size;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }
}

