/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.utils.crud;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;
import se.unlogic.fileuploadutils.MultipartRequest;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.utils.crud.MultipartLimitProvider;
import se.unlogic.hierarchy.core.utils.crud.RequestFilter;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;

public class MultipartRequestFilter
implements RequestFilter {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected final MultipartLimitProvider limitProvider;

    public MultipartRequestFilter(MultipartLimitProvider limitProvider) {
        this.limitProvider = limitProvider;
    }

    @Override
    public HttpServletRequest parseRequest(HttpServletRequest req, User user) throws ValidationException {
        if (MultipartRequest.isMultipartRequest((HttpServletRequest)req)) {
            try {
                this.log.info((Object)("Parsing multipart request from user " + user + "..."));
                return new MultipartRequest(this.limitProvider.getRamThreshold() * 1024, this.limitProvider.getMaxRequestSize() * 0x100000L, this.limitProvider.getTempDir(), req);
            }
            catch (FileUploadBase.SizeLimitExceededException e) {
                throw new ValidationException(new ValidationError[]{new ValidationError("FileSizeLimitExceeded")});
            }
            catch (FileUploadBase.FileSizeLimitExceededException e) {
                throw new ValidationException(new ValidationError[]{new ValidationError("FileSizeLimitExceeded")});
            }
            catch (FileUploadException e) {
                throw new ValidationException(new ValidationError[]{new ValidationError("UnableToParseRequest")});
            }
        }
        return req;
    }

    @Override
    public void releaseRequest(HttpServletRequest req, User user) {
        if (req instanceof MultipartRequest) {
            ((MultipartRequest)req).deleteFiles();
        }
    }
}

