/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.utils;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;
import se.unlogic.hierarchy.core.enums.PathType;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.core.interfaces.VisibleModuleDescriptor;
import se.unlogic.standardutils.xsl.XSLVariableReader;

public class XSLVariableReaderFactory {
    public static XSLVariableReader getVariableReader(VisibleModuleDescriptor moduleDescriptor, SystemInterface systemInterface) throws SAXException, IOException, ParserConfigurationException, ClassNotFoundException, URISyntaxException, XPathExpressionException {
        if (moduleDescriptor.getXslPath() != null && moduleDescriptor.getXslPathType() != null) {
            URL styleSheetURL;
            if (moduleDescriptor.getXslPathType() == PathType.Filesystem) {
                return new XSLVariableReader(moduleDescriptor.getXslPath());
            }
            if (moduleDescriptor.getXslPathType() == PathType.RealtiveFilesystem) {
                return new XSLVariableReader(systemInterface.getApplicationFileSystemPath() + moduleDescriptor.getXslPath());
            }
            if (moduleDescriptor.getXslPathType() == PathType.Classpath && (styleSheetURL = Class.forName(moduleDescriptor.getClassname()).getResource(moduleDescriptor.getXslPath())) != null) {
                return new XSLVariableReader(styleSheetURL.toURI());
            }
        }
        return null;
    }
}

