/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import se.unlogic.hierarchy.core.enums.SystemStatus;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionCacheListener;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.core.interfaces.SystemStartupListener;
import se.unlogic.hierarchy.core.sections.Section;
import se.unlogic.hierarchy.core.utils.ModuleUtils;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;

public class MultiForegroundModuleTracker<T>
implements ForegroundModuleCacheListener,
SectionCacheListener,
SystemStartupListener {
    protected final Class<T> targetClass;
    protected final SectionInterface baseSection;
    protected final SystemInterface systemInterface;
    protected final boolean recursive;
    protected final boolean assignable;
    protected final ConcurrentHashMap<ForegroundModuleDescriptor, T> moduleMap = new ConcurrentHashMap();

    public MultiForegroundModuleTracker(Class<T> targetClass, SystemInterface systemInterface, SectionInterface baseSection, boolean recursive, boolean assignable) {
        this.targetClass = targetClass;
        this.systemInterface = systemInterface;
        this.baseSection = baseSection;
        this.recursive = recursive;
        this.assignable = assignable;
        if (systemInterface.getSystemStatus() == SystemStatus.STARTING) {
            systemInterface.addStartupListener(this);
        } else {
            this.systemStarted();
        }
    }

    @Override
    public void systemStarted() {
        ModuleUtils.findForegroundModules(this.targetClass, this.recursive, this.assignable, this.baseSection, this.moduleMap);
        if (this.recursive) {
            if (this.baseSection == this.systemInterface.getRootSection()) {
                this.systemInterface.addForegroundModuleCacheListener(this);
            } else {
                this.addListeners(this.baseSection);
            }
        } else {
            this.baseSection.getForegroundModuleCache().addCacheListener(this);
        }
    }

    private void addListeners(SectionInterface sectionInterface) {
        for (Section section : sectionInterface.getSectionCache().getSections()) {
            this.addListeners(section);
        }
        sectionInterface.getForegroundModuleCache().addCacheListener(this);
        sectionInterface.getSectionCache().addCacheListener(this);
    }

    @Override
    public void moduleCached(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        if (moduleInstance.getClass().equals(this.targetClass) || this.assignable && this.targetClass.isAssignableFrom(moduleInstance.getClass())) {
            this.moduleMap.put(moduleDescriptor, moduleInstance);
        }
    }

    @Override
    public void moduleUpdated(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        if (this.moduleMap.contains(moduleDescriptor)) {
            this.moduleMap.remove(moduleDescriptor, moduleInstance);
            this.moduleMap.put(moduleDescriptor, moduleInstance);
        }
    }

    @Override
    public void moduleUnloaded(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        this.moduleMap.remove(moduleDescriptor);
    }

    public void shutdown() {
        this.systemInterface.removeForegroundModuleCacheListener(this);
        this.moduleMap.clear();
    }

    public Set<ForegroundModuleDescriptor> getDescriptors() {
        return this.moduleMap.keySet();
    }

    public Collection<T> getInstances() {
        return this.moduleMap.values();
    }

    public Set<Map.Entry<ForegroundModuleDescriptor, T>> getEntries() {
        return this.moduleMap.entrySet();
    }

    public boolean isEmpty() {
        return this.moduleMap.isEmpty();
    }

    public int size() {
        return this.moduleMap.size();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " tracking " + this.targetClass.getSimpleName() + " in section " + this.baseSection.getSectionDescriptor() + " (recursive: " + this.recursive + ")";
    }

    @Override
    public void sectionCached(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyAlreadyCachedException {
        sectionInstance.getForegroundModuleCache().addCacheListener(this);
        sectionInstance.getSectionCache().addCacheListener(this);
    }

    @Override
    public void sectionUpdated(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyNotCachedException {
    }

    @Override
    public void sectionUnloaded(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyNotCachedException {
    }
}

