/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.utils;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import se.unlogic.hierarchy.core.annotations.CheckboxSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.DataSourceDropDownSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.DropDownSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.EnumDropDownSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.EnumMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.GroupMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.HTMLEditorSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.ModuleSetting;
import se.unlogic.hierarchy.core.annotations.MultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.PasswordSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.RadioButtonSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextAreaSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.TextFieldSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.UserMultiListSettingDescriptor;
import se.unlogic.hierarchy.core.annotations.XSLVariable;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.beans.LinkTag;
import se.unlogic.hierarchy.core.beans.ScriptTag;
import se.unlogic.hierarchy.core.beans.SettingDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleDataSourceDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.beans.ValueDescriptor;
import se.unlogic.hierarchy.core.exceptions.DataSourceException;
import se.unlogic.hierarchy.core.interfaces.BackgroundModule;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.Module;
import se.unlogic.hierarchy.core.interfaces.ModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.MutableSettingHandler;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.core.interfaces.VisibleModuleDescriptor;
import se.unlogic.hierarchy.core.utils.XSLVariableReaderFactory;
import se.unlogic.hierarchy.foregroundmodules.AnnotatedForegroundModule;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.enums.EnumUtils;
import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.DummyPopulator;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.DummyStringFormatValidator;
import se.unlogic.standardutils.validation.StringFormatValidator;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.standardutils.xsl.XSLVariableReader;

public class ModuleUtils {
    protected static Logger log = Logger.getLogger(ModuleUtils.class);

    public static <T extends BackgroundModule> Map.Entry<BackgroundModuleDescriptor, T> findBackgroundModule(Class<T> moduleClass, boolean recursive, SectionInterface sectionInterface) {
        return ModuleUtils.findBackgroundModule(moduleClass, null, recursive, sectionInterface);
    }

    public static <T extends BackgroundModule> Map.Entry<BackgroundModuleDescriptor, T> findBackgroundModule(Class<T> moduleClass, Integer moduleID, boolean recursive, SectionInterface sectionInterface) {
        return ModuleUtils.findBackgroundModule(moduleClass, false, moduleID, recursive, sectionInterface);
    }

    public static <T extends BackgroundModule> Map.Entry<BackgroundModuleDescriptor, T> findAssignableBackgroundModule(Class<T> moduleClass, boolean recursive, SectionInterface sectionInterface) {
        return ModuleUtils.findBackgroundModule(moduleClass, null, recursive, sectionInterface);
    }

    public static <T extends BackgroundModule> Map.Entry<BackgroundModuleDescriptor, T> findAssignableBackgroundModule(Class<T> moduleClass, Integer moduleID, boolean recursive, SectionInterface sectionInterface) {
        return ModuleUtils.findBackgroundModule(moduleClass, true, moduleID, recursive, sectionInterface);
    }

    public static <T extends BackgroundModule> Map.Entry<BackgroundModuleDescriptor, T> findBackgroundModule(Class<T> moduleClass, boolean assignable, Integer moduleID, boolean recursive, SectionInterface sectionInterface) {
        if (sectionInterface.getBackgroundModuleCache().size() != 0) {
            for (Map.Entry entry : sectionInterface.getBackgroundModuleCache().getCachedModules()) {
                if ((assignable || !((BackgroundModule)entry.getValue()).getClass().equals(moduleClass)) && (!assignable || !moduleClass.isAssignableFrom(((BackgroundModule)entry.getValue()).getClass())) || moduleID != null && (((BackgroundModuleDescriptor)entry.getKey()).getModuleID() == null || !((BackgroundModuleDescriptor)entry.getKey()).getModuleID().equals(moduleID))) continue;
                return new SimpleEntry(entry.getKey(), (Object)((BackgroundModule)entry.getValue()));
            }
        }
        if (recursive) {
            for (SectionInterface sectionInterface2 : sectionInterface.getSectionCache().getSectionMap().values()) {
                Map.Entry<BackgroundModuleDescriptor, T> moduleEntry = ModuleUtils.findBackgroundModule(moduleClass, assignable, moduleID, recursive, sectionInterface2);
                if (moduleEntry == null) continue;
                return moduleEntry;
            }
        }
        return null;
    }

    public static <T> Map.Entry<ForegroundModuleDescriptor, T> findForegroundModule(Class<T> moduleClass, boolean assignable, Integer moduleID, boolean recursive, SectionInterface sectionInterface) {
        if (sectionInterface.getForegroundModuleCache().size() != 0) {
            for (Map.Entry entry : sectionInterface.getForegroundModuleCache().getCachedModules()) {
                if ((assignable || !((ForegroundModule)entry.getValue()).getClass().equals(moduleClass)) && (!assignable || !moduleClass.isAssignableFrom(((ForegroundModule)entry.getValue()).getClass())) || moduleID != null && (((ForegroundModuleDescriptor)entry.getKey()).getModuleID() == null || !((ForegroundModuleDescriptor)entry.getKey()).getModuleID().equals(moduleID))) continue;
                return new SimpleEntry(entry.getKey(), entry.getValue());
            }
        }
        if (recursive) {
            for (SectionInterface sectionInterface2 : sectionInterface.getSectionCache().getSectionMap().values()) {
                Map.Entry<ForegroundModuleDescriptor, T> moduleEntry = ModuleUtils.findForegroundModule(moduleClass, assignable, moduleID, recursive, sectionInterface2);
                if (moduleEntry == null) continue;
                return moduleEntry;
            }
        }
        return null;
    }

    public static <T> HashMap<ForegroundModuleDescriptor, T> findForegroundModules(Class<T> moduleClass, boolean recursive, boolean assignable, SectionInterface sectionInterface) {
        HashMap foregroundModules = new HashMap();
        ModuleUtils.findForegroundModules(moduleClass, recursive, assignable, sectionInterface, foregroundModules);
        return foregroundModules;
    }

    public static <T> void findForegroundModules(Class<T> moduleClass, boolean recursive, boolean assignable, SectionInterface sectionInterface, Map<ForegroundModuleDescriptor, T> foregroundModules) {
        if (sectionInterface.getForegroundModuleCache().size() != 0) {
            for (Map.Entry entry : sectionInterface.getForegroundModuleCache().getCachedModules()) {
                if (!moduleClass.equals(((ForegroundModule)entry.getValue()).getClass()) && (!assignable || !moduleClass.isAssignableFrom(((ForegroundModule)entry.getValue()).getClass()))) continue;
                foregroundModules.put((ForegroundModuleDescriptor)entry.getKey(), (T)entry.getValue());
            }
        }
        if (recursive) {
            for (SectionInterface sectionInterface2 : sectionInterface.getSectionCache().getSectionMap().values()) {
                ModuleUtils.findForegroundModules(moduleClass, recursive, assignable, sectionInterface2, foregroundModules);
            }
        }
    }

    public static void addSettings(List<SettingDescriptor> localSettings, List<? extends SettingDescriptor> superSettings) {
        if (!CollectionUtils.isEmpty(superSettings)) {
            localSettings.addAll(superSettings);
        }
    }

    public static <Type extends Enum<Type>> List<ValueDescriptor> getValueDescriptors(Type[] values) {
        ArrayList<ValueDescriptor> descriptors = new ArrayList<ValueDescriptor>();
        for (Type type : values) {
            descriptors.add(new ValueDescriptor(((Enum)type).toString(), ((Enum)type).toString()));
        }
        return descriptors;
    }

    public static List<ScriptTag> getScripts(XSLVariableReader variableReader, SectionInterface sectionInterface, String staticContentPrefix, ModuleDescriptor moduleDescriptor) throws SAXException, IOException, ParserConfigurationException, ClassNotFoundException, URISyntaxException {
        String scriptVariable = variableReader.getValue("scripts");
        if (!StringUtils.isEmpty((String)scriptVariable)) {
            scriptVariable = scriptVariable.replace("\t", "");
            String linkPrefix = "/static/" + staticContentPrefix + "/" + sectionInterface.getSectionDescriptor().getSectionID() + "/" + ModuleUtils.getModuleDescriptorStaticContentIdentifier(moduleDescriptor);
            if (scriptVariable.contains("\n")) {
                ArrayList scripts = StringUtils.splitOnLineBreak((String)scriptVariable, (boolean)true);
                ArrayList<ScriptTag> scriptTags = new ArrayList<ScriptTag>(scripts.size());
                for (String script : scripts) {
                    if (StringUtils.isEmpty((String)script)) continue;
                    scriptTags.add(new ScriptTag(linkPrefix + script));
                }
                if (scriptTags.isEmpty()) {
                    return null;
                }
                return scriptTags;
            }
            return Collections.singletonList(new ScriptTag(linkPrefix + scriptVariable));
        }
        return null;
    }

    private static String getModuleDescriptorStaticContentIdentifier(ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor instanceof ForegroundModuleDescriptor) {
            return moduleDescriptor.getModuleID() != null ? moduleDescriptor.getModuleID().toString() : ((ForegroundModuleDescriptor)moduleDescriptor).getAlias();
        }
        return Integer.toString(moduleDescriptor.getModuleID() != null ? moduleDescriptor.getModuleID().intValue() : moduleDescriptor.hashCode());
    }

    public static List<ScriptTag> getGlobalScripts(XSLVariableReader variableReader) throws SAXException, IOException, ParserConfigurationException, ClassNotFoundException, URISyntaxException {
        String scriptVariable = variableReader.getValue("globalscripts");
        if (!StringUtils.isEmpty((String)scriptVariable)) {
            scriptVariable = scriptVariable.replace("\t", "");
            String linkPrefix = "/static/global";
            if (scriptVariable.contains("\n")) {
                ArrayList scripts = StringUtils.splitOnLineBreak((String)scriptVariable, (boolean)true);
                ArrayList<ScriptTag> scriptTags = new ArrayList<ScriptTag>(scripts.size());
                for (String script : scripts) {
                    if (StringUtils.isEmpty((String)script)) continue;
                    scriptTags.add(new ScriptTag(linkPrefix + script));
                }
                if (scriptTags.isEmpty()) {
                    return null;
                }
                return scriptTags;
            }
            return Collections.singletonList(new ScriptTag(linkPrefix + scriptVariable));
        }
        return null;
    }

    public static List<LinkTag> getLinks(XSLVariableReader variableReader, SectionInterface sectionInterface, String staticContentPrefix, ModuleDescriptor moduleDescriptor) throws SAXException, IOException, ParserConfigurationException, ClassNotFoundException, URISyntaxException {
        String linksVariable = variableReader.getValue("links");
        if (!StringUtils.isEmpty((String)linksVariable)) {
            linksVariable = linksVariable.replace("\t", "");
            String linkPrefix = "/static/" + staticContentPrefix + "/" + sectionInterface.getSectionDescriptor().getSectionID() + "/" + ModuleUtils.getModuleDescriptorStaticContentIdentifier(moduleDescriptor);
            if (linksVariable.contains("\n")) {
                ArrayList links = StringUtils.splitOnLineBreak((String)linksVariable, (boolean)true);
                ArrayList<LinkTag> linkTags = new ArrayList<LinkTag>(links.size());
                for (String link : links) {
                    if (StringUtils.isEmpty((String)link)) continue;
                    linkTags.add(new LinkTag(linkPrefix + link));
                }
                if (linkTags.isEmpty()) {
                    return null;
                }
                return linkTags;
            }
            return Collections.singletonList(new LinkTag(linkPrefix + linksVariable));
        }
        return null;
    }

    public static List<LinkTag> getGlobalLinks(XSLVariableReader variableReader) throws SAXException, IOException, ParserConfigurationException, ClassNotFoundException, URISyntaxException {
        String linksVariable = variableReader.getValue("globallinks");
        if (!StringUtils.isEmpty((String)linksVariable)) {
            linksVariable = linksVariable.replace("\t", "");
            String linkPrefix = "/static/global";
            if (linksVariable.contains("\n")) {
                ArrayList links = StringUtils.splitOnLineBreak((String)linksVariable, (boolean)true);
                ArrayList<LinkTag> linkTags = new ArrayList<LinkTag>(links.size());
                for (String link : links) {
                    if (StringUtils.isEmpty((String)link)) continue;
                    linkTags.add(new LinkTag(linkPrefix + link));
                }
                if (linkTags.isEmpty()) {
                    return null;
                }
                return linkTags;
            }
            return Collections.singletonList(new LinkTag(linkPrefix + linksVariable));
        }
        return null;
    }

    public static void setModuleSettings(Object target, Class<?> maxDepth, MutableSettingHandler mutableSettingHandler, SystemInterface systemInterface) {
        for (Class<?> clazz = target.getClass(); clazz != maxDepth; clazz = clazz.getSuperclass()) {
            Field[] fields;
            block8: for (Field field : fields = clazz.getDeclaredFields()) {
                ModuleSetting moduleSetting = field.getAnnotation(ModuleSetting.class);
                if (moduleSetting == null) continue;
                try {
                    List values;
                    Object value;
                    String id = !StringUtils.isEmpty((String)moduleSetting.id()) ? moduleSetting.id() : field.getName();
                    if (Modifier.isFinal(field.getModifiers())) {
                        log.warn((Object)("Field " + field.getName() + " in " + clazz + " is final, skipping"));
                        continue;
                    }
                    if (moduleSetting.beanStringPopulator() != DummyPopulator.class) {
                        try {
                            BeanStringPopulator<?> typePopulator = moduleSetting.beanStringPopulator().newInstance();
                            if (!field.getType().isAssignableFrom(typePopulator.getType())) {
                                log.warn((Object)("The type of type populator " + moduleSetting.beanStringPopulator() + " does not match the type of field " + field.getName() + " in " + clazz + ", skipping"));
                                continue;
                            }
                            String value2 = mutableSettingHandler.getString(id);
                            if (value2 == null && !moduleSetting.allowsNull()) continue;
                            ReflectionUtils.setFieldValue((Field)field, (Object)typePopulator.getValue(value2), (Object)target);
                        }
                        catch (InstantiationException e) {
                            log.error((Object)("Unable to create instance of type populator " + moduleSetting.beanStringPopulator() + " for " + field.getName() + " in " + clazz + ", skipping"));
                        }
                        continue;
                    }
                    if (field.getType() == String.class) {
                        value = mutableSettingHandler.getString(id);
                        if (value == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == List.class && ReflectionUtils.checkGenericTypes((Field)field, (Class[])new Class[]{String.class})) {
                        values = mutableSettingHandler.getStrings(id);
                        if (values == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)values, (Object)target);
                        continue;
                    }
                    if (field.getType() == Integer.class) {
                        value = mutableSettingHandler.getInt(id);
                        if (value == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == Integer.TYPE) {
                        value = mutableSettingHandler.getInt(id);
                        if (value == null) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == Short.class) {
                        value = mutableSettingHandler.getShort(id);
                        if (value == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == Short.TYPE) {
                        value = mutableSettingHandler.getShort(id);
                        if (value == null) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == List.class && ReflectionUtils.checkGenericTypes((Field)field, (Class[])new Class[]{Integer.class})) {
                        values = mutableSettingHandler.getInts(id);
                        if (values == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)values, (Object)target);
                        continue;
                    }
                    if (field.getType() == Long.class) {
                        value = mutableSettingHandler.getLong(id);
                        if (value == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == Long.TYPE) {
                        value = mutableSettingHandler.getLong(id);
                        if (value == null) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == List.class && ReflectionUtils.checkGenericTypes((Field)field, (Class[])new Class[]{Long.class})) {
                        values = mutableSettingHandler.getLongs(id);
                        if (values == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)values, (Object)target);
                        continue;
                    }
                    if (field.getType() == Double.class) {
                        value = mutableSettingHandler.getDouble(id);
                        if (value == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == Double.TYPE) {
                        value = mutableSettingHandler.getDouble(id);
                        if (value == null) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == List.class && ReflectionUtils.checkGenericTypes((Field)field, (Class[])new Class[]{Double.class})) {
                        values = mutableSettingHandler.getDoubles(id);
                        if (values == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)values, (Object)target);
                        continue;
                    }
                    if (field.getType() == Float.class) {
                        value = mutableSettingHandler.getFloat(id);
                        if (value == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == Float.TYPE) {
                        value = mutableSettingHandler.getFloat(id);
                        if (value == null) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == List.class && ReflectionUtils.checkGenericTypes((Field)field, (Class[])new Class[]{Float.class})) {
                        values = mutableSettingHandler.getFloats(id);
                        if (values == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)values, (Object)target);
                        continue;
                    }
                    if (field.getType() == Boolean.class) {
                        value = mutableSettingHandler.getBoolean(id);
                        if (value == null && !moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == Boolean.TYPE) {
                        value = mutableSettingHandler.getBoolean(id);
                        if (value == null) continue;
                        ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        continue;
                    }
                    if (field.getType() == DataSource.class) {
                        value = mutableSettingHandler.getInt(id);
                        if (value == null) continue;
                        if ((Integer)value == -1) {
                            ReflectionUtils.setFieldValue((Field)field, (Object)systemInterface.getDataSource(), (Object)target);
                            continue;
                        }
                        try {
                            DataSource dataSource = systemInterface.getDataSourceCache().getDataSource((Integer)value);
                            ReflectionUtils.setFieldValue((Field)field, (Object)dataSource, (Object)target);
                        }
                        catch (DataSourceException e) {
                            log.debug((Object)("Unable to set modulesetting field " + field.getName() + " in class " + clazz), (Throwable)e);
                        }
                        continue;
                    }
                    if (field.getType().isEnum()) {
                        Enum[] enumValues;
                        value = mutableSettingHandler.getString(id);
                        for (Enum enumValue : enumValues = EnumUtils.getValuesFromField((Field)field)) {
                            if (!enumValue.toString().equals(value)) continue;
                            ReflectionUtils.setFieldValue((Field)field, (Object)enumValue, (Object)target);
                            continue block8;
                        }
                        continue;
                    }
                    if (field.getType() == List.class && Enum.class.isAssignableFrom((Class)ReflectionUtils.getGenericType((Field)field))) {
                        values = mutableSettingHandler.getStrings(id);
                        if (values != null) {
                            Enum[] enumValues;
                            ArrayList<Enum> valueList = new ArrayList<Enum>(values.size());
                            for (Enum enumValue : enumValues = (Enum[])((Class)ReflectionUtils.getGenericType((Field)field)).getEnumConstants()) {
                                if (!values.contains(enumValue.toString())) continue;
                                valueList.add(enumValue);
                            }
                            ReflectionUtils.setFieldValue((Field)field, valueList, (Object)target);
                            continue;
                        }
                        if (!moduleSetting.allowsNull()) continue;
                        ReflectionUtils.setFieldValue((Field)field, null, (Object)target);
                        continue;
                    }
                    log.warn((Object)("Field " + field.getName() + " in class " + clazz + " is of an unallowed type " + field.getType() + " or unallowed generic type " + field.getGenericType() + ", skipping"));
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Unable to set modulesetting field " + field.getName() + " in class " + clazz), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Unable to set modulesetting field " + field.getName() + " in class " + clazz), (Throwable)e);
                }
            }
        }
    }

    public static void setXSLVariables(XSLVariableReader variableReader, Object target, Class<?> maxDepth, ModuleDescriptor moduleDescriptor) {
        for (Class<?> clazz = target.getClass(); clazz != maxDepth; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                XSLVariable xslVariable = field.getAnnotation(XSLVariable.class);
                if (xslVariable == null) continue;
                if (!Modifier.isFinal(field.getModifiers()) && field.getType() == String.class) {
                    String fullVariableName = !StringUtils.isEmpty((String)xslVariable.name()) ? xslVariable.prefix() + xslVariable.name() : xslVariable.prefix() + field.getName();
                    String value = variableReader.getValue(fullVariableName);
                    if (value != null && !StringUtils.isEmpty((String)value)) {
                        try {
                            log.debug((Object)("Setting XSL variable value for field " + field.getName() + " in class " + clazz));
                            ReflectionUtils.setFieldValue((Field)field, (Object)value, (Object)target);
                        }
                        catch (IllegalArgumentException e) {
                            log.error((Object)("Unable to set XSL variable field " + field.getName() + " in class " + clazz), (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            log.error((Object)("Unable to set XSL variable field " + field.getName() + " in class " + clazz), (Throwable)e);
                        }
                        continue;
                    }
                    log.warn((Object)("No value found for XSL variable " + fullVariableName + " found in XSL stylesheet for field " + field.getName() + " in module " + moduleDescriptor));
                    continue;
                }
                log.warn((Object)("Field " + field.getName() + " in class " + clazz + " is either final or not a String, skipping"));
            }
        }
    }

    public static XSLVariableReader getXSLVariableReader(VisibleModuleDescriptor moduleDescriptor, SystemInterface systemInterface) {
        try {
            return XSLVariableReaderFactory.getVariableReader(moduleDescriptor, systemInterface);
        }
        catch (SAXException e) {
            log.error((Object)("Unable to create XSLVariableReader for module " + moduleDescriptor + ", XSL variables, script tags and link tags will not be set!"), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Unable to create XSLVariableReader for module " + moduleDescriptor + ", XSL variables, script tags and link tags will not be set!"), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Unable to create XSLVariableReader for module " + moduleDescriptor + ", XSL variables, script tags and link tags will not be set!"), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to create XSLVariableReader for module " + moduleDescriptor + ", XSL variables, script tags and link tags will not be set!"), (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Unable to create XSLVariableReader for module " + moduleDescriptor + ", XSL variables, script tags and link tags will not be set!"), (Throwable)e);
        }
        catch (XPathExpressionException e) {
            log.error((Object)("Unable to create XSLVariableReader for module " + moduleDescriptor + ", XSL variables, script tags and link tags will not be set!"), (Throwable)e);
        }
        return null;
    }

    public static List<SettingDescriptor> getAnnotatedSettingDescriptors(Module<?> moduleInstance, Class<?> maxDepth, SystemInterface systemInterface) throws IllegalArgumentException, IllegalAccessException, InstantiationException, SQLException {
        ArrayList<SettingDescriptor> settingDescriptors = new ArrayList<SettingDescriptor>();
        if (maxDepth == null) {
            maxDepth = Object.class;
        }
        for (Class<?> clazz = moduleInstance.getClass(); clazz != maxDepth; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String id;
                Object id2;
                List<ValueDescriptor> valueDescriptors;
                Annotation annotation;
                if (field.isAnnotationPresent(CheckboxSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(CheckboxSettingDescriptor.class);
                    Boolean defaultValue = null;
                    if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                        defaultValue = field.getBoolean(moduleInstance);
                        if (defaultValue == null) {
                            defaultValue = false;
                        }
                    } else {
                        throw new RuntimeException("Error parsing @CheckboxSettingDescriptor annotated field " + field.getName() + " in class " + clazz + ". Only boolean and Boolan fields can be annotated with @CheckboxSettingDescriptor annotation!");
                    }
                    String id3 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createCheckboxSetting(id3, annotation.name(), annotation.description(), defaultValue));
                    continue;
                }
                if (field.isAnnotationPresent(DropDownSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(DropDownSettingDescriptor.class);
                    valueDescriptors = ModuleUtils.parseMultiValueSettingDescriptorAnnotation(annotation, annotation.values(), annotation.valueDescriptions(), field, clazz);
                    String id4 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createDropDownSetting(id4, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), valueDescriptors));
                    continue;
                }
                if (field.isAnnotationPresent(EnumDropDownSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(EnumDropDownSettingDescriptor.class);
                    Enum[] enumValues = EnumUtils.getValuesFromField((Field)field);
                    ArrayList<ValueDescriptor> valueDescriptors2 = new ArrayList<ValueDescriptor>(enumValues.length);
                    for (Enum enumValue : enumValues) {
                        valueDescriptors2.add(new ValueDescriptor(enumValue.toString(), enumValue.toString()));
                    }
                    id2 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createDropDownSetting((String)id2, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), valueDescriptors2));
                    continue;
                }
                if (field.isAnnotationPresent(MultiListSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(MultiListSettingDescriptor.class);
                    valueDescriptors = ModuleUtils.parseMultiValueSettingDescriptorAnnotation(annotation, annotation.values(), annotation.valueDescriptions(), field, clazz);
                    String id5 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createMultiListSetting(id5, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), valueDescriptors));
                    continue;
                }
                if (field.isAnnotationPresent(EnumMultiListSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(EnumMultiListSettingDescriptor.class);
                    Type type = ReflectionUtils.getGenericType((Field)field);
                    Enum[] enumValues = (Enum[])((Class)type).getEnumConstants();
                    ArrayList valueDescriptors3 = new ArrayList(enumValues.length);
                    for (Enum enumValue : enumValues) {
                        valueDescriptors3.add(new ValueDescriptor(enumValue.toString(), enumValue.toString()));
                    }
                    String id6 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createMultiListSetting(id6, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), valueDescriptors3));
                    continue;
                }
                if (field.isAnnotationPresent(UserMultiListSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(UserMultiListSettingDescriptor.class);
                    valueDescriptors = new ArrayList<ValueDescriptor>();
                    ArrayList<User> users = systemInterface.getUserHandler().getUsers(false, false);
                    if (users != null) {
                        for (User user : users) {
                            ((ArrayList)valueDescriptors).add(new ValueDescriptor(user.getFirstname() + " " + user.getLastname(), user.getUserID().toString()));
                        }
                    }
                    id2 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createMultiListSetting(id2, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), valueDescriptors));
                    continue;
                }
                if (field.isAnnotationPresent(GroupMultiListSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(GroupMultiListSettingDescriptor.class);
                    valueDescriptors = new ArrayList<ValueDescriptor>();
                    ArrayList<Group> groups = systemInterface.getGroupHandler().getGroups(false);
                    if (groups != null) {
                        for (Group group : groups) {
                            ((ArrayList)valueDescriptors).add(new ValueDescriptor(group.getName(), group.getGroupID().toString()));
                        }
                    }
                    id2 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createMultiListSetting(id2, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), valueDescriptors));
                    continue;
                }
                if (field.isAnnotationPresent(DataSourceDropDownSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(DataSourceDropDownSettingDescriptor.class);
                    valueDescriptors = new ArrayList<ValueDescriptor>();
                    ArrayList<SimpleDataSourceDescriptor> dataSourceDescriptors = systemInterface.getCoreDaoFactory().getDataSourceDAO().getAll();
                    ((ArrayList)valueDescriptors).add(new ValueDescriptor("System default", "-1"));
                    if (dataSourceDescriptors != null) {
                        for (SimpleDataSourceDescriptor dataSourceDescriptor : dataSourceDescriptors) {
                            ((ArrayList)valueDescriptors).add(new ValueDescriptor(dataSourceDescriptor.getName(), dataSourceDescriptor.getDataSourceID().toString()));
                        }
                    }
                    id2 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createMultiListSetting((String)id2, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), valueDescriptors));
                    continue;
                }
                if (field.isAnnotationPresent(PasswordSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(PasswordSettingDescriptor.class);
                    id = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createPasswordFieldSetting(id, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), ModuleUtils.getSettingDescriptorStringFormatValidator(annotation.formatValidator())));
                    continue;
                }
                if (field.isAnnotationPresent(RadioButtonSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(RadioButtonSettingDescriptor.class);
                    valueDescriptors = ModuleUtils.parseMultiValueSettingDescriptorAnnotation(annotation, annotation.values(), annotation.valueDescriptions(), field, clazz);
                    String id7 = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createRadioButtonSetting(id7, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), valueDescriptors));
                    continue;
                }
                if (field.isAnnotationPresent(TextAreaSettingDescriptor.class)) {
                    String defaultValue;
                    boolean splitOnLineBreak;
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(TextAreaSettingDescriptor.class);
                    String string = id = annotation.id().equals("") ? field.getName() : annotation.id();
                    if (field.getType().isAssignableFrom(List.class)) {
                        splitOnLineBreak = true;
                        defaultValue = ModuleUtils.getSettingDescriptorDefaultValues(field, moduleInstance);
                    } else {
                        splitOnLineBreak = false;
                        defaultValue = ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance);
                    }
                    settingDescriptors.add(SettingDescriptor.createTextAreaSetting(id, annotation.name(), annotation.description(), annotation.required(), defaultValue, ModuleUtils.getSettingDescriptorStringFormatValidator(annotation.formatValidator()), splitOnLineBreak));
                    continue;
                }
                if (field.isAnnotationPresent(TextFieldSettingDescriptor.class)) {
                    ReflectionUtils.fixFieldAccess((Field)field);
                    annotation = field.getAnnotation(TextFieldSettingDescriptor.class);
                    id = annotation.id().equals("") ? field.getName() : annotation.id();
                    settingDescriptors.add(SettingDescriptor.createTextFieldSetting(id, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), ModuleUtils.getSettingDescriptorStringFormatValidator(annotation.formatValidator())));
                    continue;
                }
                if (!field.isAnnotationPresent(HTMLEditorSettingDescriptor.class)) continue;
                ReflectionUtils.fixFieldAccess((Field)field);
                annotation = field.getAnnotation(HTMLEditorSettingDescriptor.class);
                id = annotation.id().equals("") ? field.getName() : annotation.id();
                settingDescriptors.add(SettingDescriptor.createHTMLEditorSetting(id, annotation.name(), annotation.description(), annotation.required(), ModuleUtils.getSettingDescriptorDefaultValue(field, moduleInstance), ModuleUtils.getSettingDescriptorStringFormatValidator(annotation.formatValidator())));
            }
        }
        return settingDescriptors;
    }

    private static StringFormatValidator getSettingDescriptorStringFormatValidator(Class<? extends StringFormatValidator> formatValidator) throws InstantiationException, IllegalAccessException {
        StringFormatValidator stringFormatValidator = null;
        if (formatValidator != DummyStringFormatValidator.class) {
            stringFormatValidator = formatValidator.newInstance();
        }
        return stringFormatValidator;
    }

    private static String getSettingDescriptorDefaultValue(Field field, Module<?> moduleInstance) throws IllegalArgumentException, IllegalAccessException {
        if (field.getType() == String.class) {
            return (String)field.get(moduleInstance);
        }
        Object value = field.get(moduleInstance);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private static String getSettingDescriptorDefaultValues(Field field, Module<?> moduleInstance) throws IllegalArgumentException, IllegalAccessException {
        Collection values = (Collection)field.get(moduleInstance);
        if (values != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object value : values) {
                if (value == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(value.toString());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static List<ValueDescriptor> parseMultiValueSettingDescriptorAnnotation(Annotation annotation, String[] values, String[] descriptions, Field field, Class<?> clazz) {
        if (values.length == 0) {
            throw new RuntimeException("Error parsing @" + annotation.getClass().getSimpleName() + " annotated field " + field.getName() + " in class " + clazz + ". At least one value and value description needs to be specified!");
        }
        if (descriptions.length == 0) {
            throw new RuntimeException("Error parsing @" + annotation.getClass().getSimpleName() + " annotated field " + field.getName() + " in class " + clazz + ". At least one value and value description needs to be specified!");
        }
        if (values.length != descriptions.length) {
            throw new RuntimeException("Error parsing @" + annotation.getClass().getSimpleName() + " annotated field " + field.getName() + " in class " + clazz + ". The number of values doesn't match the number of value descriptions!");
        }
        ArrayList<ValueDescriptor> valueDescriptors = new ArrayList<ValueDescriptor>(values.length);
        for (int i = 0; i < values.length; ++i) {
            valueDescriptors.add(new ValueDescriptor(descriptions[i], values[i]));
        }
        return valueDescriptors;
    }

    public Element getModuleSettingsAsXML(Module<?> moduleInstance, Document doc, MutableSettingHandler mutableSettingHandler, Class<?> maxDepth) {
        if (maxDepth == null) {
            maxDepth = Object.class;
        }
        Element moduleSettings = doc.createElement("AnnotatedModuleSettings");
        for (Class<?> clazz = moduleInstance.getClass(); clazz != AnnotatedForegroundModule.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.getAnnotation(ModuleSetting.class) == null) continue;
                ReflectionUtils.fixFieldAccess((Field)field);
                Element moduleSetting = doc.createElement("ModuleSetting");
                Element settingName = XMLUtils.createElement((String)"Name", (Object)field.getName(), (Document)doc);
                try {
                    Element settingValue;
                    if (field.getType() == List.class) {
                        settingValue = doc.createElement("Values");
                        List values = mutableSettingHandler.getStrings(field.getName()) == null ? (List)field.get(moduleInstance) : mutableSettingHandler.getStrings(field.getName());
                        for (Object value : values) {
                            settingValue.appendChild(XMLUtils.createElement((String)"Value", (Object)value.toString(), (Document)doc));
                        }
                    } else {
                        settingValue = XMLUtils.createElement((String)"Value", (Object)(mutableSettingHandler.getString(field.getName()) == null ? field.get(moduleInstance) : mutableSettingHandler.getString(field.getName())), (Document)doc);
                    }
                    moduleSetting.appendChild(settingName);
                    moduleSetting.appendChild(settingValue);
                    moduleSettings.appendChild(moduleSetting);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Unable to get XML for modulesetting field " + field.getName() + " in class " + clazz), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Unable to get XML for modulesetting field " + field.getName() + " in class " + clazz), (Throwable)e);
                }
            }
        }
        return moduleSettings;
    }
}

