/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.utils;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleResponse;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.enums.URLType;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.utils.CRUDCallback;
import se.unlogic.standardutils.dao.CRUDDAO;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public abstract class GenericCRUD<BeanType extends Elementable, IDType, UserType extends User, CallbackType extends CRUDCallback<UserType>> {
    public static final String SHOW = "show";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    protected Logger log = Logger.getLogger(GenericCRUD.class);
    protected CRUDDAO<BeanType, IDType> crudDAO;
    protected BeanRequestPopulator<BeanType> populator;
    protected String typeElementName;
    protected String typeElementPluralName;
    protected String typeLogName;
    protected String typeLogPluralName;
    protected CallbackType callback;
    protected String listMethodAlias;
    protected String addTextPrefix = "";
    protected String updateTextPrefix = "";
    protected String showTextPrefix = "";
    protected String listTextPrefix = null;

    public GenericCRUD(CRUDDAO<BeanType, IDType> crudDAO, BeanRequestPopulator<BeanType> populator, String typeElementName, String typeLogName, String listMethodAlias, CallbackType callback) {
        this(crudDAO, populator, typeElementName, typeElementName + "s", typeLogName, typeLogName + "s", listMethodAlias, callback);
    }

    public GenericCRUD(CRUDDAO<BeanType, IDType> crudDAO, BeanRequestPopulator<BeanType> populator, String typeElementName, String typeElementPluralName, String typeLogName, String typeLogPluralName, String listMethodAlias, CallbackType callback) {
        this.crudDAO = crudDAO;
        this.populator = populator;
        this.typeElementName = typeElementName;
        this.typeElementPluralName = typeElementPluralName;
        this.typeLogName = typeLogName;
        this.typeLogPluralName = typeLogPluralName;
        this.callback = callback;
        this.listMethodAlias = listMethodAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForegroundModuleResponse add(HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser) throws Exception {
        try {
            ValidationException validationException = null;
            try {
                req = this.parseRequest(req, user);
                this.checkAddAccess(user, req, uriParser);
                if (req.getMethod().equalsIgnoreCase("POST")) {
                    BeanType bean = this.populateFromAddRequest(req, user, uriParser);
                    this.validateAddPopulation(bean, req, user, uriParser);
                    this.log.info((Object)("User " + user + " adding " + this.typeLogName + " " + bean));
                    this.addBean(bean, req, user, uriParser);
                    ForegroundModuleResponse foregroundModuleResponse = this.beanAdded(bean, req, res, user, uriParser);
                    return foregroundModuleResponse;
                }
            }
            catch (ValidationException e) {
                validationException = e;
            }
            ForegroundModuleResponse foregroundModuleResponse = this.showAddForm(req, res, user, uriParser, validationException);
            return foregroundModuleResponse;
        }
        finally {
            this.releaseRequest(req, user);
        }
    }

    public ForegroundModuleResponse showAddForm(HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser, ValidationException validationException) throws Exception {
        this.log.info((Object)("User " + user + " requested add " + this.typeLogName + " form"));
        Document doc = this.callback.createDocument(req, uriParser, user);
        Element addTypeElement = doc.createElement("Add" + this.typeElementName);
        doc.getFirstChild().appendChild(addTypeElement);
        if (validationException != null) {
            addTypeElement.appendChild(validationException.toXML(doc));
            addTypeElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        this.appendAddFormData(doc, addTypeElement, user, req, uriParser);
        SimpleForegroundModuleResponse moduleResponse = this.createAddFormModuleResponse(doc, req, user, uriParser);
        moduleResponse.addBreadcrumbsLast(this.getAddBreadcrumbs(req, user, uriParser));
        return moduleResponse;
    }

    protected HttpServletRequest parseRequest(HttpServletRequest req, UserType user) throws ValidationException, Exception {
        return req;
    }

    protected void releaseRequest(HttpServletRequest req, UserType user) {
    }

    protected void appendDefaultBreadcrumbs(List<Breadcrumb> breadcrumbs, BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws Exception {
        breadcrumbs.add(this.callback.getDefaultBreadcrumb());
    }

    protected List<Breadcrumb> getAddBreadcrumbs(HttpServletRequest req, UserType user, URIParser uriParser) throws Exception {
        ArrayList<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>(2);
        this.appendDefaultBreadcrumbs(breadcrumbs, null, req, user, uriParser);
        String prefix = this.getAddTextPrefix();
        if (prefix != null) {
            breadcrumbs.add(new Breadcrumb(prefix, uriParser.getFormattedURI(), URLType.RELATIVE_FROM_CONTEXTPATH));
        }
        return breadcrumbs;
    }

    protected String getAddTextPrefix() {
        return this.addTextPrefix;
    }

    protected void checkAddAccess(UserType user, HttpServletRequest req, URIParser uriParser) throws AccessDeniedException, URINotFoundException, SQLException {
    }

    protected ForegroundModuleResponse beanAdded(BeanType bean, HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser) throws Exception {
        this.redirectToListMethod(req, res, bean);
        return null;
    }

    protected BeanType populateFromAddRequest(HttpServletRequest req, UserType user, URIParser uriParser) throws ValidationException, Exception {
        return (BeanType)((Elementable)this.getPopulator(req).populate(req));
    }

    protected void addBean(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws Exception {
        this.crudDAO.add(bean);
    }

    protected void appendAddFormData(Document doc, Element addTypeElement, UserType user, HttpServletRequest req, URIParser uriParser) throws Exception {
    }

    protected void validateAddPopulation(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws ValidationException, SQLException, Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ForegroundModuleResponse update(HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser) throws Exception {
        try {
            ValidationException validationException = null;
            try {
                req = this.parseRequest(req, user);
            }
            catch (ValidationException parseException) {
                block16: {
                    block15: {
                        BeanType bean2 = this.getRequestedBean(req, res, user, uriParser, UPDATE);
                        if (bean2 == null) break block15;
                        ForegroundModuleResponse foregroundModuleResponse = this.showUpdateForm(bean2, req, res, user, uriParser, validationException);
                        this.releaseRequest(req, user);
                        return foregroundModuleResponse;
                    }
                    break block16;
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ForegroundModuleResponse foregroundModuleResponse = this.list(req, res, user, uriParser, parseException.getErrors());
                this.releaseRequest(req, user);
                return foregroundModuleResponse;
            }
            BeanType bean = this.getRequestedBean(req, res, user, uriParser, UPDATE);
            if (bean != null) {
                try {
                    this.checkUpdateAccess(bean, user, req, uriParser);
                    if (req.getMethod().equalsIgnoreCase("POST")) {
                        bean = this.populateFromUpdateRequest(bean, req, user, uriParser);
                        this.validateUpdatePopulation(bean, req, user, uriParser);
                        this.log.info((Object)("User " + user + " updating " + this.typeLogName + " " + bean));
                        this.updateBean(bean, req, user, uriParser);
                        ForegroundModuleResponse bean2 = this.beanUpdated(bean, req, res, user, uriParser);
                        return bean2;
                    }
                }
                catch (ValidationException e) {
                    validationException = e;
                }
                ForegroundModuleResponse foregroundModuleResponse = this.showUpdateForm(bean, req, res, user, uriParser, validationException);
                return foregroundModuleResponse;
            }
            ForegroundModuleResponse foregroundModuleResponse = this.list(req, res, user, uriParser, Collections.singletonList(new ValidationError("UpdateFailed" + this.typeElementName + "NotFound")));
            return foregroundModuleResponse;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseRequest(req, user);
        }
    }

    public ForegroundModuleResponse showUpdateForm(BeanType bean, HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser, ValidationException validationException) throws Exception {
        this.log.info((Object)("User " + user + " requested update " + this.typeLogName + " form for " + bean));
        Document doc = this.callback.createDocument(req, uriParser, user);
        Element updateTypeElement = doc.createElement("Update" + this.typeElementName);
        doc.getFirstChild().appendChild(updateTypeElement);
        this.appendBean(bean, updateTypeElement, doc, user);
        if (validationException != null) {
            updateTypeElement.appendChild(validationException.toXML(doc));
            updateTypeElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        this.appendUpdateFormData(bean, doc, updateTypeElement, user, req, uriParser);
        SimpleForegroundModuleResponse moduleResponse = this.createUpdateFormModuleResponse(bean, doc, req, user, uriParser);
        moduleResponse.addBreadcrumbsLast(this.getUpdateBreadcrumbs(bean, req, user, uriParser));
        return moduleResponse;
    }

    protected void appendBean(BeanType bean, Element targetElement, Document doc, UserType user) {
        targetElement.appendChild(bean.toXML(doc));
    }

    protected String getListTitle(HttpServletRequest req, UserType user, URIParser uriParser) {
        String callbackTitle = this.callback.getTitlePrefix();
        if (callbackTitle == null) {
            return this.listTextPrefix;
        }
        if (this.listTextPrefix == null) {
            return callbackTitle;
        }
        return callbackTitle + " " + this.listTextPrefix;
    }

    protected String getShowTitle(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) {
        String callbackTitle = this.callback.getTitlePrefix();
        if (callbackTitle == null) {
            return this.showTextPrefix + this.getBeanName(bean);
        }
        return callbackTitle + " " + this.showTextPrefix + this.getBeanName(bean);
    }

    protected String getAddTitle(HttpServletRequest req, UserType user, URIParser uriParser) {
        String callbackTitle = this.callback.getTitlePrefix();
        if (callbackTitle == null) {
            return this.addTextPrefix;
        }
        return callbackTitle + " " + this.addTextPrefix;
    }

    private String getUpdateTitle(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) {
        String callbackTitle = this.callback.getTitlePrefix();
        if (callbackTitle == null) {
            return this.updateTextPrefix + this.getBeanName(bean);
        }
        return callbackTitle + " " + this.updateTextPrefix + this.getBeanName(bean);
    }

    protected List<Breadcrumb> getUpdateBreadcrumbs(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws Exception {
        ArrayList<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>(3);
        this.appendDefaultBreadcrumbs(breadcrumbs, bean, req, user, uriParser);
        breadcrumbs.add(new Breadcrumb(this.getUpdateTextPrefix() + this.getBeanName(bean), uriParser.getFormattedURI(), URLType.RELATIVE_FROM_CONTEXTPATH));
        return breadcrumbs;
    }

    protected String getUpdateTextPrefix() {
        return this.updateTextPrefix;
    }

    protected List<Breadcrumb> getShowBreadcrumbs(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws Exception {
        ArrayList<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>(3);
        this.appendDefaultBreadcrumbs(breadcrumbs, bean, req, user, uriParser);
        breadcrumbs.add(new Breadcrumb(this.getShowTextPrefix() + this.getBeanName(bean), uriParser.getFormattedURI(), URLType.RELATIVE_FROM_CONTEXTPATH));
        return breadcrumbs;
    }

    protected String getShowTextPrefix() {
        return this.showTextPrefix;
    }

    protected String getBeanName(BeanType bean) {
        return bean.toString();
    }

    protected void checkUpdateAccess(BeanType bean, UserType user, HttpServletRequest req, URIParser uriParser) throws AccessDeniedException, URINotFoundException, SQLException {
    }

    protected ForegroundModuleResponse beanUpdated(BeanType bean, HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser) throws Exception {
        this.redirectToListMethod(req, res, bean);
        return null;
    }

    protected void updateBean(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws Exception {
        this.crudDAO.update(bean);
    }

    protected BeanType populateFromUpdateRequest(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws ValidationException, Exception {
        return (BeanType)((Elementable)this.getPopulator(req).populate(bean, req));
    }

    protected void appendUpdateFormData(BeanType bean, Document doc, Element updateTypeElement, UserType user, HttpServletRequest req, URIParser uriParser) throws Exception {
    }

    protected void validateUpdatePopulation(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws ValidationException, SQLException, Exception {
    }

    public abstract BeanType getRequestedBean(HttpServletRequest var1, HttpServletResponse var2, UserType var3, URIParser var4, String var5) throws SQLException, AccessDeniedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForegroundModuleResponse delete(HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser) throws Exception {
        try {
            req = this.parseRequest(req, user);
            BeanType bean = this.getRequestedBean(req, res, user, uriParser, DELETE);
            if (bean != null) {
                this.checkDeleteAccess(bean, user, req, uriParser);
                this.log.info((Object)("User " + user + " deleting " + this.typeLogName + " " + bean));
                this.deleteBean(bean, req, user, uriParser);
                ForegroundModuleResponse foregroundModuleResponse = this.beanDeleted(bean, req, res, user, uriParser);
                return foregroundModuleResponse;
            }
            ForegroundModuleResponse foregroundModuleResponse = this.list(req, res, user, uriParser, Collections.singletonList(new ValidationError("DeleteFailed" + this.typeElementName + "NotFound")));
            return foregroundModuleResponse;
        }
        finally {
            this.releaseRequest(req, user);
        }
    }

    protected void checkDeleteAccess(BeanType bean, UserType user, HttpServletRequest req, URIParser uriParser) throws AccessDeniedException, URINotFoundException, SQLException {
    }

    protected ForegroundModuleResponse beanDeleted(BeanType bean, HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser) throws Exception {
        this.redirectToListMethod(req, res, bean);
        return null;
    }

    protected void deleteBean(BeanType bean, HttpServletRequest req, UserType user, URIParser uriParser) throws Exception {
        this.crudDAO.delete(bean);
    }

    public CRUDDAO<BeanType, IDType> getCrudDAO() {
        return this.crudDAO;
    }

    public void setCrudDAO(CRUDDAO<BeanType, IDType> crudDAO) {
        if (crudDAO == null) {
            throw new NullPointerException("CRUDDAO cannot be null!");
        }
        this.crudDAO = crudDAO;
    }

    public BeanRequestPopulator<BeanType> getPopulator(HttpServletRequest req) {
        return this.populator;
    }

    public void setPopulator(BeanRequestPopulator<BeanType> populator) {
        if (populator == null) {
            throw new NullPointerException("Populator cannot be null!");
        }
        this.populator = populator;
    }

    public ForegroundModuleResponse list(HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser, List<ValidationError> validationErrors) throws Exception {
        this.checkListAccess(user, req, uriParser);
        this.log.info((Object)("User " + user + " listing " + this.typeLogPluralName));
        Document doc = this.callback.createDocument(req, uriParser, user);
        Element listTypeElement = doc.createElement("List" + this.typeElementPluralName);
        doc.getFirstChild().appendChild(listTypeElement);
        this.appendAllBeans(doc, listTypeElement, user, req, uriParser, validationErrors);
        if (validationErrors != null) {
            XMLUtils.append((Document)doc, (Element)listTypeElement, validationErrors);
            listTypeElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        this.appendListFormData(doc, listTypeElement, user, req, uriParser, validationErrors);
        SimpleForegroundModuleResponse moduleResponse = this.createListModuleResponse(doc, req, user, uriParser);
        moduleResponse.addBreadcrumbsLast(this.getListBreadcrumbs(req, user, uriParser, validationErrors));
        return moduleResponse;
    }

    public ForegroundModuleResponse show(HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser) throws Exception {
        return this.show(req, res, user, uriParser, null);
    }

    public ForegroundModuleResponse show(HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser, ValidationError validationError) throws Exception {
        BeanType bean = this.getRequestedBean(req, res, user, uriParser, SHOW);
        if (bean != null) {
            return this.showBean(bean, req, res, user, uriParser, validationError);
        }
        return this.list(req, res, user, uriParser, Collections.singletonList(new ValidationError("ShowFailed" + this.typeElementName + "NotFound")));
    }

    public ForegroundModuleResponse showBean(BeanType bean, HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser, ValidationError validationError) throws Exception {
        if (validationError != null) {
            return this.showBean(bean, req, res, user, uriParser, Collections.singletonList(validationError));
        }
        return this.showBean(bean, req, res, user, uriParser, (List<ValidationError>)null);
    }

    public ForegroundModuleResponse showBean(BeanType bean, HttpServletRequest req, HttpServletResponse res, UserType user, URIParser uriParser, List<ValidationError> validationErrors) throws Exception {
        this.checkShowAccess(bean, user, req, uriParser);
        this.log.info((Object)("User " + user + " viewing " + this.typeLogName + " " + bean));
        Document doc = this.callback.createDocument(req, uriParser, user);
        Element showTypeElement = doc.createElement("Show" + this.typeElementName);
        doc.getFirstChild().appendChild(showTypeElement);
        this.appendBean(bean, showTypeElement, doc, user);
        this.appendShowFormData(bean, doc, showTypeElement, user, req, res, uriParser);
        if (res.isCommitted()) {
            return null;
        }
        if (validationErrors != null) {
            XMLUtils.append((Document)doc, (Element)showTypeElement, validationErrors);
            showTypeElement.appendChild(RequestUtils.getRequestParameters((HttpServletRequest)req, (Document)doc));
        }
        SimpleForegroundModuleResponse moduleResponse = this.createShowBeanModuleResponse(bean, doc, req, user, uriParser);
        List<Breadcrumb> breadcrumbs = this.getShowBreadcrumbs(bean, req, user, uriParser);
        if (breadcrumbs != null) {
            moduleResponse.addBreadcrumbsLast(breadcrumbs);
        }
        return moduleResponse;
    }

    protected void appendShowFormData(BeanType bean, Document doc, Element showTypeElement, UserType user, HttpServletRequest req, HttpServletResponse res, URIParser uriParser) throws SQLException, IOException, Exception {
    }

    protected void checkShowAccess(BeanType bean, UserType user, HttpServletRequest req, URIParser uriParser) throws AccessDeniedException, URINotFoundException, SQLException {
    }

    protected void checkListAccess(UserType user, HttpServletRequest req, URIParser uriParser) throws AccessDeniedException, URINotFoundException, SQLException {
    }

    protected List<BeanType> getAllBeans(UserType user) throws SQLException {
        return this.crudDAO.getAll();
    }

    protected List<BeanType> getAllBeans(UserType user, HttpServletRequest req, URIParser uriParser) throws SQLException {
        return this.getAllBeans(user);
    }

    protected void appendAllBeans(Document doc, Element listTypeElement, UserType user, HttpServletRequest req, URIParser uriParser, List<ValidationError> validationError) throws SQLException {
        XMLUtils.append((Document)doc, (Element)listTypeElement, (String)this.typeElementPluralName, this.getAllBeans(user, req, uriParser));
    }

    protected List<Breadcrumb> getListBreadcrumbs(HttpServletRequest req, UserType user, URIParser uriParser, List<ValidationError> validationError) throws Exception {
        ArrayList<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>(2);
        this.appendDefaultBreadcrumbs(breadcrumbs, null, req, user, uriParser);
        String prefix = this.getListTextPrefix();
        if (prefix != null) {
            breadcrumbs.add(new Breadcrumb(prefix, uriParser.getFormattedURI(), URLType.RELATIVE_FROM_CONTEXTPATH));
        }
        return breadcrumbs;
    }

    protected void appendListFormData(Document doc, Element listTypeElement, UserType user, HttpServletRequest req, URIParser uriParser, List<ValidationError> validationError) throws SQLException {
    }

    protected void redirectToListMethod(HttpServletRequest req, HttpServletResponse res, BeanType bean) throws Exception {
        res.sendRedirect(req.getContextPath() + this.callback.getFullAlias() + this.listMethodAlias);
    }

    protected SimpleForegroundModuleResponse createListModuleResponse(Document doc, HttpServletRequest req, UserType user, URIParser uriParser) {
        return new SimpleForegroundModuleResponse(doc, this.getListTitle(req, user, uriParser), new Breadcrumb[0]);
    }

    protected SimpleForegroundModuleResponse createShowBeanModuleResponse(BeanType bean, Document doc, HttpServletRequest req, UserType user, URIParser uriParser) {
        return new SimpleForegroundModuleResponse(doc, this.getShowTitle(bean, req, user, uriParser), new Breadcrumb[0]);
    }

    protected SimpleForegroundModuleResponse createAddFormModuleResponse(Document doc, HttpServletRequest req, UserType user, URIParser uriParser) {
        return new SimpleForegroundModuleResponse(doc, this.getAddTitle(req, user, uriParser), new Breadcrumb[0]);
    }

    protected SimpleForegroundModuleResponse createUpdateFormModuleResponse(BeanType bean, Document doc, HttpServletRequest req, UserType user, URIParser uriParser) {
        return new SimpleForegroundModuleResponse(doc, this.getUpdateTitle(bean, req, user, uriParser), new Breadcrumb[0]);
    }

    public void setShowTextPrefix(String showBreadcrumbPrefix) {
        this.showTextPrefix = showBreadcrumbPrefix;
    }

    public void setAddTextPrefix(String addBreadcrumbPrefix) {
        this.addTextPrefix = addBreadcrumbPrefix;
    }

    public void setUpdateTextPrefix(String updateBreadcrumbPrefix) {
        this.updateTextPrefix = updateBreadcrumbPrefix;
    }

    public String getListTextPrefix() {
        return this.listTextPrefix;
    }

    public void setListTextPrefix(String listTextPrefix) {
        this.listTextPrefix = listTextPrefix;
    }
}

