/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import se.unlogic.hierarchy.core.enums.SystemStatus;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.interfaces.SystemInterface;
import se.unlogic.hierarchy.core.interfaces.SystemStartupListener;
import se.unlogic.hierarchy.core.utils.ForegroundModuleTrackerListener;
import se.unlogic.hierarchy.core.utils.ModuleUtils;
import se.unlogic.standardutils.datatypes.SimpleEntry;

public class ForegroundModuleTracker<T>
implements ForegroundModuleCacheListener,
SystemStartupListener {
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected final Class<T> targetClass;
    protected final Integer moduleID;
    protected final SectionInterface baseSection;
    protected final SystemInterface systemInterface;
    protected final boolean recursive;
    protected final boolean assignable;
    protected Map.Entry<ForegroundModuleDescriptor, T> moduleEntry;
    protected List<ForegroundModuleTrackerListener<T>> listeners;

    public ForegroundModuleTracker(Class<T> targetClass, int moduleID, SystemInterface systemInterface, SectionInterface baseSection, boolean recursive, boolean assignable) {
        this(targetClass, moduleID, systemInterface, baseSection, recursive, assignable, null);
    }

    public ForegroundModuleTracker(Class<T> targetClass, int moduleID, SystemInterface systemInterface, SectionInterface baseSection, boolean recursive, boolean assignable, ForegroundModuleTrackerListener<T> listener) {
        this.targetClass = targetClass;
        this.moduleID = moduleID;
        this.systemInterface = systemInterface;
        this.baseSection = baseSection;
        this.recursive = recursive;
        this.assignable = assignable;
        if (listener != null) {
            this.addListener(listener);
        }
        if (systemInterface.getSystemStatus() == SystemStatus.STARTING) {
            systemInterface.addStartupListener(this);
        } else {
            this.systemStarted();
        }
    }

    @Override
    public void systemStarted() {
        this.writeLock.lock();
        this.writeLock.unlock();
        this.moduleEntry = ModuleUtils.findForegroundModule(this.targetClass, this.assignable, this.moduleID, this.recursive, this.baseSection);
        if (this.moduleEntry != null && this.listeners != null) {
            for (ForegroundModuleTrackerListener<T> listener : this.listeners) {
                listener.moduleCached(this.moduleEntry.getKey(), this.moduleEntry.getValue());
            }
        }
        this.systemInterface.addForegroundModuleCacheListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleCached(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        this.writeLock.lock();
        try {
            if (this.moduleID.equals(moduleDescriptor.getModuleID()) && (moduleInstance.getClass().equals(this.targetClass) || this.assignable && this.targetClass.isAssignableFrom(moduleInstance.getClass()))) {
                this.moduleEntry = new SimpleEntry((Object)moduleDescriptor, (Object)moduleInstance);
                if (this.listeners != null) {
                    for (ForegroundModuleTrackerListener<ForegroundModule> foregroundModuleTrackerListener : this.listeners) {
                        foregroundModuleTrackerListener.moduleCached(moduleDescriptor, moduleInstance);
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void moduleUpdated(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        this.moduleCached(moduleDescriptor, moduleInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleUnloaded(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        this.writeLock.lock();
        try {
            if (this.moduleEntry != null && this.moduleID.equals(moduleDescriptor.getModuleID())) {
                this.moduleEntry = null;
                if (this.listeners != null) {
                    for (ForegroundModuleTrackerListener<ForegroundModule> foregroundModuleTrackerListener : this.listeners) {
                        foregroundModuleTrackerListener.moduleUnloaded(moduleDescriptor, moduleInstance);
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void shutdown() {
        this.writeLock.lock();
        try {
            this.systemInterface.removeForegroundModuleCacheListener(this);
            this.moduleEntry = null;
            this.listeners = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ForegroundModuleDescriptor getDescriptor() {
        this.readLock.lock();
        try {
            if (this.moduleEntry == null) {
                ForegroundModuleDescriptor foregroundModuleDescriptor = null;
                return foregroundModuleDescriptor;
            }
            ForegroundModuleDescriptor foregroundModuleDescriptor = this.moduleEntry.getKey();
            return foregroundModuleDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public T getInstance() {
        this.readLock.lock();
        try {
            if (this.moduleEntry == null) {
                T t = null;
                return t;
            }
            T t = this.moduleEntry.getValue();
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map.Entry<ForegroundModuleDescriptor, T> getEntry() {
        return this.moduleEntry;
    }

    public String toString() {
        return "ForegroundModuleTracker tracking class " + this.targetClass.getName();
    }

    public Integer getModuleID() {
        return this.moduleID;
    }

    public void addListener(ForegroundModuleTrackerListener<T> listener) {
        this.writeLock.lock();
        try {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ForegroundModuleTrackerListener<T>>();
            }
            this.listeners.add(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void remoceListener(ForegroundModuleTrackerListener<T> listener) {
        this.writeLock.lock();
        try {
            if (this.listeners != null) {
                this.listeners.remove(listener);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

