/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import se.unlogic.hierarchy.core.annotations.FCKContent;
import se.unlogic.hierarchy.core.utils.BaseFileAccessValidator;
import se.unlogic.standardutils.reflection.ReflectionUtils;

public class FCKUtils {
    public static String removeAbsoluteFileUrls(String text, String absoluteFileURL) {
        for (String attribute : BaseFileAccessValidator.TAG_ATTRIBUTES) {
            text = text.replace(attribute + "=\"" + absoluteFileURL, attribute + "=\"" + "/@");
            text = text.replace(attribute + "='" + absoluteFileURL, attribute + "='" + "/@");
        }
        return text;
    }

    public static String setAbsoluteFileUrls(String text, String absoluteFileURL) {
        for (String attribute : BaseFileAccessValidator.TAG_ATTRIBUTES) {
            text = text.replace(attribute + "=\"" + "/@", attribute + "=\"" + absoluteFileURL);
            text = text.replace(attribute + "='" + "/@", attribute + "='" + absoluteFileURL);
        }
        return text;
    }

    public static void setAbsoluteFileUrls(Object bean, String absoluteFileURL) {
        try {
            List<Field> fields = FCKUtils.getAnnotatedFields(bean.getClass());
            for (Field field : fields) {
                Object value = field.get(bean);
                if (value == null) continue;
                if (value instanceof String) {
                    field.set(bean, FCKUtils.setAbsoluteFileUrls((String)value, absoluteFileURL));
                    continue;
                }
                if (value instanceof Collection) {
                    for (Object object : (Collection)value) {
                        FCKUtils.setAbsoluteFileUrls(object, absoluteFileURL);
                    }
                    continue;
                }
                FCKUtils.setAbsoluteFileUrls(value, absoluteFileURL);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeAbsoluteFileUrls(Object bean, String absoluteFileURL) {
        try {
            List<Field> fields = FCKUtils.getAnnotatedFields(bean.getClass());
            for (Field field : fields) {
                Object value = field.get(bean);
                if (value == null) continue;
                if (value instanceof String) {
                    field.set(bean, FCKUtils.removeAbsoluteFileUrls((String)value, absoluteFileURL));
                    continue;
                }
                if (value instanceof Collection) {
                    for (Object object : (Collection)value) {
                        FCKUtils.removeAbsoluteFileUrls(object, absoluteFileURL);
                    }
                    continue;
                }
                FCKUtils.removeAbsoluteFileUrls(value, absoluteFileURL);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Field> getAnnotatedFields(Class<?> clazz) {
        List fields = ReflectionUtils.getFields(clazz);
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.isAnnotationPresent(FCKContent.class)) {
                iterator.remove();
            } else if (Modifier.isFinal(field.getModifiers())) {
                throw new RuntimeException("Error parsing field " + field.getName() + " in " + clazz + ". Only non final fields can be annotated with @FCKContent annotation.");
            }
            ReflectionUtils.fixFieldAccess((Field)field);
        }
        return fields;
    }
}

