/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import se.unlogic.hierarchy.core.utils.FileAccessValidator;

public abstract class BaseFileAccessValidator
implements FileAccessValidator {
    private static final Pattern PERCENT_PATTERN = Pattern.compile("%(?![0-9a-fA-F]{2})");
    public static final String[] TAG_ATTRIBUTES = new String[]{"href", "src", "link", "value"};
    protected final String fileBasePath;

    public BaseFileAccessValidator(String fileBasePath) {
        this.fileBasePath = fileBasePath;
    }

    @Override
    public abstract boolean checkAccess(String var1);

    public boolean checkFilePath(String text, String filePath) {
        String absoluteFilePath = this.fileBasePath + filePath;
        try {
            text = PERCENT_PATTERN.matcher(text).replaceAll("%25");
            text = text.replace("&amp;", "&");
            text = URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        for (String attribute : TAG_ATTRIBUTES) {
            if (text.contains(attribute + "='" + absoluteFilePath + "'")) {
                return true;
            }
            if (!text.contains(attribute + "=\"" + absoluteFilePath + "\"")) continue;
            return true;
        }
        return false;
    }
}

