/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.settings;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.settings.Alternative;
import se.unlogic.hierarchy.core.settings.FormElement;
import se.unlogic.hierarchy.core.settings.InvalidFormatException;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLUtils;

public abstract class Setting
implements Elementable {
    protected final String id;
    protected final String name;
    protected final String description;
    protected final FormElement formElement;
    protected final boolean required;

    Setting(String id, String name, String description, FormElement formElement, boolean required) {
        if (StringUtils.isEmpty((String)id)) {
            throw new RuntimeException("ID cannot be null or empty");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new RuntimeException("name cannot be null or empty");
        }
        if (StringUtils.isEmpty((String)description)) {
            throw new RuntimeException("description cannot be null or empty");
        }
        if (formElement == null) {
            throw new NullPointerException("formElement cannot be null");
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.formElement = formElement;
        this.required = required;
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Element toXML(Document doc) {
        Element attributeElement = doc.createElement("SettingDescriptor");
        XMLUtils.appendNewElement((Document)doc, (Element)attributeElement, (String)"ID", (String)this.id);
        XMLUtils.appendNewElement((Document)doc, (Element)attributeElement, (String)"Name", (String)this.name);
        XMLUtils.appendNewElement((Document)doc, (Element)attributeElement, (String)"Description", (String)this.description);
        XMLUtils.appendNewElement((Document)doc, (Element)attributeElement, (String)"FormElement", (Object)((Object)this.formElement));
        XMLUtils.append((Document)doc, (Element)attributeElement, (String)"DefaultValues", (String)"Value", this.getDefaultValues());
        XMLUtils.append((Document)doc, (Element)attributeElement, (String)"Options", this.getAlternatives());
        return attributeElement;
    }

    public abstract List<String> getDefaultValues();

    protected abstract List<Alternative> getAlternatives();

    public abstract List<String> parseAndValidate(List<String> var1) throws InvalidFormatException;

    public final FormElement getFormElement() {
        return this.formElement;
    }

    public boolean isRequired() {
        return this.required;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Setting other = (Setting)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public final String toString() {
        return this.name + " (ID: " + this.id + ")";
    }

    public boolean validateWithoutValues() {
        return false;
    }
}

