/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.settings;

import java.util.List;
import se.unlogic.hierarchy.core.settings.Alternative;
import se.unlogic.hierarchy.core.settings.FormElement;
import se.unlogic.hierarchy.core.settings.InvalidFormatException;
import se.unlogic.hierarchy.core.settings.Setting;
import se.unlogic.standardutils.collections.CollectionUtils;

abstract class MultiValueSetting
extends Setting {
    private final List<String> defaultValues;
    private final List<Alternative> alternatives;

    public MultiValueSetting(String id, String name, String description, FormElement formElement, List<Alternative> alternatives, List<String> defaultValues, boolean required) {
        super(id, name, description, formElement, required);
        if (CollectionUtils.isEmpty(alternatives)) {
            throw new RuntimeException("alternatives cannot be empty");
        }
        this.alternatives = alternatives;
        this.defaultValues = defaultValues;
    }

    @Override
    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    protected List<Alternative> getAlternatives() {
        return this.alternatives;
    }

    @Override
    public List<String> parseAndValidate(List<String> values) throws InvalidFormatException {
        block0: for (String value : values) {
            for (Alternative alternative : this.alternatives) {
                if (!alternative.getValue().equals(value)) continue;
                continue block0;
            }
            throw new InvalidFormatException();
        }
        return values;
    }
}

