/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.servlets;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.unlogic.emailutils.framework.EmailHandler;
import se.unlogic.emailutils.framework.StopableEmailHandler;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.LinkTag;
import se.unlogic.hierarchy.core.beans.ScriptTag;
import se.unlogic.hierarchy.core.beans.SimpleDataSourceDescriptor;
import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.cache.CoreXSLTCacheHandler;
import se.unlogic.hierarchy.core.cache.DataSourceCache;
import se.unlogic.hierarchy.core.cache.FilterModuleCache;
import se.unlogic.hierarchy.core.daos.factories.CoreDaoFactory;
import se.unlogic.hierarchy.core.enums.DataSourceType;
import se.unlogic.hierarchy.core.enums.ResponseType;
import se.unlogic.hierarchy.core.enums.SystemStatus;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.exceptions.RequestException;
import se.unlogic.hierarchy.core.globallisteners.GlobalBackgroundModuleCacheListener;
import se.unlogic.hierarchy.core.globallisteners.GlobalForegroundModuleCacheListener;
import se.unlogic.hierarchy.core.globallisteners.GlobalSectionCacheListener;
import se.unlogic.hierarchy.core.handlers.GroupHandler;
import se.unlogic.hierarchy.core.handlers.LoginHandler;
import se.unlogic.hierarchy.core.handlers.SystemEventHandler;
import se.unlogic.hierarchy.core.handlers.SystemInstanceHandler;
import se.unlogic.hierarchy.core.handlers.SystemSessionListenerHandler;
import se.unlogic.hierarchy.core.handlers.UserHandler;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.CachedXSLTDescriptor;
import se.unlogic.hierarchy.core.interfaces.EventHandler;
import se.unlogic.hierarchy.core.interfaces.FilterModule;
import se.unlogic.hierarchy.core.interfaces.FilterModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.FullSystemInterface;
import se.unlogic.hierarchy.core.interfaces.InstanceHandler;
import se.unlogic.hierarchy.core.interfaces.ModuleResponse;
import se.unlogic.hierarchy.core.interfaces.SectionCacheListener;
import se.unlogic.hierarchy.core.interfaces.SystemStartupListener;
import se.unlogic.hierarchy.core.sections.Section;
import se.unlogic.hierarchy.core.servlets.BaseServlet;
import se.unlogic.hierarchy.core.servlets.CoreFilterChain;
import se.unlogic.hierarchy.core.utils.DBCPUtils;
import se.unlogic.log4jutils.logging.RelativePathHandler;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.enums.EnumUtils;
import se.unlogic.standardutils.i18n.Language;
import se.unlogic.standardutils.io.FileUtils;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.settings.SettingNode;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.time.TimeUtils;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLTransformer;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.RequestUtils;
import se.unlogic.webutils.http.URIParser;

public class CoreServlet
extends BaseServlet
implements FullSystemInterface {
    private static final long serialVersionUID = 2610603465755792663L;
    public static final String VERSION_PREFIX = "OpenHierarchy 1.2.5";
    public static final String VERSION;
    private CoreXSLTCacheHandler xsltCacheHandler;
    private Language defaultLanguage;
    private String applicationFileSystemPath;
    private DataSource dataSource;
    private Section rootSection;
    private DataSourceCache dataSourceCache;
    private UserHandler userHandler;
    private GroupHandler groupHandler;
    private LoginHandler loginHandler;
    private CoreDaoFactory coreDaoFactory;
    private StopableEmailHandler stopableEmailHandler;
    private DataSourceType dataSourceType;
    private GlobalSectionCacheListener globalSectionCacheListener;
    private SystemInstanceHandler systemInstanceHandler;
    private GlobalForegroundModuleCacheListener globalForegroundModuleCacheListener;
    private GlobalBackgroundModuleCacheListener globalBackgroundModuleCacheListener;
    private ConcurrentHashMap<Integer, Section> sectionMap;
    private FilterModuleCache filterModuleCache;
    private SystemEventHandler eventHandler;
    private ArrayList<SystemStartupListener> startupListeners;
    private SystemSessionListenerHandler systemSessionListenerHandler;
    private boolean systemXMLDebug;
    private String systemXMLDebugFile;
    private boolean moduleXMLDebug;
    private String moduleXMLDebugFile;
    private boolean backgroundModuleXMLDebug;
    private String backgroundModuleXMLDebugFile;
    private String encoding;

    public void init() throws ServletException {
        this.init(false);
    }

    @Override
    public void init(boolean throwExceptions) throws ServletException {
        block21: {
            try {
                long startTime = System.currentTimeMillis();
                this.applicationFileSystemPath = this.getServletContext().getRealPath("/");
                String configPrefix = System.getenv("OpenHierarchy_configPrefix");
                File configurationFile = !StringUtils.isEmpty((String)configPrefix) && FileUtils.fileExists((String)(this.applicationFileSystemPath + "WEB-INF/" + configPrefix + ".config.xml")) ? new File(this.applicationFileSystemPath + "WEB-INF/" + configPrefix + ".config.xml") : new File(this.applicationFileSystemPath + "WEB-INF/config.xml");
                if (!configurationFile.exists()) {
                    this.setSystemStatus(SystemStatus.CONFIG_NOT_FOUND);
                    return;
                }
                this.setSystemStatus(SystemStatus.STARTING);
                RelativePathHandler.setPath((String)"webroot", (String)(this.applicationFileSystemPath + "WEB-INF" + File.separator));
                if (!StringUtils.isEmpty((String)configPrefix) && FileUtils.fileExists((String)(this.applicationFileSystemPath + "WEB-INF/" + configPrefix + ".log4j.xml"))) {
                    DOMConfigurator.configure((String)(this.applicationFileSystemPath + "WEB-INF/" + configPrefix + ".log4j.xml"));
                } else {
                    DOMConfigurator.configure((String)(this.applicationFileSystemPath + "WEB-INF/log4j.xml"));
                }
                this.log = Logger.getLogger(CoreServlet.class);
                this.log.fatal((Object)("***** " + VERSION + " starting... *****"));
                XMLParser config = new XMLParser(configurationFile);
                this.dataSourceType = DataSourceType.valueOf(config.getString("/Config/DataSource/Type"));
                if (this.dataSourceType == DataSourceType.SystemManaged) {
                    SimpleDataSourceDescriptor dataSourceDescriptor = new SimpleDataSourceDescriptor();
                    dataSourceDescriptor.setUrl(config.getString("/Config/DataSource/Url"));
                    dataSourceDescriptor.setDriver(config.getString("/Config/DataSource/Driver"));
                    dataSourceDescriptor.setUsername(config.getString("/Config/DataSource/Username"));
                    dataSourceDescriptor.setPassword(config.getString("/Config/DataSource/Password"));
                    dataSourceDescriptor.setRemoveAbandoned(config.getPrimitiveBoolean("/Config/DataSource/RemoveAbandoned"));
                    dataSourceDescriptor.setRemoveTimeout(config.getInteger("/Config/DataSource/RemoveAbandonedTimeout"));
                    dataSourceDescriptor.setTestOnBorrow(config.getPrimitiveBoolean("/Config/DataSource/TestOnBorrow"));
                    dataSourceDescriptor.setValidationQuery(config.getString("/Config/DataSource/ValidationQuery"));
                    dataSourceDescriptor.setMaxActive(config.getInteger("/Config/DataSource/MaxActive"));
                    dataSourceDescriptor.setMaxIdle(config.getInteger("/Config/DataSource/MaxIdle"));
                    dataSourceDescriptor.setLogAbandoned(config.getPrimitiveBoolean("/Config/DataSource/LogAbandoned"));
                    dataSourceDescriptor.setMinIdle(config.getInteger("/Config/DataSource/MinIdle"));
                    dataSourceDescriptor.setMaxWait(config.getInteger("/Config/DataSource/MaxWait"));
                    this.dataSource = DBCPUtils.createConnectionPool(dataSourceDescriptor);
                } else if (this.dataSourceType == DataSourceType.ContainerManaged) {
                    this.dataSource = DBUtils.getDataSource((String)config.getString("/Config/DataSource/Url"));
                } else {
                    throw new RuntimeException("Unknown datasource type " + (Object)((Object)this.dataSourceType) + " in config.xml");
                }
                this.encoding = config.getString("/Config/Encoding");
                if (StringUtils.isEmpty((String)this.encoding)) {
                    throw new RuntimeException("No encoding found in config.xml");
                }
                String defaultLanguage = config.getString("/Config/DefaultLanguage");
                if (StringUtils.isEmpty((String)defaultLanguage) || (this.defaultLanguage = (Language)EnumUtils.toEnum(Language.class, (String)defaultLanguage)) == null) {
                    throw new RuntimeException("No or invalid default language specified in config.xml");
                }
                this.xsltCacheHandler = new CoreXSLTCacheHandler((SettingNode)config, this.defaultLanguage, this.getApplicationFileSystemPath());
                this.userHandler = new UserHandler();
                this.groupHandler = new GroupHandler();
                String coreDAOFactoryClassString = config.getString("/Config/CoreDAOFactory");
                if (StringUtils.isEmpty((String)coreDAOFactoryClassString)) {
                    throw new RuntimeException("No core DAO factory class specified in config.xml");
                }
                Class<?> coreDAOFactoryClass = Class.forName(coreDAOFactoryClassString);
                if (!CoreDaoFactory.class.isAssignableFrom(coreDAOFactoryClass)) {
                    throw new RuntimeException("The core DAO factory class specified in config.xml is not a valid. The specified class must extend se.unlogic.hierarchy.core.daos.factories.CoreDaoFactory.");
                }
                this.coreDaoFactory = (CoreDaoFactory)coreDAOFactoryClass.newInstance();
                this.coreDaoFactory.init(this.dataSource);
                this.dataSourceCache = new DataSourceCache(this.coreDaoFactory);
                this.stopableEmailHandler = new StopableEmailHandler();
                this.moduleXMLDebug = config.getPrimitiveBoolean("/Config/ModuleXMLDebug");
                this.moduleXMLDebugFile = config.getString("/Config/ModuleXMLDebugFile");
                this.systemXMLDebug = config.getPrimitiveBoolean("/Config/SystemXMLDebug");
                this.systemXMLDebugFile = config.getString("/Config/SystemXMLDebugFile");
                this.backgroundModuleXMLDebug = config.getPrimitiveBoolean("/Config/BackgroundModuleXMLDebug");
                this.backgroundModuleXMLDebugFile = config.getString("/Config/BackgroundModuleXMLDebugFile");
                this.globalSectionCacheListener = new GlobalSectionCacheListener();
                this.globalForegroundModuleCacheListener = new GlobalForegroundModuleCacheListener();
                this.globalBackgroundModuleCacheListener = new GlobalBackgroundModuleCacheListener();
                this.sectionMap = new ConcurrentHashMap();
                this.systemInstanceHandler = new SystemInstanceHandler();
                this.eventHandler = new SystemEventHandler();
                this.loginHandler = new LoginHandler();
                this.startupListeners = new ArrayList();
                Method addListenerMethod = ReflectionUtils.getMethod(ServletContext.class, (String)"addListener", Void.TYPE, (Class[])new Class[]{EventListener.class});
                if (addListenerMethod != null) {
                    try {
                        SystemSessionListenerHandler systemSessionListenerHandler = new SystemSessionListenerHandler();
                        addListenerMethod.invoke((Object)this.getServletContext(), systemSessionListenerHandler);
                        this.systemSessionListenerHandler = systemSessionListenerHandler;
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Error adding session listener handler to servlet context", (Throwable)e);
                    }
                }
                this.filterModuleCache = new FilterModuleCache(this);
                try {
                    this.filterModuleCache.cacheModules(false);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error caching filter modules", (Throwable)e);
                }
                SimpleSectionDescriptor simpleSectionDescriptor = this.coreDaoFactory.getSectionDAO().getRootSection(false);
                this.rootSection = new Section(simpleSectionDescriptor, null, this);
                this.rootSection.cacheModuleAndSections();
                this.setSystemStatus(SystemStatus.STARTED);
                this.triggerStartupListeners();
                this.log.fatal((Object)(VERSION + " successfully started in " + TimeUtils.millisecondsToString((long)(System.currentTimeMillis() - startTime)) + " ms"));
            }
            catch (Throwable e) {
                this.setSystemStatus(SystemStatus.FAIL_SAFE);
                if (this.log != null) {
                    this.log.error((Object)(VERSION + " startup failed!"), e);
                    this.log.fatal((Object)(VERSION + " is in failsafe mode"));
                } else {
                    System.out.println(VERSION + " startup failed!");
                    e.printStackTrace();
                    System.out.println(VERSION + " is in failsafe mode!");
                }
                if (!throwExceptions) break block21;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private synchronized void triggerStartupListeners() {
        if (!this.startupListeners.isEmpty()) {
            this.log.info((Object)("Detected " + this.startupListeners.size() + " system startup listeners"));
            for (SystemStartupListener listener : this.startupListeners) {
                try {
                    this.log.info((Object)("Triggering system startup listener " + listener));
                    listener.systemStarted();
                }
                catch (Throwable t) {
                    this.log.error((Object)("Error in system startup listener " + listener), t);
                }
            }
            this.log.info((Object)"All system startup listeners triggered");
            this.startupListeners = null;
        } else {
            this.startupListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStartupListener(SystemStartupListener startupListener) {
        if (this.getSystemStatus() == SystemStatus.STARTED) {
            startupListener.systemStarted();
            return;
        }
        CoreServlet coreServlet = this;
        synchronized (coreServlet) {
            if (this.getSystemStatus() == SystemStatus.STARTING) {
                this.startupListeners.add(startupListener);
            }
        }
    }

    @Override
    protected void processRequest(HttpServletRequest req, HttpServletResponse res) throws TransformerException, IOException {
        User user = this.getUser(req);
        URIParser uriParser = new URIParser(req, req.getServletPath(), null);
        List<Map.Entry<FilterModuleDescriptor, FilterModule>> filterModules = this.filterModuleCache.getEntries(uriParser.getRemainingURI(), user);
        if (filterModules != null) {
            CoreFilterChain filterChain = new CoreFilterChain(this, filterModules);
            filterChain.doFilter(req, res, user, uriParser);
        } else {
            this.processRequest(req, res, user, uriParser);
        }
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws TransformerException, IOException {
        ForegroundModuleResponse moduleResponse = null;
        RequestException exception = null;
        try {
            try {
                moduleResponse = this.rootSection.processRequest(req, res, user, uriParser, this.rootSection.getSectionDescriptor().getRequiredProtocol());
            }
            catch (AccessDeniedException e) {
                if (user == null) {
                    this.loginHandler.processLoginRequest(req, res, uriParser, true);
                }
                if (!res.isCommitted()) {
                    throw e;
                }
            }
        }
        catch (RequestException e) {
            this.log.log(e.getPriority(), (Object)(e.toString() + " Requested by user " + user + " accessing from " + req.getRemoteAddr()), e.getThrowable());
            exception = e;
        }
        if (!res.isCommitted()) {
            CachedXSLTDescriptor xslDescriptor;
            Element errors;
            req.setAttribute("processed", (Object)true);
            Document doc = XMLUtils.createDomDocument();
            Element document = doc.createElement("document");
            doc.appendChild(document);
            if (exception != null) {
                errors = doc.createElement("errors");
                doc.getDocumentElement().appendChild(errors);
                errors.appendChild(exception.toXML(doc));
                if (exception.getStatusCode() != null) {
                    res.setStatus(exception.getStatusCode().intValue());
                }
                this.appendLinks(doc, exception.getBackgroundModuleResponses());
                this.appendScripts(doc, exception.getBackgroundModuleResponses());
                this.addBackgroundModuleResponses(exception.getBackgroundModuleResponses(), doc, user, req);
            } else {
                if (moduleResponse.isUserChanged()) {
                    try {
                        HttpSession session = req.getSession(false);
                        if (session != null) {
                            user = (User)session.getAttribute("user");
                        }
                    }
                    catch (IllegalStateException e) {
                        user = null;
                    }
                }
                if (moduleResponse.isExcludeSystemTransformation()) {
                    doc = moduleResponse.getDocument();
                    document = doc.getDocumentElement();
                }
                this.appendLinks(doc, moduleResponse);
                this.appendScripts(doc, moduleResponse);
                if (this.isValidResponse(moduleResponse)) {
                    Element moduleres;
                    if (moduleResponse.getResponseType() == ResponseType.HTML) {
                        moduleres = doc.createElement("moduleHTMLResponse");
                        document.appendChild(moduleres);
                        moduleres.appendChild(doc.createCDATASection(moduleResponse.getHtml()));
                    } else if (moduleResponse.getResponseType() == ResponseType.XML_FOR_CORE_TRANSFORMATION) {
                        moduleres = doc.createElement("moduleXMLResponse");
                        document.appendChild(moduleres);
                        moduleres.appendChild(doc.adoptNode(moduleResponse.getElement()));
                    } else if (moduleResponse.getResponseType() == ResponseType.XML_FOR_SEPARATE_TRANSFORMATION) {
                        if (moduleResponse.getTransformer() != null) {
                            if (this.moduleXMLDebug && !StringUtils.isEmpty((String)this.moduleXMLDebugFile)) {
                                this.log.debug((Object)("XML debug mode enabled, writing module XML to " + this.moduleXMLDebugFile + " for module " + moduleResponse.getModuleDescriptor()));
                                try {
                                    XMLUtils.writeXMLFile((Node)moduleResponse.getDocument(), (String)(this.applicationFileSystemPath + "WEB-INF/" + this.moduleXMLDebugFile), (boolean)true, (String)this.encoding);
                                    this.log.debug((Object)("Finished writing module XML to " + this.applicationFileSystemPath + "WEB-INF/" + this.moduleXMLDebugFile));
                                }
                                catch (Exception e) {
                                    this.log.error((Object)("Error writing module XML to " + this.applicationFileSystemPath + "WEB-INF/" + this.moduleXMLDebugFile), (Throwable)e);
                                }
                            }
                            try {
                                this.log.debug((Object)"Module XML transformation starting");
                                if (moduleResponse.isExcludeSystemTransformation()) {
                                    res.setContentType("text/html");
                                    res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, proxy-revalidate");
                                    XMLTransformer.transformToWriter((Transformer)moduleResponse.getTransformer(), (Document)doc, (Writer)res.getWriter(), (String)this.encoding);
                                    return;
                                }
                                StringWriter stringWriter = new StringWriter();
                                XMLTransformer.transformToWriter((Transformer)moduleResponse.getTransformer(), (Document)moduleResponse.getDocument(), (Writer)stringWriter, (String)this.encoding);
                                Element moduleres2 = doc.createElement("moduleTransformedResponse");
                                document.appendChild(moduleres2);
                                this.log.debug((Object)"Module XML transformation finished, appending result...");
                                moduleres2.appendChild(doc.createCDATASection(stringWriter.toString()));
                                this.log.debug((Object)"Result appended");
                            }
                            catch (Exception e) {
                                this.log.error((Object)("Tranformation of module response from module" + moduleResponse.getModuleDescriptor() + " failed, requested by user " + user + " accesing from " + req.getRemoteAddr()), (Throwable)e);
                                Element errors2 = doc.createElement("errors");
                                document.appendChild(errors2);
                                Element separateTransformationFailedElement = doc.createElement("separateTransformationFailed");
                                errors2.appendChild(separateTransformationFailedElement);
                                separateTransformationFailedElement.appendChild(XMLUtils.createCDATAElement((String)"exception", (Object)e.toString(), (Document)doc));
                                separateTransformationFailedElement.appendChild(moduleResponse.getModuleDescriptor().toXML(doc));
                            }
                        } else {
                            this.log.error((Object)("Module response for separate transformation without attached stylesheet returned by module " + moduleResponse.getModuleDescriptor() + " requested by user " + user + " accesing from " + req.getRemoteAddr()));
                            errors = doc.createElement("errors");
                            document.appendChild(errors);
                            Element separateTransformationWithoutStylesheetElement = doc.createElement("separateTransformationWithoutStylesheet");
                            errors.appendChild(separateTransformationWithoutStylesheetElement);
                            separateTransformationWithoutStylesheetElement.appendChild(moduleResponse.getModuleDescriptor().toXML(doc));
                        }
                    }
                } else {
                    this.log.error((Object)("Invalid module response from module" + moduleResponse.getModuleDescriptor() + ", requested by user " + user + " accesing from " + req.getRemoteAddr()));
                    errors = doc.createElement("errors");
                    document.appendChild(errors);
                    Element invalidModuleResonseElement = doc.createElement("invalidModuleResonse");
                    errors.appendChild(invalidModuleResonseElement);
                    invalidModuleResonseElement.appendChild(moduleResponse.getModuleDescriptor().toXML(doc));
                }
                this.addBackgroundModuleResponses(moduleResponse.getBackgroundModuleResponses(), doc, user, req);
            }
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)document, (String)"version", (String)VERSION);
            document.appendChild(RequestUtils.getRequestInfoAsXML((Document)doc, (HttpServletRequest)req, (URIParser)uriParser, (boolean)false, (boolean)true));
            document.appendChild(this.rootSection.getSectionDescriptor().toXML(doc));
            if (user != null) {
                document.appendChild(user.toXML(doc));
            }
            if (this.xsltCacheHandler.getXslDescriptorCount() == 1) {
                xslDescriptor = this.xsltCacheHandler.getDefaultXsltDescriptor();
            } else {
                Language language = this.getLanguage(req, user);
                String preferedDesign = this.getPreferedDesign(req, user);
                xslDescriptor = this.xsltCacheHandler.getBestMatchingXSLTDescriptor(language, preferedDesign);
            }
            Element menus = doc.createElement("menus");
            document.appendChild(menus);
            if (moduleResponse != null) {
                if (moduleResponse.getTitle() != null) {
                    document.appendChild(XMLUtils.createCDATAElement((String)"title", (Object)moduleResponse.getTitle(), (Document)doc));
                }
                if (xslDescriptor.usesFullMenu()) {
                    menus.appendChild(this.rootSection.getFullMenu(user, uriParser).toXML(doc));
                } else if (moduleResponse.getMenu() != null) {
                    menus.appendChild(moduleResponse.getMenu().toXML(doc));
                }
                if (!moduleResponse.getBreadcrumbs().isEmpty()) {
                    Element breadcrumbsElement = doc.createElement("breadcrumbs");
                    document.appendChild(breadcrumbsElement);
                    for (Breadcrumb breadcrumb : moduleResponse.getBreadcrumbs()) {
                        if (breadcrumb == null) continue;
                        breadcrumbsElement.appendChild(breadcrumb.toXML(doc));
                    }
                }
            } else if (exception != null) {
                if (xslDescriptor.usesFullMenu()) {
                    menus.appendChild(this.rootSection.getFullMenu(user, uriParser).toXML(doc));
                } else if (exception.getMenu() != null) {
                    menus.appendChild(exception.getMenu().toXML(doc));
                }
            }
            if (this.systemXMLDebug && !StringUtils.isEmpty((String)this.systemXMLDebugFile)) {
                this.log.debug((Object)("XML debug mode enabled, writing system XML to " + this.systemXMLDebugFile));
                try {
                    FileWriter xmldebugstream = new FileWriter(new File(this.applicationFileSystemPath + "WEB-INF/" + this.systemXMLDebugFile));
                    XMLUtils.toString((Node)doc, (String)this.encoding, (Writer)xmldebugstream, (boolean)false);
                    xmldebugstream.close();
                    this.log.debug((Object)("Finished writing system XML to " + this.applicationFileSystemPath + "WEB-INF/" + this.systemXMLDebugFile));
                }
                catch (Exception e) {
                    this.log.error((Object)("Error writing system XML to " + this.applicationFileSystemPath + "WEB-INF/" + this.systemXMLDebugFile), (Throwable)e);
                }
            }
            res.setCharacterEncoding(this.encoding);
            res.setContentType("text/html");
            res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, proxy-revalidate");
            try {
                this.log.debug((Object)"System XML transformation starting");
                XMLTransformer.transformToWriter((Transformer)xslDescriptor.getTransformer(), (Document)doc, (Writer)res.getWriter(), (String)this.encoding);
                this.log.debug((Object)"System XML transformation finished, response transformed and committed");
            }
            catch (TransformerException e) {
                this.log.error((Object)("System XML transformation failed, " + e));
                throw e;
            }
            catch (IOException e) {
                if (!res.isCommitted()) {
                    this.log.error((Object)"Error writing response", (Throwable)e);
                    throw e;
                }
                this.log.debug((Object)"Response already committed");
            }
            catch (IllegalStateException e) {
                this.log.debug((Object)"Response already committed");
            }
        } else if (exception != null) {
            this.log.warn((Object)("Error " + exception + " after response has been committed"));
        } else {
            this.log.debug((Object)"Response already committed");
        }
    }

    private Language getLanguage(HttpServletRequest req, User user) {
        HttpSession session;
        Language language = null;
        Object object = null;
        try {
            object = req.getAttribute("language");
            if (object != null) {
                language = (Language)object;
            }
        }
        catch (ClassCastException e) {
            this.log.warn((Object)("Invalid class " + object.getClass() + " found in request attribute \"language\" of user " + user), (Throwable)e);
        }
        if (language == null && (session = req.getSession()) != null) {
            try {
                object = session.getAttribute("language");
                if (object != null) {
                    language = (Language)object;
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (ClassCastException e) {
                this.log.warn((Object)("Invalid class " + object.getClass() + " found in session attribute \"language\" of user " + user), (Throwable)e);
            }
        }
        if (language == null && user != null) {
            language = user.getLanguage();
        }
        return language;
    }

    private String getPreferedDesign(HttpServletRequest req, User user) {
        HttpSession session;
        String preferedDesign = null;
        Object object = null;
        object = req.getAttribute("preferedDesign");
        if (object != null) {
            preferedDesign = object.toString();
        }
        if (preferedDesign == null && (session = req.getSession()) != null) {
            try {
                object = session.getAttribute("preferedDesign");
                if (object != null) {
                    preferedDesign = object.toString();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (preferedDesign == null && user != null) {
            preferedDesign = user.getPreferedDesign();
        }
        return preferedDesign;
    }

    private void appendLinks(Document doc, ForegroundModuleResponse moduleResponse) {
        Element links = doc.createElement("links");
        doc.getDocumentElement().appendChild(links);
        LinkedHashSet<LinkTag> linkSet = new LinkedHashSet<LinkTag>();
        if (moduleResponse.getLinks() != null) {
            linkSet.addAll(moduleResponse.getLinks());
        }
        if (moduleResponse.getBackgroundModuleResponses() != null) {
            for (BackgroundModuleResponse backgroundModuleResponse : moduleResponse.getBackgroundModuleResponses()) {
                if (backgroundModuleResponse.getLinks() == null) continue;
                linkSet.addAll(backgroundModuleResponse.getLinks());
            }
        }
        XMLUtils.append((Document)doc, (Element)links, linkSet);
    }

    private void appendLinks(Document doc, List<BackgroundModuleResponse> moduleResponses) {
        if (moduleResponses != null) {
            Element links = doc.createElement("links");
            doc.getDocumentElement().appendChild(links);
            LinkedHashSet<LinkTag> linkSet = new LinkedHashSet<LinkTag>();
            for (BackgroundModuleResponse moduleResponse : moduleResponses) {
                if (moduleResponse.getLinks() == null) continue;
                linkSet.addAll(moduleResponse.getLinks());
            }
            XMLUtils.append((Document)doc, (Element)links, linkSet);
        }
    }

    private void appendScripts(Document doc, ForegroundModuleResponse moduleResponse) {
        Element scripts = doc.createElement("scripts");
        doc.getDocumentElement().appendChild(scripts);
        LinkedHashSet<ScriptTag> scriptsSet = new LinkedHashSet<ScriptTag>();
        if (moduleResponse.getScripts() != null) {
            scriptsSet.addAll(moduleResponse.getScripts());
        }
        if (moduleResponse.getBackgroundModuleResponses() != null) {
            for (BackgroundModuleResponse backgroundModuleResponse : moduleResponse.getBackgroundModuleResponses()) {
                if (backgroundModuleResponse.getScripts() == null) continue;
                scriptsSet.addAll(backgroundModuleResponse.getScripts());
            }
        }
        XMLUtils.append((Document)doc, (Element)scripts, scriptsSet);
    }

    private void appendScripts(Document doc, List<BackgroundModuleResponse> moduleResponses) {
        if (moduleResponses != null) {
            Element scripts = doc.createElement("scripts");
            doc.getDocumentElement().appendChild(scripts);
            LinkedHashSet<ScriptTag> scriptsSet = new LinkedHashSet<ScriptTag>();
            for (BackgroundModuleResponse backgroundModuleResponse : moduleResponses) {
                if (backgroundModuleResponse.getScripts() == null) continue;
                scriptsSet.addAll(backgroundModuleResponse.getScripts());
            }
            XMLUtils.append((Document)doc, (Element)scripts, scriptsSet);
        }
    }

    private void addBackgroundModuleResponses(List<BackgroundModuleResponse> backgroundModuleResponses, Document doc, User user, HttpServletRequest req) {
        if (backgroundModuleResponses != null) {
            Document debugDoc;
            Element backgroundsModuleResponsesElement = doc.createElement("backgroundsModuleResponses");
            doc.getFirstChild().appendChild(backgroundsModuleResponsesElement);
            if (this.backgroundModuleXMLDebug && !StringUtils.isEmpty((String)this.backgroundModuleXMLDebugFile)) {
                debugDoc = XMLUtils.createDomDocument();
                debugDoc.appendChild(debugDoc.createElement("BackgroundModuleDebug"));
            } else {
                debugDoc = null;
            }
            for (BackgroundModuleResponse moduleResponse : backgroundModuleResponses) {
                Element responseElement;
                if (!this.isValidResponse(moduleResponse)) continue;
                if (moduleResponse.getResponseType() == ResponseType.HTML) {
                    responseElement = doc.createElement("response");
                    backgroundsModuleResponsesElement.appendChild(responseElement);
                    Element htmlElement = doc.createElement("HTML");
                    responseElement.appendChild(htmlElement);
                    htmlElement.appendChild(doc.createCDATASection(moduleResponse.getHtml()));
                    this.appendSlots(moduleResponse, doc, responseElement);
                    continue;
                }
                if (moduleResponse.getResponseType() == ResponseType.XML_FOR_CORE_TRANSFORMATION) {
                    responseElement = doc.createElement("response");
                    backgroundsModuleResponsesElement.appendChild(responseElement);
                    Element xmlElement = doc.createElement("XML");
                    responseElement.appendChild(xmlElement);
                    xmlElement.appendChild(doc.adoptNode(moduleResponse.getElement()));
                    this.appendSlots(moduleResponse, doc, responseElement);
                    continue;
                }
                if (moduleResponse.getResponseType() != ResponseType.XML_FOR_SEPARATE_TRANSFORMATION) continue;
                if (moduleResponse.getTransformer() != null) {
                    if (debugDoc != null) {
                        this.log.debug((Object)("Background XML debug mode enabled, appending XML from module " + moduleResponse.getModuleDescriptor() + " to XML debug document"));
                        try {
                            Element documentElement = (Element)debugDoc.importNode(moduleResponse.getDocument().getDocumentElement(), true);
                            if (moduleResponse.getModuleDescriptor() != null) {
                                documentElement.setAttribute("moduleID", moduleResponse.getModuleDescriptor().getModuleID() + "");
                                documentElement.setAttribute("name", moduleResponse.getModuleDescriptor().getName());
                            }
                            debugDoc.getDocumentElement().appendChild(documentElement);
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Error appending XML from module " + moduleResponse.getModuleDescriptor() + " to  XML debug document"), (Throwable)e);
                        }
                    }
                    try {
                        StringWriter stringWriter = new StringWriter();
                        this.log.debug((Object)"Background module XML transformation starting");
                        XMLTransformer.transformToWriter((Transformer)moduleResponse.getTransformer(), (Document)moduleResponse.getDocument(), (Writer)stringWriter, (String)this.encoding);
                        this.log.debug((Object)"Background module XML transformation finished, appending result...");
                        Element responseElement2 = doc.createElement("response");
                        backgroundsModuleResponsesElement.appendChild(responseElement2);
                        Element htmlElement = doc.createElement("HTML");
                        responseElement2.appendChild(htmlElement);
                        htmlElement.appendChild(doc.createCDATASection(stringWriter.toString()));
                        this.appendSlots(moduleResponse, doc, responseElement2);
                        this.log.debug((Object)"Result appended");
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Tranformation of background module response from module" + moduleResponse.getModuleDescriptor() + " failed while processing request from user " + user + " accessing from " + req.getRemoteAddr()), (Throwable)e);
                    }
                    continue;
                }
                this.log.error((Object)("Background module response for separate transformation without attached stylesheet returned by module " + moduleResponse.getModuleDescriptor() + " while processing request from user " + user + " accessing from " + req.getRemoteAddr()));
            }
            if (debugDoc != null && debugDoc.getDocumentElement().hasChildNodes()) {
                this.log.debug((Object)("Writing background module XML debug to file " + this.backgroundModuleXMLDebugFile));
                try {
                    XMLUtils.writeXMLFile((Node)debugDoc, (String)(this.applicationFileSystemPath + "WEB-INF/" + this.backgroundModuleXMLDebugFile), (boolean)true, (String)this.encoding);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error writing background module XML debug to file " + this.backgroundModuleXMLDebugFile), (Throwable)e);
                }
            }
        }
    }

    private void appendSlots(BackgroundModuleResponse moduleResponse, Document doc, Element moduleres) {
        if (!CollectionUtils.isEmpty(moduleResponse.getSlots())) {
            Element slotsElement = doc.createElement("slots");
            moduleres.appendChild(slotsElement);
            for (String slot : moduleResponse.getSlots()) {
                slotsElement.appendChild(XMLUtils.createCDATAElement((String)"slot", (Object)slot, (Document)doc));
            }
        }
    }

    private boolean isValidResponse(ModuleResponse moduleResponse) {
        ResponseType responseType = moduleResponse.getResponseType();
        if (responseType == null) {
            return false;
        }
        if (responseType == ResponseType.XML_FOR_CORE_TRANSFORMATION && moduleResponse.getElement() != null) {
            return true;
        }
        if (responseType == ResponseType.HTML && moduleResponse.getHtml() != null) {
            return true;
        }
        return responseType == ResponseType.XML_FOR_SEPARATE_TRANSFORMATION && moduleResponse.getDocument() != null;
    }

    private User getUser(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            try {
                Object object = session.getAttribute("user");
                if (object != null) {
                    if (object instanceof User) {
                        User user = (User)object;
                        if (user.getSession() == null) {
                            this.log.info((Object)("Session for user " + user + " removed from user object during serialization, reconnecting session to user."));
                            session.removeAttribute("user");
                            session.setAttribute("user", (Object)user);
                        }
                        return user;
                    }
                    this.log.warn((Object)("Unknown object type set in session attribute \"user\" in request from " + req.getRemoteAddr() + ". Removing attribute from session."));
                    session.removeAttribute("user");
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public UserHandler getUserHandler() {
        return this.userHandler;
    }

    @Override
    public Section getRootSection() {
        return this.rootSection;
    }

    @Override
    public String getApplicationFileSystemPath() {
        return this.applicationFileSystemPath;
    }

    @Override
    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(Language defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @Override
    public LoginHandler getLoginHandler() {
        return this.loginHandler;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public DataSourceCache getDataSourceCache() {
        return this.dataSourceCache;
    }

    public void destroy() {
        block13: {
            try {
                this.setSystemStatus(SystemStatus.STOPPING);
                long startTime = System.currentTimeMillis();
                this.log.fatal((Object)("Stopping " + VERSION + "..."));
                if (this.rootSection != null) {
                    this.rootSection.unload();
                }
                if (this.stopableEmailHandler != null) {
                    this.stopableEmailHandler.stop();
                    if (this.stopableEmailHandler.hasSenders()) {
                        this.log.warn((Object)(this.stopableEmailHandler.getSenderCount() + " email sender(s) present after section and module shutdown, manually removing sender."));
                        this.stopableEmailHandler.removeSenders();
                    }
                    this.log.info((Object)"Email handler stopped");
                }
                if (this.userHandler != null) {
                    this.userHandler.clear();
                }
                if (this.systemInstanceHandler != null) {
                    this.systemInstanceHandler.clear();
                }
                if (this.eventHandler != null) {
                    this.eventHandler.clear();
                }
                if (this.systemSessionListenerHandler != null) {
                    this.systemSessionListenerHandler.clear();
                }
                if (this.dataSourceCache != null) {
                    this.dataSourceCache.unload();
                }
                if (this.dataSourceType != null && this.dataSourceType == DataSourceType.SystemManaged) {
                    try {
                        ((BasicDataSource)this.dataSource).close();
                    }
                    catch (SQLException e) {
                        this.log.error((Object)("Error closing system datasource " + this.dataSource), (Throwable)e);
                    }
                }
                this.setSystemStatus(SystemStatus.STOPPED);
                this.log.fatal((Object)("***** " + VERSION + " stopped in " + TimeUtils.millisecondsToString((long)(System.currentTimeMillis() - startTime)) + " ms *****"));
            }
            catch (Exception e) {
                if (this.log == null) break block13;
                this.log.error((Object)"Error shutting down system!", (Throwable)e);
            }
        }
    }

    @Override
    public CoreDaoFactory getCoreDaoFactory() {
        return this.coreDaoFactory;
    }

    @Override
    public EmailHandler getEmailHandler() {
        return this.stopableEmailHandler;
    }

    @Override
    public boolean isModuleXMLDebug() {
        return this.moduleXMLDebug;
    }

    @Override
    public void setModuleXMLDebug(boolean moduleXMLDebug) {
        this.moduleXMLDebug = moduleXMLDebug;
    }

    @Override
    public String getModuleXMLDebugFile() {
        return this.moduleXMLDebugFile;
    }

    @Override
    public void setModuleXMLDebugFile(String moduleXMLDebugFile) {
        this.moduleXMLDebugFile = moduleXMLDebugFile;
    }

    @Override
    public boolean isSystemXMLDebug() {
        return this.systemXMLDebug;
    }

    @Override
    public void setSystemXMLDebug(boolean systemXMLDebug) {
        this.systemXMLDebug = systemXMLDebug;
    }

    @Override
    public String getSystemXMLDebugFile() {
        return this.systemXMLDebugFile;
    }

    @Override
    public void setSystemXMLDebugFile(String systemXMLDebugFile) {
        this.systemXMLDebugFile = systemXMLDebugFile;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean isBackgroundModuleXMLDebug() {
        return this.backgroundModuleXMLDebug;
    }

    @Override
    public void setBackgroundModuleXMLDebug(boolean backgroundModuleXMLDebug) {
        this.backgroundModuleXMLDebug = backgroundModuleXMLDebug;
    }

    @Override
    public boolean addBackgroundModuleCacheListener(BackgroundModuleCacheListener listener) {
        return this.globalBackgroundModuleCacheListener.add(listener);
    }

    @Override
    public boolean removeBackgroundModuleCacheListener(BackgroundModuleCacheListener listener) {
        return this.globalBackgroundModuleCacheListener.remove(listener);
    }

    @Override
    public boolean addForegroundModuleCacheListener(ForegroundModuleCacheListener listener) {
        return this.globalForegroundModuleCacheListener.add(listener);
    }

    @Override
    public boolean removeForegroundModuleCacheListener(ForegroundModuleCacheListener listener) {
        return this.globalForegroundModuleCacheListener.remove(listener);
    }

    @Override
    public boolean addSectionCacheListener(SectionCacheListener listener) {
        return this.globalSectionCacheListener.add(listener);
    }

    @Override
    public boolean removeSectionCacheListener(SectionCacheListener listener) {
        return this.globalSectionCacheListener.remove(listener);
    }

    @Override
    public GlobalSectionCacheListener getGlobalSectionCacheListener() {
        return this.globalSectionCacheListener;
    }

    @Override
    public GlobalForegroundModuleCacheListener getGlobalForegroundModuleCacheListener() {
        return this.globalForegroundModuleCacheListener;
    }

    @Override
    public GlobalBackgroundModuleCacheListener getGlobalBackgroundModuleCacheListener() {
        return this.globalBackgroundModuleCacheListener;
    }

    @Override
    public CoreXSLTCacheHandler getCoreXSLTCacheHandler() {
        return this.xsltCacheHandler;
    }

    @Override
    public FilterModuleCache getFilterModuleCache() {
        return this.filterModuleCache;
    }

    @Override
    public InstanceHandler getInstanceHandler() {
        return this.systemInstanceHandler;
    }

    @Override
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public String getBackgroundModuleXMLDebugFile() {
        return this.backgroundModuleXMLDebugFile;
    }

    @Override
    public void setBackgroundModuleXMLDebugFile(String backgroundModuleXMLDebugFile) {
        this.backgroundModuleXMLDebugFile = backgroundModuleXMLDebugFile;
    }

    @Override
    public GroupHandler getGroupHandler() {
        return this.groupHandler;
    }

    @Override
    public Section getSectionInterface(Integer sectionID) {
        return this.sectionMap.get(sectionID);
    }

    @Override
    public void addSection(Section section) {
        if (this.sectionMap.putIfAbsent(section.getSectionDescriptor().getSectionID(), section) != null) {
            this.log.warn((Object)("Section " + section.getSectionDescriptor() + " is already present in section map"));
        }
    }

    @Override
    public void removeSection(Section section) {
        if (!this.sectionMap.remove(section.getSectionDescriptor().getSectionID(), section)) {
            this.log.warn((Object)("Unable to find section " + section.getSectionDescriptor() + " in section map"));
        }
    }

    @Override
    public SystemSessionListenerHandler getSessionListenerHandler() {
        return this.systemSessionListenerHandler;
    }

    static {
        String tempVersion;
        try {
            tempVersion = "OpenHierarchy 1.2.5 (rev. " + StringUtils.readStreamAsString((InputStream)CoreServlet.class.getResourceAsStream("/META-INF/svnrevision.txt")) + ")";
        }
        catch (Exception e) {
            tempVersion = "OpenHierarchy 1.2.5 (rev. unknown)";
        }
        VERSION = tempVersion;
    }
}

