/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.servlets;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.interfaces.FilterChain;
import se.unlogic.hierarchy.core.interfaces.FilterModule;
import se.unlogic.hierarchy.core.interfaces.FilterModuleDescriptor;
import se.unlogic.hierarchy.core.servlets.CoreServlet;
import se.unlogic.webutils.http.URIParser;

public class CoreFilterChain
implements FilterChain {
    private Logger log = Logger.getLogger(this.getClass());
    private CoreServlet coreServlet;
    private List<Map.Entry<FilterModuleDescriptor, FilterModule>> filterModules;
    private int filterIndex;

    public CoreFilterChain(CoreServlet coreServlet, List<Map.Entry<FilterModuleDescriptor, FilterModule>> filterModules) {
        this.coreServlet = coreServlet;
        this.filterModules = filterModules;
    }

    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser) throws TransformerException, IOException {
        if (this.filterIndex < this.filterModules.size()) {
            Map.Entry<FilterModuleDescriptor, FilterModule> entry = this.filterModules.get(this.filterIndex);
            ++this.filterIndex;
            try {
                entry.getValue().doFilter(req, res, user, uriParser, this);
            }
            catch (Throwable t) {
                this.log.error((Object)(t + " thrown by filter module " + entry.getKey() + " for user " + user + " accesing from " + req.getRemoteAddr() + ", skipping filter."), t);
                this.doFilter(req, res, user, uriParser);
            }
        } else {
            this.coreServlet.processRequest(req, res, user, uriParser);
        }
    }
}

