/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.enums.SystemStatus;
import se.unlogic.standardutils.streams.StreamUtils;
import se.unlogic.webutils.http.HTTPUtils;

public abstract class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 3757354033072015112L;
    private static final String FAIL_SAFE_MESSAGE = "failsafe.html";
    private static final String CONFIG_NOT_FOUND_MESSAGE = "confignotfound.html";
    private static final String SERVLET_ERROR_MESSAGE = "servleterror.html";
    protected Logger log;
    private SystemStatus systemStatus;

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(SystemStatus systemStatus) {
        this.systemStatus = systemStatus;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.preProcessRequest(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        this.preProcessRequest(req, res);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) {
        this.preProcessRequest(req, res);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) {
        this.preProcessRequest(req, res);
    }

    protected void preProcessRequest(HttpServletRequest req, HttpServletResponse res) {
        try {
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processing " + req.getMethod() + " request for " + req.getRequestURI() + " " + req.getQueryString() + " from " + req.getRemoteAddr()));
            }
            if (this.systemStatus.equals((Object)SystemStatus.STARTED) || this.systemStatus.equals((Object)SystemStatus.STARTING)) {
                this.processRequest(req, res);
            } else if (this.systemStatus.equals((Object)SystemStatus.FAIL_SAFE)) {
                this.sendMessage(FAIL_SAFE_MESSAGE, res);
            } else if (this.systemStatus.equals((Object)SystemStatus.CONFIG_NOT_FOUND)) {
                this.sendMessage(CONFIG_NOT_FOUND_MESSAGE, res);
            }
            if (this.log != null) {
                this.log.debug((Object)"Request processed.");
            }
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.error((Object)"Error in servlet", e);
            } else {
                System.out.println("Error in BaseServlet, printing stacktrace...");
                e.printStackTrace();
            }
            try {
                this.sendMessage(SERVLET_ERROR_MESSAGE, res);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public abstract void init(boolean var1) throws ServletException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void sendMessage(String filename, HttpServletResponse res) {
        InputStream inputStream = null;
        try {
            File customMessageFile = new File(this.getServletContext().getRealPath("/") + "WEB-INF/errormessages/" + filename);
            inputStream = customMessageFile.canRead() ? new FileInputStream(customMessageFile) : ((Object)((Object)this)).getClass().getResourceAsStream("/se/unlogic/hierarchy/core/errormessages/" + filename);
            HTTPUtils.sendReponse((InputStream)inputStream, (String)"text/html", (HttpServletResponse)res);
        }
        catch (IOException iOException) {
            StreamUtils.closeStream(inputStream);
            catch (Throwable throwable) {
                StreamUtils.closeStream(inputStream);
                throw throwable;
            }
        }
        StreamUtils.closeStream((InputStream)inputStream);
    }
}

