/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.sections;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.Breadcrumb;
import se.unlogic.hierarchy.core.beans.MenuItem;
import se.unlogic.hierarchy.core.beans.SectionMenu;
import se.unlogic.hierarchy.core.beans.SectionMenuItem;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.cache.BackgroundModuleCache;
import se.unlogic.hierarchy.core.cache.BackgroundModuleXSLTCache;
import se.unlogic.hierarchy.core.cache.ForegroundModuleCache;
import se.unlogic.hierarchy.core.cache.ForegroundModuleXSLTCache;
import se.unlogic.hierarchy.core.cache.MenuItemCache;
import se.unlogic.hierarchy.core.cache.SectionCache;
import se.unlogic.hierarchy.core.comparators.PriorityComparator;
import se.unlogic.hierarchy.core.enums.HTTPProtocol;
import se.unlogic.hierarchy.core.enums.ResponseType;
import se.unlogic.hierarchy.core.enums.SectionStatus;
import se.unlogic.hierarchy.core.exceptions.AccessDeniedException;
import se.unlogic.hierarchy.core.exceptions.ForegroundNullResponseException;
import se.unlogic.hierarchy.core.exceptions.ProtocolRedirectException;
import se.unlogic.hierarchy.core.exceptions.RequestException;
import se.unlogic.hierarchy.core.exceptions.SectionDefaultURINotFoundException;
import se.unlogic.hierarchy.core.exceptions.SectionDefaultURINotSetException;
import se.unlogic.hierarchy.core.exceptions.URINotFoundException;
import se.unlogic.hierarchy.core.exceptions.UnhandledModuleException;
import se.unlogic.hierarchy.core.interfaces.BackgroundModule;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleResponse;
import se.unlogic.hierarchy.core.interfaces.FullSectionInterface;
import se.unlogic.hierarchy.core.interfaces.FullSystemInterface;
import se.unlogic.hierarchy.core.interfaces.ModuleAccessDeniedHandler;
import se.unlogic.hierarchy.core.interfaces.RootSectionInterface;
import se.unlogic.hierarchy.core.interfaces.SectionAccessDeniedHandler;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionInterface;
import se.unlogic.hierarchy.core.utils.AccessUtils;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.enums.Order;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.webutils.http.URIParser;

public class Section
implements RootSectionInterface,
FullSectionInterface {
    private static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator(Order.ASC);
    protected Logger log = Logger.getLogger(this.getClass());
    private ForegroundModuleCache foregroundModuleCache;
    private BackgroundModuleCache backgroundModuleCache;
    private MenuItemCache menuCache;
    private ForegroundModuleXSLTCache foregroundModuleXSLTCache;
    private BackgroundModuleXSLTCache backgroundModuleXSLTCache;
    private SectionCache sectionCache;
    private FullSystemInterface systemInterface;
    private SectionDescriptor sectionDescriptor;
    private SectionInterface parentSectionInterface;
    private SectionStatus sectionStatus;
    private ArrayList<SectionAccessDeniedHandler> sectionAccessDeniedHandlers;
    private ArrayList<ModuleAccessDeniedHandler> moduleAccessDeniedHandlers;
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final Lock r = this.rwl.readLock();
    protected final Lock w = this.rwl.writeLock();
    private final ReentrantReadWriteLock sectionAccessDeniedHandlerLock = new ReentrantReadWriteLock();
    private final Lock sectionAccessDeniedHandlerReadLock = this.sectionAccessDeniedHandlerLock.readLock();
    private final Lock sectionAccessDeniedHandlerWriteLock = this.sectionAccessDeniedHandlerLock.writeLock();
    private final ReentrantReadWriteLock moduleAccessDeniedHandlerLock = new ReentrantReadWriteLock();
    private final Lock moduleAccessDeniedHandlerReadLock = this.moduleAccessDeniedHandlerLock.readLock();
    private final Lock moduleAccessDeniedHandlerWriteLock = this.moduleAccessDeniedHandlerLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Section(SectionDescriptor sectionDescriptor, SectionInterface parentSectionInterface, FullSystemInterface systemInterface) {
        this.w.lock();
        try {
            this.log.info((Object)("Section " + sectionDescriptor + " starting..."));
            this.sectionStatus = SectionStatus.STARTING;
            this.sectionDescriptor = sectionDescriptor;
            this.parentSectionInterface = parentSectionInterface;
            this.systemInterface = systemInterface;
            this.menuCache = new MenuItemCache(systemInterface.getCoreDaoFactory(), sectionDescriptor);
            this.foregroundModuleXSLTCache = new ForegroundModuleXSLTCache(systemInterface.getApplicationFileSystemPath());
            this.foregroundModuleCache = new ForegroundModuleCache(this);
            this.foregroundModuleCache.addCacheListener(this.menuCache);
            this.foregroundModuleCache.addCacheListener(this.foregroundModuleXSLTCache);
            this.foregroundModuleCache.addCacheListener(systemInterface.getGlobalForegroundModuleCacheListener());
            this.backgroundModuleXSLTCache = new BackgroundModuleXSLTCache(systemInterface.getApplicationFileSystemPath());
            this.backgroundModuleCache = new BackgroundModuleCache(this);
            this.backgroundModuleCache.addCacheListener(this.backgroundModuleXSLTCache);
            this.backgroundModuleCache.addCacheListener(systemInterface.getGlobalBackgroundModuleCacheListener());
            this.sectionCache = new SectionCache(this);
            this.sectionCache.addCacheListener(this.menuCache);
            this.sectionCache.addCacheListener(systemInterface.getGlobalSectionCacheListener());
            this.sectionStatus = SectionStatus.STARTED;
            systemInterface.addSection(this);
            this.log.info((Object)("Section " + this.sectionDescriptor + " started"));
        }
        finally {
            this.w.unlock();
        }
    }

    public void cacheModuleAndSections() {
        this.w.lock();
        try {
            this.log.info((Object)("Section " + this.sectionDescriptor + " caching modules..."));
            try {
                this.foregroundModuleCache.cacheModules(false);
                this.backgroundModuleCache.cacheModules(false);
            }
            catch (Exception e) {
                this.log.error((Object)("Error caching modules for section " + this.sectionDescriptor), (Throwable)e);
            }
            this.log.info((Object)("Section " + this.sectionDescriptor + " caching subscections..."));
            try {
                this.sectionCache.cacheSections();
            }
            catch (Exception e) {
                this.log.error((Object)("Error caching subsections for section " + this.sectionDescriptor), (Throwable)e);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void update(SectionDescriptor sectionDescriptor) {
        this.w.lock();
        try {
            this.sectionDescriptor = sectionDescriptor;
            this.menuCache.setSectionDescriptor(sectionDescriptor);
        }
        finally {
            this.w.unlock();
        }
    }

    public void unload() {
        this.w.lock();
        try {
            this.log.info((Object)("Unloading section " + this.sectionDescriptor));
            this.sectionStatus = SectionStatus.STOPPING;
            this.foregroundModuleCache.unload();
            this.backgroundModuleCache.unload();
            this.sectionCache.unload();
            this.systemInterface.removeSection(this);
            this.sectionStatus = SectionStatus.STOPPED;
            this.log.info((Object)("Section " + this.sectionDescriptor + " unloaded"));
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ForegroundModuleResponse processRequest(HttpServletRequest req, HttpServletResponse res, User user, URIParser uriParser, HTTPProtocol enforcedHTTPProtocol) throws RequestException {
        this.r.lock();
        if (this.sectionDescriptor.getRequiredProtocol() != null) {
            enforcedHTTPProtocol = this.sectionDescriptor.getRequiredProtocol();
        }
        isDefaultURI = false;
        try {
            block48: {
                block47: {
                    if (uriParser.size() == 0) {
                        if (user == null) {
                            if (StringUtils.isEmpty((String)this.sectionDescriptor.getAnonymousDefaultURI())) {
                                throw new SectionDefaultURINotSetException(this.sectionDescriptor, false);
                            }
                            uriParser.addToURI(this.sectionDescriptor.getAnonymousDefaultURI());
                            isDefaultURI = true;
                        } else {
                            if (StringUtils.isEmpty((String)this.sectionDescriptor.getUserDefaultURI())) {
                                throw new SectionDefaultURINotSetException(this.sectionDescriptor, true);
                            }
                            uriParser.addToURI(this.sectionDescriptor.getUserDefaultURI());
                            isDefaultURI = true;
                        }
                    }
                    if (uriParser.size() >= 1 && (sectionCacheEntry = this.sectionCache.getEntry(uriParser.get(0))) != null) {
                        if (AccessUtils.checkAccess(user, sectionCacheEntry.getKey())) {
                            moduleResponse = sectionCacheEntry.getValue().processRequest(req, res, user, uriParser.getNextLevel(), enforcedHTTPProtocol);
                            if (moduleResponse != null && !res.isCommitted()) {
                                if (moduleResponse.isUserChanged()) {
                                    user = (User)req.getSession(true).getAttribute("user");
                                }
                                moduleResponse.setMenu(this.menuCache.getUserMenu(user, moduleResponse.getMenu(), uriParser));
                                if (this.sectionDescriptor.hasBreadCrumb() && !moduleResponse.isExcludeSectionBreadcrumbs()) {
                                    moduleResponse.addBreadcrumbFirst(this.getBreadcrumb());
                                }
                                if ((backgroundModuleResponses = this.getBackgroundModuleResponses(req, user, uriParser)) != null) {
                                    moduleResponse.addBackgroundModuleResponses((List<BackgroundModuleResponse>)backgroundModuleResponses);
                                }
                            }
                            backgroundModuleResponses = moduleResponse;
                            return backgroundModuleResponses;
                        }
                        this.sectionAccessDeniedHandlerReadLock.lock();
                        try {
                            if (this.sectionAccessDeniedHandlers == null) throw new AccessDeniedException(sectionCacheEntry.getKey());
                            for (SectionAccessDeniedHandler handler : this.sectionAccessDeniedHandlers) {
                                try {
                                    if (!handler.supportsRequest(req, user, uriParser, sectionCacheEntry.getKey())) continue;
                                    handler.handleRequest(req, res, user, uriParser, sectionCacheEntry.getKey());
                                    break;
                                }
                                catch (Throwable e) {
                                    this.log.error((Object)("Error in section access denied handler " + handler), e);
                                }
                            }
                            if (res.isCommitted() == false) throw new AccessDeniedException(sectionCacheEntry.getKey());
                            moduleResponse = null;
                            return moduleResponse;
                        }
                        finally {
                            this.sectionAccessDeniedHandlerReadLock.unlock();
                        }
                    }
                    if (uriParser.size() < 1 || (moduleCacheEntry = this.foregroundModuleCache.getEntry(uriParser.get(0))) == null) ** GOTO lbl95
                    if (!AccessUtils.checkAccess(user, moduleCacheEntry.getKey())) break block48;
                    requiredHTTPProtocol = moduleCacheEntry.getKey().getRequiredProtocol();
                    currentHTTPProtocol = req.isSecure() != false ? HTTPProtocol.HTTPS : HTTPProtocol.HTTP;
                    try {
                        if (requiredHTTPProtocol == null || currentHTTPProtocol.equals((Object)requiredHTTPProtocol)) break block47;
                        res.sendRedirect(requiredHTTPProtocol.toString().toLowerCase() + "://" + req.getServerName() + req.getContextPath() + uriParser.getFormattedURI());
                        var11_19 = null;
                        return var11_19;
                    }
                    catch (IOException e) {
                        throw new ProtocolRedirectException(this.sectionDescriptor, moduleCacheEntry.getKey(), e);
                    }
                }
                if (requiredHTTPProtocol == null && enforcedHTTPProtocol != null && !currentHTTPProtocol.equals((Object)enforcedHTTPProtocol)) {
                    res.sendRedirect(enforcedHTTPProtocol.toString().toLowerCase() + "://" + req.getServerName() + req.getContextPath() + uriParser.getFormattedURI());
                    var11_20 = null;
                    return var11_20;
                }
                ** try [egrp 8[TRYBLOCK] [5, 6 : 851->1069)] { 
lbl-1000:
                // 1 sources

                {
                    moduleResponse = moduleCacheEntry.getValue().processRequest(req, res, user, uriParser);
                    if (!res.isCommitted()) {
                        if (moduleResponse == null) throw new ForegroundNullResponseException();
                        if (moduleResponse.isUserChanged()) {
                            user = (User)req.getSession(true).getAttribute("user");
                        }
                        moduleResponse.setMenu(this.menuCache.getUserMenu(user, null, uriParser));
                        if (moduleResponse.getResponseType() == ResponseType.XML_FOR_SEPARATE_TRANSFORMATION && moduleResponse.getTransformer() == null) {
                            moduleResponse.setTransformer(this.foregroundModuleXSLTCache.getModuleTranformer(moduleCacheEntry.getKey()));
                        }
                        moduleResponse.setModuleDescriptor(moduleCacheEntry.getKey());
                        if (this.sectionDescriptor.hasBreadCrumb() && !moduleResponse.isExcludeSectionBreadcrumbs()) {
                            moduleResponse.addBreadcrumbFirst(this.getBreadcrumb());
                        }
                        if ((backgroundModuleResponses = this.getBackgroundModuleResponses(req, user, uriParser)) != null) {
                            moduleResponse.addBackgroundModuleResponses(backgroundModuleResponses);
                        }
                    }
                    var12_26 = moduleResponse;
                    return var12_26;
                }
lbl80:
                // 1 sources

                catch (RequestException e) {
                    e.setSectionDescriptor(this.sectionDescriptor);
                    e.setModuleDescriptor(moduleCacheEntry.getKey());
                    throw e;
                }
lbl84:
                // 1 sources

                catch (Throwable t) {
                    throw new UnhandledModuleException(this.sectionDescriptor, moduleCacheEntry.getKey(), t);
                }
            }
            this.moduleAccessDeniedHandlerReadLock.lock();
            if (this.moduleAccessDeniedHandlers == null) ** GOTO lbl114
            var9_14 = this.moduleAccessDeniedHandlers.iterator();
            ** GOTO lbl101
            {
                catch (Throwable var13_27) {
                    this.moduleAccessDeniedHandlerReadLock.unlock();
                    throw var13_27;
                }
lbl95:
                // 1 sources

                if (isDefaultURI == false) throw new URINotFoundException(this.sectionDescriptor, uriParser);
                if (user != null) {
                    v0 = true;
                    throw new SectionDefaultURINotFoundException(this.sectionDescriptor, uriParser, v0);
                }
                v0 = false;
                throw new SectionDefaultURINotFoundException(this.sectionDescriptor, uriParser, v0);
lbl101:
                // 3 sources

                while (var9_14.hasNext()) {
                    handler = var9_14.next();
                    try {
                        if (!handler.supportsRequest(req, user, uriParser, moduleCacheEntry.getKey())) continue;
                        handler.handleRequest(req, res, user, uriParser, moduleCacheEntry.getKey());
                        break;
                    }
                    catch (Throwable e) {
                        this.log.error((Object)("Error in module access denied handler " + handler), e);
                    }
                }
                if (res.isCommitted()) {
                    var9_14 = null;
                    this.moduleAccessDeniedHandlerReadLock.unlock();
                    return var9_14;
                }
lbl114:
                // 3 sources

                ** try [egrp 13[TRYBLOCK] [16 : 1302->1392)] { 
lbl115:
                // 1 sources

                this.moduleAccessDeniedHandlerReadLock.unlock();
                throw new AccessDeniedException(this.sectionDescriptor, moduleCacheEntry.getKey());
            }
        }
lbl117:
        // 2 sources

        catch (RequestException e) {
            e.setMenu(this.menuCache.getUserMenu(user, e.getMenu(), uriParser));
            backgroundModuleResponses = this.getBackgroundModuleResponses(req, user, uriParser);
            if (backgroundModuleResponses == null) throw e;
            e.addBackgroundModuleResponses(backgroundModuleResponses);
            throw e;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Breadcrumb getBreadcrumb() {
        return new Breadcrumb(this.sectionDescriptor);
    }

    private List<BackgroundModuleResponse> getBackgroundModuleResponses(HttpServletRequest req, User user, URIParser uriParser) {
        ArrayList<BackgroundModuleResponse> bgResponses = null;
        List backgroundModuleEntries = this.backgroundModuleCache.getEntries(uriParser.getRemainingURI(), user);
        if (!CollectionUtils.isEmpty(backgroundModuleEntries)) {
            for (Map.Entry bgEntry : backgroundModuleEntries) {
                try {
                    Transformer transformer;
                    BackgroundModuleResponse response = ((BackgroundModule)bgEntry.getValue()).processRequest(req, user, uriParser);
                    if (response == null) continue;
                    if (CollectionUtils.isEmpty(response.getSlots())) {
                        response.setSlots(((BackgroundModuleDescriptor)bgEntry.getKey()).getSlots());
                    }
                    if (response.getResponseType() == ResponseType.XML_FOR_SEPARATE_TRANSFORMATION && response.getTransformer() == null && (transformer = this.backgroundModuleXSLTCache.getModuleTranformer((BackgroundModuleDescriptor)bgEntry.getKey())) != null) {
                        response.setTransformer(transformer);
                    }
                    response.setModuleDescriptor((BackgroundModuleDescriptor)bgEntry.getKey());
                    if (bgResponses == null) {
                        bgResponses = new ArrayList<BackgroundModuleResponse>();
                    }
                    bgResponses.add(response);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Error thrown from background module " + bgEntry.getKey() + " in section " + this.sectionDescriptor + " while processing request for user " + user), t);
                }
            }
        }
        return bgResponses;
    }

    @Override
    public int getReadLockCount() {
        return this.rwl.getReadLockCount();
    }

    public int getSectionAccessDeniedHandlerLockCount() {
        return this.sectionAccessDeniedHandlerLock.getReadLockCount();
    }

    public int getModuleAccessDeniedHandlerLockCount() {
        return this.moduleAccessDeniedHandlerLock.getReadLockCount();
    }

    @Override
    public ForegroundModuleCache getForegroundModuleCache() {
        return this.foregroundModuleCache;
    }

    @Override
    public BackgroundModuleCache getBackgroundModuleCache() {
        return this.backgroundModuleCache;
    }

    @Override
    public MenuItemCache getMenuCache() {
        return this.menuCache;
    }

    @Override
    public ForegroundModuleXSLTCache getModuleXSLTCache() {
        return this.foregroundModuleXSLTCache;
    }

    @Override
    public SectionCache getSectionCache() {
        return this.sectionCache;
    }

    @Override
    public FullSystemInterface getSystemInterface() {
        return this.systemInterface;
    }

    @Override
    public SectionDescriptor getSectionDescriptor() {
        return this.sectionDescriptor;
    }

    @Override
    public SectionInterface getParentSectionInterface() {
        return this.parentSectionInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SectionMenu getFullMenu(User user, URIParser uriParser) {
        this.r.lock();
        try {
            SectionMenu sectionMenu = this.menuCache.getUserMenu(user, null, uriParser);
            if (!sectionMenu.getMenuItems().isEmpty()) {
                for (int index = 0; index < sectionMenu.getMenuItems().size(); ++index) {
                    Section subSection;
                    Integer sectionID;
                    Map.Entry<SectionDescriptor, Section> entry;
                    MenuItem menuItem = sectionMenu.getMenuItems().get(index);
                    if (!(menuItem instanceof SectionMenuItem) || (entry = this.sectionCache.getEntry(sectionID = ((SectionMenuItem)menuItem).getSubSectionID())) == null || (subSection = this.sectionCache.getSectionInstance(entry.getKey())) == null) continue;
                    URIParser sentURIParser = uriParser != null && menuItem.isSelected() ? uriParser.getNextLevel() : null;
                    SectionMenu subSectionMenu = subSection.getFullMenu(user, sentURIParser);
                    menuItem = ((SectionMenuItem)menuItem).clone(subSectionMenu, false);
                    sectionMenu.getMenuItems().set(index, menuItem);
                }
            }
            SectionMenu sectionMenu2 = sectionMenu;
            return sectionMenu2;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public SectionStatus getSectionStatus() {
        return this.sectionStatus;
    }

    @Override
    public boolean addSectionAccessDeniedHandler(SectionAccessDeniedHandler handler) {
        if (handler == null) {
            return false;
        }
        this.sectionAccessDeniedHandlerWriteLock.lock();
        try {
            if (this.sectionAccessDeniedHandlers == null) {
                this.sectionAccessDeniedHandlers = new ArrayList();
                boolean bl = this.sectionAccessDeniedHandlers.add(handler);
                return bl;
            }
            if (!this.sectionAccessDeniedHandlers.contains(handler)) {
                this.sectionAccessDeniedHandlers.add(handler);
                Collections.sort(this.sectionAccessDeniedHandlers, PRIORITY_COMPARATOR);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sectionAccessDeniedHandlerWriteLock.unlock();
        }
    }

    @Override
    public boolean removeSectionAccessDeniedHandler(SectionAccessDeniedHandler handler) {
        this.sectionAccessDeniedHandlerWriteLock.lock();
        try {
            if (this.sectionAccessDeniedHandlers == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.sectionAccessDeniedHandlers.remove(handler);
            return bl;
        }
        finally {
            if (this.sectionAccessDeniedHandlers != null && this.sectionAccessDeniedHandlers.isEmpty()) {
                this.sectionAccessDeniedHandlers = null;
            }
            this.sectionAccessDeniedHandlerWriteLock.unlock();
        }
    }

    @Override
    public boolean addModuleAccessDeniedHandler(ModuleAccessDeniedHandler handler) {
        if (handler == null) {
            return false;
        }
        this.moduleAccessDeniedHandlerWriteLock.lock();
        try {
            if (this.moduleAccessDeniedHandlers == null) {
                this.moduleAccessDeniedHandlers = new ArrayList();
                boolean bl = this.moduleAccessDeniedHandlers.add(handler);
                return bl;
            }
            if (!this.moduleAccessDeniedHandlers.contains(handler)) {
                this.moduleAccessDeniedHandlers.add(handler);
                Collections.sort(this.moduleAccessDeniedHandlers, PRIORITY_COMPARATOR);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.moduleAccessDeniedHandlerWriteLock.unlock();
        }
    }

    @Override
    public boolean removeModuleAccessDeniedHandler(ModuleAccessDeniedHandler handler) {
        this.moduleAccessDeniedHandlerWriteLock.lock();
        try {
            if (this.moduleAccessDeniedHandlers == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.moduleAccessDeniedHandlers.remove(handler);
            return bl;
        }
        finally {
            if (this.moduleAccessDeniedHandlers != null && this.moduleAccessDeniedHandlers.isEmpty()) {
                this.moduleAccessDeniedHandlers = null;
            }
            this.moduleAccessDeniedHandlerWriteLock.unlock();
        }
    }
}

