/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.populators;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import se.unlogic.hierarchy.core.beans.VirtualMenuItem;
import se.unlogic.hierarchy.core.enums.MenuItemType;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.enums.EnumUtils;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationError;
import se.unlogic.standardutils.validation.ValidationErrorType;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.webutils.http.BeanRequestPopulator;
import se.unlogic.webutils.validation.ValidationUtils;

public class VirtualMenuItemPopulator
implements BeanRequestPopulator<VirtualMenuItem>,
BeanResultSetPopulator<VirtualMenuItem> {
    public VirtualMenuItem populate(HttpServletRequest req) throws ValidationException {
        return this.populate(new VirtualMenuItem(), req);
    }

    public VirtualMenuItem populate(VirtualMenuItem virtualMenuItem, HttpServletRequest req) throws ValidationException {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        String itemtype = req.getParameter("itemtype");
        if (StringUtils.isEmpty((String)itemtype)) {
            validationErrors.add(new ValidationError("itemtype", ValidationErrorType.RequiredField));
        } else {
            MenuItemType menuItemType = (MenuItemType)EnumUtils.toEnum(MenuItemType.class, (String)itemtype);
            if (menuItemType == null) {
                validationErrors.add(new ValidationError("itemtype", ValidationErrorType.InvalidFormat));
            } else {
                virtualMenuItem.setItemType(menuItemType);
            }
        }
        if (virtualMenuItem.getItemType() != null && !virtualMenuItem.getItemType().equals((Object)MenuItemType.BLANK)) {
            virtualMenuItem.setName(ValidationUtils.validateParameter((String)"name", (HttpServletRequest)req, (boolean)true, (Integer)1, (Integer)45, validationErrors));
            virtualMenuItem.setDescription(ValidationUtils.validateParameter((String)"description", (HttpServletRequest)req, (boolean)true, (Integer)1, (Integer)65536, validationErrors));
            virtualMenuItem.setUrl(ValidationUtils.validateParameter((String)"url", (HttpServletRequest)req, (boolean)false, (Integer)1, (Integer)65536, validationErrors));
        } else {
            virtualMenuItem.setName(null);
            virtualMenuItem.setDescription(null);
            virtualMenuItem.setUrl(null);
        }
        virtualMenuItem.setAnonymousAccess(req.getParameter("anonymousAccess") != null);
        virtualMenuItem.setUserAccess(req.getParameter("userAccess") != null);
        virtualMenuItem.setAdminAccess(req.getParameter("adminAccess") != null);
        if (validationErrors.isEmpty()) {
            virtualMenuItem.setAllowedUserIDs(NumberUtils.toInt((String[])req.getParameterValues("user")));
            virtualMenuItem.setAllowedGroupIDs(NumberUtils.toInt((String[])req.getParameterValues("group")));
            return virtualMenuItem;
        }
        throw new ValidationException(validationErrors);
    }

    public VirtualMenuItem populate(ResultSet rs) throws SQLException {
        VirtualMenuItem virtualMenuItem = new VirtualMenuItem();
        virtualMenuItem.setMenuItemID(rs.getInt("menuItemID"));
        virtualMenuItem.setItemType(MenuItemType.valueOf(rs.getString("itemtype")));
        virtualMenuItem.setName(rs.getString("name"));
        virtualMenuItem.setDescription(rs.getString("description"));
        virtualMenuItem.setUrl(rs.getString("url"));
        virtualMenuItem.setAnonymousAccess(rs.getBoolean("anonymousAccess"));
        virtualMenuItem.setUserAccess(rs.getBoolean("userAccess"));
        virtualMenuItem.setAdminAccess(rs.getBoolean("adminAccess"));
        virtualMenuItem.setSectionID(rs.getInt("sectionID"));
        return virtualMenuItem;
    }
}

