/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.beans.UserTypeDescriptor;
import se.unlogic.hierarchy.core.comparators.PriorityComparator;
import se.unlogic.hierarchy.core.enums.UserField;
import se.unlogic.hierarchy.core.exceptions.UnableToAddUserException;
import se.unlogic.hierarchy.core.exceptions.UnableToDeleteUserException;
import se.unlogic.hierarchy.core.exceptions.UnableToUpdateUserException;
import se.unlogic.hierarchy.core.interfaces.MutableUserProvider;
import se.unlogic.hierarchy.core.interfaces.UserFormProvider;
import se.unlogic.hierarchy.core.interfaces.UserProvider;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.enums.Order;
import se.unlogic.standardutils.string.StringUtils;

public class UserHandler {
    private static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator(Order.ASC);
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final Logger log = Logger.getLogger(this.getClass());
    private final ArrayList<UserProvider> userProviders = new ArrayList();

    public boolean addProvider(UserProvider userProvider) {
        if (userProvider == null) {
            return false;
        }
        this.w.lock();
        try {
            if (!this.userProviders.contains(userProvider)) {
                this.userProviders.add(userProvider);
                Collections.sort(this.userProviders, PRIORITY_COMPARATOR);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    public ArrayList<UserProvider> getUserProviders() {
        this.r.lock();
        try {
            ArrayList<UserProvider> arrayList = new ArrayList<UserProvider>(this.userProviders);
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean removeProvider(UserProvider userProvider) {
        this.w.lock();
        try {
            boolean bl = this.userProviders.remove(userProvider);
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    public void sortProviders() {
        this.w.lock();
        try {
            Collections.sort(this.userProviders, PRIORITY_COMPARATOR);
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(Integer userID, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            User user = null;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    user = userProvider.getUser(userID, groups, attributes);
                    if (user == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found user " + user + " in user provider " + userProvider));
                    }
                    User user2 = user;
                    return user2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting user with userID " + userID + " from user provider " + userProvider), (Throwable)e);
                }
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByUsernamePassword(String username, String password, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            User user = null;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    user = userProvider.getUserByUsernamePassword(username, password, groups, attributes);
                    if (user == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found user " + user + " in user provider " + userProvider));
                    }
                    User user2 = user;
                    return user2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting user with username " + username + " from user provider " + userProvider), (Throwable)e);
                }
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<User> getUsers(boolean groups, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends User> userList = new ArrayList<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.getUsers(groups, attributes);
                    if (users == null) continue;
                    userList.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userList.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, UserField.FIRSTNAME.getComparator(Order.ASC));
                }
                object = userList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean contains(UserProvider userProvider) {
        this.r.lock();
        try {
            boolean bl = this.userProviders.contains(userProvider);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean containsAll(Collection<UserProvider> userProviderList) {
        this.r.lock();
        try {
            boolean bl = this.userProviders.containsAll(userProviderList);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isEmpty() {
        this.r.lock();
        try {
            boolean bl = this.userProviders.isEmpty();
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public int size() {
        this.r.lock();
        try {
            int n = this.userProviders.size();
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<User> getUsers(Collection<Integer> userIDs, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            usersLeft = new ArrayList<Integer>(userIDs);
            users = new ArrayList<User>();
            position = 1;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    providerUsers = userProvider.getUsers(usersLeft, groups, attributes);
                    if (providerUsers == null) ** GOTO lbl22
                    users.addAll(providerUsers);
                    if (position >= this.userProviders.size()) ** GOTO lbl22
                    for (User var11_12 : providerUsers) {
                        usersLeft.remove(var11_12.getUserID());
                        if (!usersLeft.isEmpty()) continue;
                        var12_13 = users;
                        return var12_13;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users with userID in " + StringUtils.toCommaSeparatedString(usersLeft) + " from user provider " + userProvider), (Throwable)e);
                }
lbl22:
                // 4 sources

                ++position;
            }
            if (!users.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(users, UserField.FIRSTNAME.getComparator(Order.ASC));
                }
                var7_7 = users;
                return var7_7;
            }
            var7_7 = null;
            return var7_7;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> searchUsers(String query, boolean groups, boolean attributes, Integer maxHits) {
        if (maxHits != null && maxHits < 1) {
            throw new RuntimeException("maxHits has to be null or > 0 ");
        }
        this.r.lock();
        try {
            List<User> list;
            ArrayList<? extends User> userList = new ArrayList<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.searchUsers(query, groups, attributes, maxHits);
                    if (users == null) continue;
                    userList.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users using search query " + query + " from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userList.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, UserField.FIRSTNAME.getComparator(Order.ASC));
                }
                if (maxHits != null && userList.size() > maxHits) {
                    list = userList.subList(0, maxHits);
                    return list;
                }
                list = userList;
                return list;
            }
            list = null;
            return list;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByUsername(String username, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            User user = null;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    user = userProvider.getUserByUsername(username, groups, attributes);
                    if (user == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found user " + user + " in user provider " + userProvider));
                    }
                    User user2 = user;
                    return user2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting user with username " + username + " from user provider " + userProvider), (Throwable)e);
                }
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByEmail(String email, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            User user = null;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    user = userProvider.getUserByEmail(email, groups, attributes);
                    if (user == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found user " + user + " in user provider " + userProvider));
                    }
                    User user2 = user;
                    return user2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting user with email " + email + " from user provider " + userProvider), (Throwable)e);
                }
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByAttribute(String attributeName, String attributeValue, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            User user = null;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    user = userProvider.getUserByAttribute(attributeName, attributeValue, groups, attributes);
                    if (user == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found user " + user + " in user provider " + userProvider));
                    }
                    User user2 = user;
                    return user2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users by attribute name " + attributeName + " with value " + attributeValue + " from user provider " + userProvider), (Throwable)e);
                }
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsersByAttribute(String attributeName, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends User> userList = new ArrayList<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.getUserByAttribute(attributeName, groups, attributes);
                    if (users == null || users == null) continue;
                    userList.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users by attribute name " + attributeName + " from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userList.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, UserField.FIRSTNAME.getComparator(Order.ASC));
                }
                object = userList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsersWithoutAttribute(String attributeName, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends User> userList = new ArrayList<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.getUsersWithoutAttribute(attributeName, groups, attributes);
                    if (users == null || users == null) continue;
                    userList.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users wtihout attribute name " + attributeName + " from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userList.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, UserField.FIRSTNAME.getComparator(Order.ASC));
                }
                object = userList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByEmailPassword(String email, String password, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            User user = null;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    user = userProvider.getUserByEmailPassword(email, password, groups, attributes);
                    if (user == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found user " + user + " in user provider " + userProvider));
                    }
                    User user2 = user;
                    return user2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting user with email " + email + " from user provider " + userProvider), (Throwable)e);
                }
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getUserCount() {
        this.r.lock();
        try {
            Integer userCount = 0;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    userCount = userCount + userProvider.getUserCount();
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting user count from user provider " + userProvider), (Throwable)e);
                }
            }
            Integer n = userCount;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getUserCountByGroup(int groupID) {
        this.r.lock();
        try {
            Integer userCount = 0;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    userCount = userCount + userProvider.getUserCountByGroup(groupID);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting user count for group " + groupID + " from user provider " + userProvider), (Throwable)e);
                }
            }
            Integer n = userCount;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getDisabledUserCount() {
        this.r.lock();
        try {
            Integer userCount = 0;
            for (UserProvider userProvider : this.userProviders) {
                try {
                    userCount = userCount + userProvider.getDisabledUserCount();
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting disabled user count from user provider " + userProvider), (Throwable)e);
                }
            }
            Integer n = userCount;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Character> getUserFirstLetterIndex(UserField filteringField) {
        this.r.lock();
        try {
            Object object;
            TreeSet<Character> letterIndex = new TreeSet<Character>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<Character> providerLetterIndex = userProvider.getUserFirstLetterIndex(filteringField);
                    if (providerLetterIndex == null) continue;
                    letterIndex.addAll(providerLetterIndex);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting user first letter index from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!letterIndex.isEmpty()) {
                object = letterIndex;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsers(UserField sortingField, Order order, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends User> userList = new ArrayList<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.getUsers(sortingField, order, groups, attributes);
                    if (users == null) continue;
                    userList.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userList.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, sortingField.getComparator(order));
                }
                object = userList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsers(UserField filteringField, char startsWith, Order order, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends User> userList = new ArrayList<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.getUsers(filteringField, startsWith, order, groups, attributes);
                    if (users == null) continue;
                    userList.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userList.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, filteringField.getComparator(order));
                }
                object = userList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean canAddUserClass(Class<? extends User> userClass) {
        return this.canAddUserClass(userClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddUserClass(Class<? extends User> userClass, DataSource dataSource) {
        this.r.lock();
        try {
            for (UserProvider userProvider : this.userProviders) {
                MutableUserProvider mutableUserProvider;
                if (!(userProvider instanceof MutableUserProvider) || !(mutableUserProvider = (MutableUserProvider)userProvider).canAddUserClass(userClass) || dataSource != null && !dataSource.equals(mutableUserProvider.getDataSource())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUpdate(User user) {
        this.r.lock();
        try {
            for (UserProvider userProvider : this.userProviders) {
                if (!(userProvider instanceof MutableUserProvider) || !userProvider.isProviderFor(user)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public void addUser(User user) throws UnableToAddUserException {
        this.addUser(user, null);
    }

    public void addUser(User user, DataSource dataSource) throws UnableToAddUserException {
        this.r.lock();
        try {
            for (UserProvider userProvider : this.userProviders) {
                MutableUserProvider mutableUserProvider;
                if (!(userProvider instanceof MutableUserProvider) || !(mutableUserProvider = (MutableUserProvider)userProvider).canAddUserClass(user.getClass()) || dataSource != null && !dataSource.equals(userProvider.getDataSource())) continue;
                try {
                    ((MutableUserProvider)userProvider).addUser(user);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Added user " + user + " using user provider " + userProvider));
                    }
                    return;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error adding user " + user + " using user provider " + userProvider), (Throwable)e);
                }
            }
            if (dataSource == null) {
                throw new UnableToAddUserException("No suitable user provider found for user " + user.getClass());
            }
            throw new UnableToAddUserException("No suitable user provider found for user " + user.getClass() + " and datasource " + dataSource);
        }
        finally {
            this.r.unlock();
        }
    }

    public void updateUser(User user, boolean encryptPassword, boolean updateGroups, boolean updateAttributes) throws UnableToUpdateUserException {
        this.r.lock();
        try {
            for (UserProvider userProvider : this.userProviders) {
                if (!(userProvider instanceof MutableUserProvider) || !userProvider.isProviderFor(user)) continue;
                try {
                    ((MutableUserProvider)userProvider).updateUser(user, encryptPassword, updateGroups, updateAttributes);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Updated user " + user + " using user provider " + userProvider));
                    }
                    return;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error updating user " + user + " using user provider " + userProvider), (Throwable)e);
                }
            }
            throw new UnableToUpdateUserException("No suitable user provider found for user " + user.getClass());
        }
        finally {
            this.r.unlock();
        }
    }

    public void deleteUser(User user) throws UnableToDeleteUserException {
        this.r.lock();
        try {
            for (UserProvider userProvider : this.userProviders) {
                if (!(userProvider instanceof MutableUserProvider) || !userProvider.isProviderFor(user)) continue;
                try {
                    ((MutableUserProvider)userProvider).deleteUser(user);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Deleted user " + user + " using user provider " + userProvider));
                    }
                    return;
                }
                catch (Exception e) {
                    this.log.error((Object)("Deleted user " + user + " using user provider " + userProvider), (Throwable)e);
                }
            }
            throw new UnableToDeleteUserException("No suitable user provider found for user " + user.getClass());
        }
        finally {
            this.r.unlock();
        }
    }

    public int getUserProviderCount() {
        this.r.lock();
        try {
            int n = this.userProviders.size();
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsersByGroup(Integer groupID, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends User> userList = new ArrayList<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.getUsersByGroup(groupID, groups, attributes);
                    if (users == null) continue;
                    userList.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users by groupID " + groupID + " from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userList.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, UserField.FIRSTNAME.getComparator(Order.ASC));
                }
                object = userList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsersByAttribute(String attributeName, String attributeValue, boolean groups, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends User> userList = new ArrayList<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.getUsersByAttribute(attributeName, attributeValue, groups, attributes);
                    if (users == null) continue;
                    userList.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users by attribute name " + attributeName + " with value " + attributeValue + " from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userList.isEmpty()) {
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, UserField.FIRSTNAME.getComparator(Order.ASC));
                }
                object = userList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsersByGroups(List<Integer> groupIDs, boolean attributes) {
        this.r.lock();
        try {
            HashSet<? extends User> userSet = new HashSet<User>();
            for (UserProvider userProvider : this.userProviders) {
                try {
                    List<? extends User> users = userProvider.getUsersByGroups(groupIDs, attributes);
                    if (users == null) continue;
                    userSet.addAll(users);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting users by groupIDs " + StringUtils.toCommaSeparatedString(groupIDs) + " from user provider " + userProvider), (Throwable)e);
                }
            }
            if (!userSet.isEmpty()) {
                ArrayList<User> userList = new ArrayList<User>(userSet);
                if (this.userProviders.size() > 1) {
                    Collections.sort(userList, UserField.FIRSTNAME.getComparator(Order.ASC));
                }
                ArrayList<User> arrayList = userList;
                return arrayList;
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    public void clear() {
        this.w.lock();
        try {
            Iterator<UserProvider> iterator = this.userProviders.iterator();
            while (iterator.hasNext()) {
                this.log.info((Object)("Removing user provider " + iterator.next() + " from user handler"));
                iterator.remove();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFormAddableUserTypes() {
        this.r.lock();
        try {
            for (UserProvider userProvider : this.userProviders) {
                if (!(userProvider instanceof UserFormProvider)) continue;
                UserTypeDescriptor userTypeDescriptor = ((UserFormProvider)((Object)userProvider)).getAddableUserType();
                if (userTypeDescriptor == null) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserTypeDescriptor> getFormAddableUserTypes() {
        this.r.lock();
        try {
            Object object;
            List userTypeDescriptors = null;
            for (UserProvider userProvider : this.userProviders) {
                UserTypeDescriptor userTypeDescriptor;
                if (!(userProvider instanceof UserFormProvider) || (userTypeDescriptor = ((UserFormProvider)((Object)userProvider)).getAddableUserType()) == null) continue;
                userTypeDescriptors = CollectionUtils.addAndInstantiateIfNeeded((List)userTypeDescriptors, (Object)userTypeDescriptor);
            }
            if (userTypeDescriptors != null) {
                if (userTypeDescriptors.size() > 1) {
                    Collections.sort(userTypeDescriptors);
                }
                object = userTypeDescriptors;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserFormProvider getUserFormProvider(String userTypeID) {
        this.r.lock();
        try {
            for (UserProvider userProvider : this.userProviders) {
                UserTypeDescriptor userTypeDescriptor;
                if (!(userProvider instanceof UserFormProvider) || (userTypeDescriptor = ((UserFormProvider)((Object)userProvider)).getAddableUserType()) == null || !userTypeDescriptor.getUserTypeID().equals(userTypeID)) continue;
                UserFormProvider userFormProvider = (UserFormProvider)((Object)userProvider);
                return userFormProvider;
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserFormProvider getUserFormProvider(User user) {
        this.r.lock();
        try {
            for (UserProvider userProvider : this.userProviders) {
                if (!(userProvider instanceof UserFormProvider) || !userProvider.isProviderFor(user)) continue;
                UserFormProvider userFormProvider = (UserFormProvider)((Object)userProvider);
                return userFormProvider;
            }
            Iterator<UserProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }
}

