/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.handlers;

import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.interfaces.SessionListener;
import se.unlogic.hierarchy.core.interfaces.SessionListenerHandler;

public class SystemSessionListenerHandler
implements HttpSessionListener,
SessionListenerHandler {
    protected Logger log = Logger.getLogger(this.getClass());
    private final CopyOnWriteArraySet<SessionListener> sessionListeners = new CopyOnWriteArraySet();

    @Override
    public boolean addListener(SessionListener listener) {
        return this.sessionListeners.add(listener);
    }

    @Override
    public boolean removeListener(SessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void sessionCreated(HttpSessionEvent event) {
        for (SessionListener listener : this.sessionListeners) {
            try {
                listener.sessionCreated(event);
            }
            catch (Exception e) {
                this.log.error((Object)("Error notifying session listener " + listener), (Throwable)e);
            }
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        for (SessionListener listener : this.sessionListeners) {
            try {
                listener.sessionDestroyed(event);
            }
            catch (Exception e) {
                this.log.error((Object)("Error notifying session listener " + listener), (Throwable)e);
            }
        }
    }

    public void clear() {
        for (SessionListener sessionListener : this.sessionListeners) {
            this.log.warn((Object)("Session listener " + sessionListener + " not removed from handler on shutdown."));
        }
    }
}

