/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.interfaces.GlobalInstanceListener;
import se.unlogic.hierarchy.core.interfaces.InstanceHandler;
import se.unlogic.hierarchy.core.interfaces.InstanceListener;

public class SystemInstanceHandler
implements InstanceHandler {
    protected Logger log = Logger.getLogger(this.getClass());
    private ConcurrentHashMap<Class<?>, Object> instanceMap = new ConcurrentHashMap();
    private CopyOnWriteArraySet<GlobalInstanceListener> globalInstanceListeners = new CopyOnWriteArraySet();
    private ConcurrentHashMap<Class<?>, Set<InstanceListener>> instanceListenerMap = new ConcurrentHashMap();

    @Override
    public <KeyClass, InstanceType extends KeyClass> boolean addInstance(Class<KeyClass> key, InstanceType instance) {
        if (key == null || instance == null) {
            throw new NullPointerException("Key and instance cannot be null");
        }
        Object registeredInstance = this.instanceMap.putIfAbsent(key, instance);
        if (registeredInstance == null) {
            this.log.info((Object)("Instance " + instance + " added for key " + key));
            for (GlobalInstanceListener globalInstanceListener : this.globalInstanceListeners) {
                try {
                    globalInstanceListener.instanceAdded(key, instance);
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("Error notifying global instance listener " + globalInstanceListener + " regarding instace of class " + key), (Throwable)e);
                }
            }
            Set<InstanceListener> instanceListeners = this.instanceListenerMap.get(key);
            if (instanceListeners != null) {
                for (InstanceListener instanceListener : instanceListeners) {
                    try {
                        instanceListener.instanceAdded(key, instance);
                    }
                    catch (RuntimeException e) {
                        this.log.error((Object)("Error notifying instance listener " + instanceListeners + " regarding instace of class " + key), (Throwable)e);
                    }
                }
            }
            return true;
        }
        return registeredInstance == instance;
    }

    @Override
    public <KeyClass, InstanceType extends KeyClass> boolean removeInstance(Class<KeyClass> key) {
        Object instance = this.instanceMap.remove(key);
        this.log.info((Object)("Instance " + instance + " removed for key " + key));
        if (instance != null) {
            Set<InstanceListener> instanceListeners = this.instanceListenerMap.get(key);
            if (instanceListeners != null) {
                for (InstanceListener instanceListener : instanceListeners) {
                    instanceListener.instanceRemoved(key, instance);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public <KeyClass, InstanceType extends KeyClass> InstanceType getInstance(Class<KeyClass> key) {
        return (InstanceType)this.instanceMap.get(key);
    }

    @Override
    public <KeyClass> boolean containsInstance(Class<KeyClass> key) {
        return this.instanceMap.contains(key);
    }

    @Override
    public List<Class<?>> getKeys() {
        return new ArrayList(this.instanceMap.keySet());
    }

    @Override
    public void addGlobalInstanceListener(GlobalInstanceListener listener) {
        this.globalInstanceListeners.add(listener);
    }

    @Override
    public void removeGlobalInstanceListener(GlobalInstanceListener listener) {
        this.globalInstanceListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KeyClass, InstanceType extends KeyClass> void addInstanceListener(Class<KeyClass> key, InstanceListener<KeyClass> listener) {
        SystemInstanceHandler systemInstanceHandler = this;
        synchronized (systemInstanceHandler) {
            Set<InstanceListener> listeners = this.instanceListenerMap.get(key);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<InstanceListener>();
                this.instanceListenerMap.put(key, listeners);
            }
            listeners.add(listener);
        }
        Object instance = this.instanceMap.get(key);
        if (instance != null) {
            listener.instanceAdded(key, instance);
        }
    }

    @Override
    public synchronized <KeyClass> void removeInstanceListener(Class<KeyClass> key, InstanceListener<KeyClass> listener) {
        Set<InstanceListener> listeners = this.instanceListenerMap.get(key);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.instanceListenerMap.remove(key);
            }
        }
    }

    public synchronized void clear() {
        for (Map.Entry<Class<?>, Object> entry : this.instanceMap.entrySet()) {
            this.log.warn((Object)("Instance for type " + entry.getKey().getName() + " implemented by " + entry.getValue().getClass() + " not removed from instance handler on shutdown."));
        }
        this.instanceMap.clear();
        for (Map.Entry<Class<?>, Object> entry : this.instanceListenerMap.entrySet()) {
            for (InstanceListener listener : (Set)entry.getValue()) {
                this.log.warn((Object)("Instance listener for type " + entry.getKey().getName() + " implemented by " + listener.getClass() + " not removed from instance handler on shutdown."));
            }
        }
        this.instanceListenerMap.clear();
        for (GlobalInstanceListener globalInstanceListener : this.globalInstanceListeners) {
            this.log.warn((Object)("Global instance listener implemented by " + globalInstanceListener.getClass() + " not removed from instance handler on shutdown."));
        }
        this.globalInstanceListeners.clear();
    }
}

