/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.handlers;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.comparators.PriorityComparator;
import se.unlogic.hierarchy.core.enums.EventSource;
import se.unlogic.hierarchy.core.enums.EventTarget;
import se.unlogic.hierarchy.core.interfaces.EventHandler;
import se.unlogic.hierarchy.core.interfaces.EventListener;
import se.unlogic.hierarchy.core.interfaces.GlobalEventListener;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.enums.Order;

public class SystemEventHandler
implements EventHandler {
    private static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator(Order.ASC);
    protected Logger log = Logger.getLogger(this.getClass());
    private ConcurrentHashMap<Class<?>, ConcurrentHashMap<Class<?>, List<EventListener>>> listenerMap = new ConcurrentHashMap();
    private CopyOnWriteArrayList<GlobalEventListener> globalEventListeners = new CopyOnWriteArrayList();

    @Override
    public <E extends Serializable> void sendEvent(Class<?> key, E event, EventTarget eventTarget) {
        this.sendEvent(key, event, null, eventTarget, EventSource.LOCAL);
    }

    @Override
    public <E extends Serializable> void sendEvent(Class<?> key, E event, Object sender, EventTarget eventTarget) {
        this.sendEvent(key, event, sender, eventTarget, EventSource.LOCAL);
    }

    @Override
    public <E extends Serializable> void sendEvent(Class<?> key, E event, Object sender, EventTarget eventTarget, EventSource eventSource) {
        List<EventListener> eventListeners;
        ConcurrentHashMap<Class<?>, List<EventListener>> eventTypeMap;
        if (event == null) {
            throw new NullPointerException("event cannot be null");
        }
        if (eventTarget == null) {
            throw new NullPointerException("targetScope cannot be null");
        }
        if (eventSource == null) {
            throw new NullPointerException("sourceScope cannot be null");
        }
        if (eventTarget.isLocal() && (eventTypeMap = this.listenerMap.get(key)) != null && (eventListeners = eventTypeMap.get(event.getClass())) != null && !eventListeners.isEmpty()) {
            for (EventListener eventListener : eventListeners) {
                if (sender != null && sender == eventListener) continue;
                try {
                    eventListener.processEvent(event, eventSource);
                }
                catch (Throwable e) {
                    this.log.error((Object)("Error notifying event listener " + eventListener + " regarding event for class " + key.getClass() + " and event type " + event.getClass()), e);
                }
            }
        }
        for (GlobalEventListener globalEventListener : this.globalEventListeners) {
            try {
                if (sender != null && sender == globalEventListener) continue;
                globalEventListener.processEvent(key, event, eventTarget, eventSource);
            }
            catch (Throwable e) {
                this.log.error((Object)("Error notifying global event listener " + globalEventListener + " regarding event for class " + event.getClass() + " and event type " + event.getClass()), e);
            }
        }
    }

    @Override
    public synchronized <L extends Serializable, E extends L> boolean addEventListener(Class<?> key, Class<E> eventType, EventListener<L> listener) {
        ConcurrentHashMap<Class<Object>, List<EventListener<Object>>> eventTypeMap = this.listenerMap.get(key);
        if (eventTypeMap == null) {
            eventTypeMap = new ConcurrentHashMap();
            this.listenerMap.put(key, eventTypeMap);
            CopyOnWriteArrayList<EventListener<L>> eventListeners = new CopyOnWriteArrayList<EventListener<L>>();
            eventTypeMap.put(eventType, eventListeners);
            return eventListeners.add(listener);
        }
        List<EventListener> eventListeners = eventTypeMap.get(eventType);
        if (eventListeners == null) {
            eventListeners = new CopyOnWriteArrayList<EventListener>();
            eventTypeMap.put(eventType, eventListeners);
            return eventListeners.add(listener);
        }
        if (eventListeners.contains(listener)) {
            return false;
        }
        CollectionUtils.addInOrder(eventListeners, listener, (Comparator)PRIORITY_COMPARATOR);
        return true;
    }

    @Override
    public <L extends Serializable, E extends L> void addEventListener(Class<E> eventType, EventListener<L> listener, Class<?> ... keys) {
        for (Class<?> key : keys) {
            this.addEventListener(key, eventType, listener);
        }
    }

    @Override
    public synchronized <L extends Serializable, E extends L> boolean removeEventListener(Class<?> key, Class<E> eventType, EventListener<L> listener) {
        List<EventListener> eventListeners;
        ConcurrentHashMap<Class<?>, List<EventListener>> eventTypeMap = this.listenerMap.get(key);
        if (eventTypeMap != null && (eventListeners = eventTypeMap.get(eventType)) != null && eventListeners.remove(listener)) {
            if (eventListeners.isEmpty()) {
                eventTypeMap.remove(eventType);
                if (eventTypeMap.isEmpty()) {
                    this.listenerMap.remove(key);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public <L extends Serializable, E extends L> void removeEventListener(Class<E> eventType, EventListener<L> listener, Class<?> ... keys) {
        for (Class<?> key : keys) {
            this.removeEventListener(key, eventType, listener);
        }
    }

    @Override
    public synchronized void removeEventListener(EventListener<?> listener) {
        Iterator<ConcurrentHashMap<Class<?>, List<EventListener>>> listenerMapIterator = this.listenerMap.values().iterator();
        while (listenerMapIterator.hasNext()) {
            ConcurrentHashMap<Class<?>, List<EventListener>> eventTypeMap = listenerMapIterator.next();
            Iterator<List<EventListener>> eventTypeMapIterator = eventTypeMap.values().iterator();
            while (eventTypeMapIterator.hasNext()) {
                List<EventListener> eventListeners = eventTypeMapIterator.next();
                if (!eventListeners.remove(listener) || !eventListeners.isEmpty()) continue;
                eventTypeMapIterator.remove();
                if (!eventTypeMap.isEmpty()) continue;
                listenerMapIterator.remove();
            }
        }
    }

    @Override
    public synchronized boolean addGlobalEventListener(GlobalEventListener listener) {
        if (this.globalEventListeners.contains(listener)) {
            return false;
        }
        CollectionUtils.addInOrder(this.globalEventListeners, (Object)listener, (Comparator)PRIORITY_COMPARATOR);
        return true;
    }

    @Override
    public boolean removeGlobalEventListener(GlobalEventListener listener) {
        return this.globalEventListeners.remove(listener);
    }

    public synchronized void clear() {
        for (Map.Entry<Class<?>, ConcurrentHashMap<Class<?>, List<EventListener>>> entry : this.listenerMap.entrySet()) {
            for (Map.Entry<Class<?>, List<EventListener>> eventTypeEntry : entry.getValue().entrySet()) {
                for (EventListener listener : eventTypeEntry.getValue()) {
                    this.log.warn((Object)("Event listener for type " + entry.getKey() + " and event " + eventTypeEntry.getKey() + " implemented by " + listener.getClass() + " not removed from event handler on shutdown."));
                }
            }
        }
        this.listenerMap.clear();
        for (GlobalEventListener listener : this.globalEventListeners) {
            this.log.warn((Object)("Global event listener implemented by " + listener.getClass() + " not removed from event handler on shutdown."));
        }
        this.globalEventListeners.clear();
    }
}

