/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.interfaces.MutableSettingHandler;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLUtils;

public class SimpleSettingHandler
implements MutableSettingHandler {
    private static final long serialVersionUID = -7497930260527274476L;
    private ConcurrentHashMap<String, List<String>> settingsMap;

    public SimpleSettingHandler(Map<String, List<String>> settingsMap) {
        this.setSettingsMap(settingsMap);
    }

    public SimpleSettingHandler(XMLParser xmlParser) {
        this.settingsMap = new ConcurrentHashMap();
        List settingNodes = xmlParser.getNodes("setting");
        for (XMLParser setting : settingNodes) {
            List values;
            String id = setting.getString("id");
            if (StringUtils.isEmpty((String)id) || (values = setting.getStrings("value")) == null) continue;
            this.settingsMap.put(id, values);
        }
    }

    public SimpleSettingHandler() {
        this.settingsMap = new ConcurrentHashMap(0);
    }

    @Override
    public boolean isSet(String id) {
        return this.settingsMap.containsKey(id);
    }

    @Override
    public String getString(String id) {
        List<String> values = this.settingsMap.get(id);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public Integer getInt(String id) {
        return NumberUtils.toInt((String)this.getString(id));
    }

    @Override
    public Long getLong(String id) {
        return NumberUtils.toLong((String)this.getString(id));
    }

    @Override
    public Double getDouble(String id) {
        return NumberUtils.toDouble((String)this.getString(id));
    }

    @Override
    public Boolean getBoolean(String id) {
        String value = this.getString(id);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public void setSettingsMap(Map<String, List<String>> settingsMap) {
        this.settingsMap = settingsMap != null ? new ConcurrentHashMap<String, List<String>>(settingsMap) : new ConcurrentHashMap();
    }

    @Override
    public boolean isEmpty() {
        return this.settingsMap.isEmpty();
    }

    @Override
    public Set<String> getIDs() {
        return new TreeSet<String>(this.settingsMap.keySet());
    }

    @Override
    public int size() {
        return this.settingsMap.size();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.settingsMap.entrySet();
    }

    @Override
    public List<Double> getDoubles(String id) {
        return NumberUtils.toDouble(this.settingsMap.get(id));
    }

    @Override
    public List<Integer> getInts(String id) {
        return NumberUtils.toInt((Collection)this.settingsMap.get(id));
    }

    @Override
    public List<Long> getLongs(String id) {
        return NumberUtils.toLong(this.settingsMap.get(id));
    }

    @Override
    public List<String> getStrings(String id) {
        return this.settingsMap.get(id);
    }

    @Override
    public boolean getPrimitiveBoolean(String id) {
        String value = this.getString(id);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public Map<String, List<String>> getMap() {
        return new HashMap<String, List<String>>(this.settingsMap);
    }

    @Override
    public void removeSetting(String id) {
        this.settingsMap.remove(id);
    }

    @Override
    public void setSetting(String id, Object value) {
        if (value != null) {
            this.settingsMap.put(id, Collections.singletonList(value.toString()));
        } else {
            this.settingsMap.remove(id);
        }
    }

    @Override
    public void setSetting(String id, List<?> values) {
        if (values != null && !values.isEmpty()) {
            ArrayList<String> stringList = new ArrayList<String>(values.size());
            for (Object object : values) {
                if (object == null) continue;
                stringList.add(object.toString());
            }
            this.settingsMap.put(id, stringList);
        } else {
            this.settingsMap.remove(id);
        }
    }

    @Override
    public void clear() {
        this.settingsMap.clear();
    }

    public Element toXML(Document doc) {
        Element settingsElement = doc.createElement("settings");
        for (Map.Entry<String, List<String>> entry : this.settingsMap.entrySet()) {
            Element settingElement = doc.createElement("setting");
            settingsElement.appendChild(settingElement);
            settingElement.appendChild(XMLUtils.createCDATAElement((String)"id", (Object)entry.getKey(), (Document)doc));
            if (entry.getValue() == null) continue;
            for (String value : entry.getValue()) {
                settingElement.appendChild(XMLUtils.createCDATAElement((String)"value", (Object)value, (Document)doc));
            }
        }
        return settingsElement;
    }

    @Override
    public void setSettings(Map<String, List<String>> settings) {
        this.settingsMap = new ConcurrentHashMap<String, List<String>>(settings);
    }

    @Override
    public void replaceSettings(HashMap<String, List<String>> settingValues) {
        this.settingsMap.putAll(settingValues);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.settingsMap == null ? 0 : this.settingsMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleSettingHandler other = (SimpleSettingHandler)obj;
        return !(this.settingsMap == null ? other.settingsMap != null : !this.settingsMap.equals(other.settingsMap));
    }

    @Override
    public Short getShort(String id) {
        return NumberUtils.toShort((String)this.getString(id));
    }

    @Override
    public Float getFloat(String id) {
        return NumberUtils.toFloat((String)this.getString(id));
    }

    @Override
    public List<Float> getFloats(String id) {
        return NumberUtils.toFloat(this.settingsMap.get(id));
    }
}

