/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.interfaces.AttributeHandler;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.validation.ValidationException;
import se.unlogic.standardutils.xml.XMLParser;
import se.unlogic.standardutils.xml.XMLUtils;

public class SimpleAttributeHandler
implements AttributeHandler {
    private static final long serialVersionUID = -8731009004825362810L;
    protected final HashMap<String, String> attributeMap;

    public SimpleAttributeHandler() {
        this.attributeMap = new HashMap(0);
    }

    public SimpleAttributeHandler(HashMap<String, String> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public SimpleAttributeHandler(XMLParser xmlParser) throws ValidationException {
        this.attributeMap = new HashMap();
        this.populate(xmlParser);
    }

    @Override
    public boolean isSet(String name) {
        return this.attributeMap.containsKey(name);
    }

    @Override
    public String getString(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public Integer getInt(String name) {
        return NumberUtils.toInt((String)this.attributeMap.get(name));
    }

    @Override
    public Long getLong(String name) {
        return NumberUtils.toLong((String)this.attributeMap.get(name));
    }

    @Override
    public Double getDouble(String name) {
        return NumberUtils.toDouble((String)this.attributeMap.get(name));
    }

    @Override
    public Boolean getBoolean(String name) {
        String value = this.attributeMap.get(name);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public boolean isEmpty() {
        return this.attributeMap.isEmpty();
    }

    @Override
    public Set<String> getNames() {
        return new HashSet<String>(this.attributeMap.keySet());
    }

    @Override
    public int size() {
        return this.attributeMap.size();
    }

    @Override
    public boolean getPrimitiveBoolean(String name) {
        return Boolean.parseBoolean(this.attributeMap.get(name));
    }

    @Override
    public Map<String, String> getAttributeMap() {
        return new HashMap<String, String>(this.attributeMap);
    }

    public Element toXML(Document doc) {
        Element attributesElement = doc.createElement("Attributes");
        for (Map.Entry<String, String> entry : this.attributeMap.entrySet()) {
            Element attributeElement = doc.createElement("Attribute");
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)attributeElement, (String)"Name", (String)entry.getKey());
            XMLUtils.appendNewCDATAElement((Document)doc, (Element)attributeElement, (String)"Value", (String)entry.getValue());
            attributesElement.appendChild(attributeElement);
        }
        return attributesElement;
    }

    protected void populate(XMLParser xmlParser) throws ValidationException {
        List attributes = xmlParser.getNodes("Attribute");
        for (XMLParser attribute : attributes) {
            String value;
            String name = attribute.getString("Name");
            if (StringUtils.isEmpty((String)name) || (value = attribute.getString("Value")) == null) continue;
            this.attributeMap.put(name, value);
        }
    }
}

