/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.User;
import se.unlogic.hierarchy.core.comparators.PriorityComparator;
import se.unlogic.hierarchy.core.interfaces.LoginProvider;
import se.unlogic.standardutils.enums.Order;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.webutils.http.URIParser;

public class LoginHandler {
    private static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator(Order.ASC);
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final Logger log = Logger.getLogger(this.getClass());
    private final ArrayList<LoginProvider> loginProviders = new ArrayList();

    public boolean addProvider(LoginProvider loginProvider) {
        if (loginProvider == null) {
            return false;
        }
        this.w.lock();
        try {
            if (!this.loginProviders.contains(loginProvider)) {
                this.loginProviders.add(loginProvider);
                Collections.sort(this.loginProviders, PRIORITY_COMPARATOR);
                boolean bl = true;
                return bl;
            }
            Collections.sort(this.loginProviders, PRIORITY_COMPARATOR);
            boolean bl = false;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    public ArrayList<LoginProvider> getProviders() {
        this.r.lock();
        try {
            ArrayList<LoginProvider> arrayList = new ArrayList<LoginProvider>(this.loginProviders);
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginProvider getProvider(String providerID) {
        this.r.lock();
        try {
            for (LoginProvider loginProvider : this.loginProviders) {
                if (!loginProvider.getProviderDescriptor().getID().equals(providerID)) continue;
                LoginProvider loginProvider2 = loginProvider;
                return loginProvider2;
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    public boolean removeProvider(LoginProvider loginProvider) {
        this.w.lock();
        try {
            boolean bl = this.loginProviders.remove(loginProvider);
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processLoginRequest(HttpServletRequest req, HttpServletResponse res, URIParser uriParser, boolean redirectBack) {
        this.r.lock();
        try {
            for (LoginProvider loginProvider : this.loginProviders) {
                try {
                    if (!loginProvider.supportsRequest(req, uriParser)) {
                        continue;
                    }
                }
                catch (Throwable e) {
                    this.log.error((Object)("Error in login provider " + loginProvider + " while checking support of request from " + req.getRemoteAddr()), e);
                }
                try {
                    String redirectURI = redirectBack ? this.getRedirectURI(req, uriParser) : null;
                    loginProvider.handleRequest(req, res, uriParser, redirectURI);
                    return;
                }
                catch (Throwable e) {
                    block11: {
                        if (!res.isCommitted()) break block11;
                        this.log.error((Object)("Error in login provider " + loginProvider + " after response has been commited while handling request from " + req.getRemoteAddr()), e);
                        this.r.unlock();
                        return;
                    }
                    try {
                        this.log.error((Object)("Error in login provider " + loginProvider + " while handling request from " + req.getRemoteAddr()), e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.r.unlock();
        }
    }

    public String getRedirectURI(HttpServletRequest req, URIParser uriParser) {
        if (!StringUtils.isEmpty((String)uriParser.getFormattedURI())) {
            String redirect = uriParser.getFormattedURI();
            if (!StringUtils.isEmpty((String)req.getQueryString())) {
                redirect = redirect + "?" + req.getQueryString();
            }
            return redirect;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoginProvider> getSupportedLoginProviders(HttpServletRequest req, URIParser uriParser) {
        ArrayList<LoginProvider> supportedProviders = new ArrayList<LoginProvider>(this.loginProviders.size());
        this.r.lock();
        try {
            for (LoginProvider loginProvider : this.loginProviders) {
                try {
                    if (!loginProvider.supportsRequest(req, uriParser)) continue;
                    supportedProviders.add(loginProvider);
                }
                catch (Throwable e) {
                    this.log.error((Object)("Error in login provider " + loginProvider + " while checking support of request from " + req.getRemoteAddr()), e);
                }
            }
        }
        finally {
            this.r.unlock();
        }
        return supportedProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginProvider getSupportedLoginProvider(HttpServletRequest req, URIParser uriParser) {
        this.r.lock();
        try {
            for (LoginProvider loginProvider : this.loginProviders) {
                try {
                    if (!loginProvider.supportsRequest(req, uriParser)) continue;
                    LoginProvider loginProvider2 = loginProvider;
                    return loginProvider2;
                }
                catch (Throwable e) {
                    this.log.error((Object)("Error in login provider " + loginProvider + " while checking support of request from " + req.getRemoteAddr()), e);
                }
            }
        }
        finally {
            this.r.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginUser(HttpServletRequest req, URIParser uriParser, User user) {
        this.r.lock();
        try {
            for (LoginProvider loginProvider : this.loginProviders) {
                try {
                    if (!loginProvider.loginUser(req, uriParser, user)) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    this.log.error((Object)("Error in login provider " + loginProvider + " while logging in user " + user), e);
                }
            }
        }
        finally {
            this.r.unlock();
        }
        return false;
    }

    public void sortProviders() {
        this.w.lock();
        try {
            Collections.sort(this.loginProviders, PRIORITY_COMPARATOR);
        }
        finally {
            this.w.unlock();
        }
    }
}

