/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import se.unlogic.hierarchy.core.beans.Group;
import se.unlogic.hierarchy.core.comparators.PriorityComparator;
import se.unlogic.hierarchy.core.exceptions.UnableToAddGroupException;
import se.unlogic.hierarchy.core.exceptions.UnableToDeleteGroupException;
import se.unlogic.hierarchy.core.exceptions.UnableToUpdateGroupException;
import se.unlogic.hierarchy.core.interfaces.GroupProvider;
import se.unlogic.hierarchy.core.interfaces.MutableGroupProvider;
import se.unlogic.standardutils.collections.ExternalMethodComparator;
import se.unlogic.standardutils.enums.Order;
import se.unlogic.standardutils.string.StringUtils;

public class GroupHandler {
    private static final Comparator<Group> ASC_GROUP_COMPARATOR = new ExternalMethodComparator(Group.class, String.class, "getName", Order.ASC, String.CASE_INSENSITIVE_ORDER);
    private static final Comparator<Group> DESC_GROUP_COMPARATOR = new ExternalMethodComparator(Group.class, String.class, "getName", Order.DESC, String.CASE_INSENSITIVE_ORDER);
    private static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator(Order.ASC);
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final Logger log = Logger.getLogger(this.getClass());
    private final ArrayList<GroupProvider> groupProviders = new ArrayList();

    public static Comparator<Group> getGroupComparator(Order order) {
        if (order == Order.ASC) {
            return ASC_GROUP_COMPARATOR;
        }
        return DESC_GROUP_COMPARATOR;
    }

    public boolean addProvider(GroupProvider groupProvider) {
        if (groupProvider == null) {
            return false;
        }
        this.w.lock();
        try {
            if (!this.groupProviders.contains(groupProvider)) {
                this.groupProviders.add(groupProvider);
                Collections.sort(this.groupProviders, PRIORITY_COMPARATOR);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    public ArrayList<GroupProvider> getGroupProviders() {
        this.r.lock();
        try {
            ArrayList<GroupProvider> arrayList = new ArrayList<GroupProvider>(this.groupProviders);
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean removeProvider(GroupProvider groupProvider) {
        this.w.lock();
        try {
            boolean bl = this.groupProviders.remove(groupProvider);
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    public void sortProviders() {
        this.w.lock();
        try {
            Collections.sort(this.groupProviders, PRIORITY_COMPARATOR);
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean contains(GroupProvider groupProvider) {
        this.r.lock();
        try {
            boolean bl = this.groupProviders.contains(groupProvider);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean containsAll(Collection<GroupProvider> groupProviderList) {
        this.r.lock();
        try {
            boolean bl = this.groupProviders.containsAll(groupProviderList);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean isEmpty() {
        this.r.lock();
        try {
            boolean bl = this.groupProviders.isEmpty();
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public int size() {
        this.r.lock();
        try {
            int n = this.groupProviders.size();
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Group> getGroups(boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends Group> groupList = new ArrayList<Group>();
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    List<? extends Group> groups = groupProvider.getGroups(attributes);
                    if (groups == null) continue;
                    groupList.addAll(groups);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting groups from group provider " + groupProvider), (Throwable)e);
                }
            }
            if (!groupList.isEmpty()) {
                if (this.groupProviders.size() > 1) {
                    Collections.sort(groupList, ASC_GROUP_COMPARATOR);
                }
                object = groupList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> searchGroups(String query, boolean attributes, Integer maxHits) {
        this.r.lock();
        try {
            List<Group> list;
            ArrayList<? extends Group> groupList = new ArrayList<Group>();
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    List<? extends Group> groups = groupProvider.searchGroups(query, attributes, maxHits);
                    if (groups == null) continue;
                    groupList.addAll(groups);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting groups using search query " + query + " from group provider " + groupProvider), (Throwable)e);
                }
            }
            if (!groupList.isEmpty()) {
                if (this.groupProviders.size() > 1) {
                    Collections.sort(groupList, ASC_GROUP_COMPARATOR);
                }
                if (maxHits != null && groupList.size() > maxHits) {
                    list = groupList.subList(0, maxHits);
                    return list;
                }
                list = groupList;
                return list;
            }
            list = null;
            return list;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> searchGroupsWithAttribute(String query, boolean attributes, String attributeName, Integer maxHits) {
        this.r.lock();
        try {
            List<Group> list;
            ArrayList<? extends Group> groupList = new ArrayList<Group>();
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    List<? extends Group> groups = groupProvider.searchGroupsWithAttribute(query, attributes, attributeName, maxHits);
                    if (groups == null) continue;
                    groupList.addAll(groups);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting groups using search query " + query + " and attribute " + attributeName + " from group provider " + groupProvider), (Throwable)e);
                }
            }
            if (!groupList.isEmpty()) {
                if (this.groupProviders.size() > 1) {
                    Collections.sort(groupList, ASC_GROUP_COMPARATOR);
                }
                if (maxHits != null && groupList.size() > maxHits) {
                    list = groupList.subList(0, maxHits);
                    return list;
                }
                list = groupList;
                return list;
            }
            list = null;
            return list;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(Integer groupID, boolean attributes) {
        this.r.lock();
        try {
            Group group = null;
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    group = groupProvider.getGroup(groupID, attributes);
                    if (group == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("found group " + group + " in group provider " + groupProvider));
                    }
                    Group group2 = group;
                    return group2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting group with groupID " + groupID + " from group provider " + groupProvider), (Throwable)e);
                }
            }
            Iterator<GroupProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Group> getGroups(Collection<Integer> groupIDs, boolean attributes) {
        this.r.lock();
        try {
            groupsLeft = new ArrayList<Integer>(groupIDs);
            groups = new ArrayList<Group>();
            position = 1;
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    providerGroups = groupProvider.getGroups(groupsLeft, attributes);
                    if (providerGroups == null) ** GOTO lbl22
                    groups.addAll(providerGroups);
                    if (position >= this.groupProviders.size()) ** GOTO lbl22
                    for (Group var10_11 : providerGroups) {
                        groupsLeft.remove(var10_11.getGroupID());
                        if (!groupsLeft.isEmpty()) continue;
                        var11_12 = groups;
                        return var11_12;
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting groups with groupID in " + StringUtils.toCommaSeparatedString(groupsLeft) + " from group provider " + groupProvider), (Throwable)e);
                }
lbl22:
                // 4 sources

                ++position;
            }
            if (groups.isEmpty()) {
                var6_6 = null;
                return var6_6;
            }
            var6_6 = groups;
            return var6_6;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getGroupsByAttribute(String attributeName, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends Group> groups = new ArrayList<Group>();
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    List<? extends Group> providerGroups = groupProvider.getGroupsByAttribute(attributeName, attributes);
                    if (providerGroups == null) continue;
                    groups.addAll(providerGroups);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting groups by attribute name " + attributeName + " from group provider " + groupProvider), (Throwable)e);
                }
            }
            if (groups.isEmpty()) {
                object = null;
                return object;
            }
            object = groups;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getGroupsByAttribute(String attributeName, String attributeValue, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends Group> groups = new ArrayList<Group>();
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    List<? extends Group> providerGroups = groupProvider.getGroupsByAttribute(attributeName, attributeValue, attributes);
                    if (providerGroups == null) continue;
                    groups.addAll(providerGroups);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting groups by attribute name " + attributeName + " with value " + attributeValue + " from group provider " + groupProvider), (Throwable)e);
                }
            }
            if (groups.isEmpty()) {
                object = null;
                return object;
            }
            object = groups;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroupByAttribute(String attributeName, String attributeValue, boolean attributes) {
        this.r.lock();
        try {
            Group group = null;
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    group = groupProvider.getGroupByAttribute(attributeName, attributeValue, attributes);
                    if (group == null) continue;
                    Group group2 = group;
                    return group2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting group by attribute name " + attributeName + " with value " + attributeValue + " from group provider " + groupProvider), (Throwable)e);
                }
            }
            Iterator<GroupProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroupByAttributes(List<Map.Entry<String, String>> attributeEntries, boolean attributes) {
        this.r.lock();
        try {
            Group group = null;
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    group = groupProvider.getGroupByAttributes(attributeEntries, attributes);
                    if (group == null) continue;
                    Group group2 = group;
                    return group2;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting group by " + attributeEntries.size() + " attributes from group provider " + groupProvider), (Throwable)e);
                }
            }
            Iterator<GroupProvider> iterator = null;
            return iterator;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGroupCount() {
        this.r.lock();
        try {
            Integer groupCount = 0;
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    groupCount = groupCount + groupProvider.getGroupCount();
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting group count from group provider " + groupProvider), (Throwable)e);
                }
            }
            Integer n = groupCount;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getDisabledGroupCount() {
        this.r.lock();
        try {
            Integer groupCount = 0;
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    groupCount = groupCount + groupProvider.getDisabledGroupCount();
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting disabled group count from group provider " + groupProvider), (Throwable)e);
                }
            }
            Integer n = groupCount;
            return n;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getGroups(Order order, char startsWith, boolean users, boolean attributes) {
        this.r.lock();
        try {
            Object object;
            ArrayList<? extends Group> groupList = new ArrayList<Group>();
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    List<? extends Group> groups = groupProvider.getGroups(order, startsWith, attributes);
                    if (groups == null) continue;
                    groupList.addAll(groups);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting groups from group provider " + groupProvider), (Throwable)e);
                }
            }
            if (!groupList.isEmpty()) {
                if (this.groupProviders.size() > 1) {
                    Collections.sort(groupList, GroupHandler.getGroupComparator(order));
                }
                object = groupList;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Character> getGroupFirstLetterIndex() {
        this.r.lock();
        try {
            Object object;
            TreeSet<Character> letterIndex = new TreeSet<Character>();
            for (GroupProvider groupProvider : this.groupProviders) {
                try {
                    List<Character> providerLetterIndex = groupProvider.getGroupFirstLetterIndex();
                    if (providerLetterIndex == null) continue;
                    letterIndex.addAll(providerLetterIndex);
                }
                catch (Exception e) {
                    this.log.error((Object)("Error getting group first letter index from group provider " + groupProvider), (Throwable)e);
                }
            }
            if (!letterIndex.isEmpty()) {
                object = letterIndex;
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.r.unlock();
        }
    }

    public boolean canAddGroupClass(Class<? extends Group> groupClass) {
        return this.canAddGroupClass(groupClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddGroupClass(Class<? extends Group> groupClass, DataSource dataSource) {
        this.r.lock();
        try {
            for (GroupProvider groupProvider : this.groupProviders) {
                MutableGroupProvider mutableGroupProvider;
                if (!(groupProvider instanceof MutableGroupProvider) || !(mutableGroupProvider = (MutableGroupProvider)groupProvider).canAddGroupClass(groupClass) || dataSource != null && !dataSource.equals(mutableGroupProvider.getDataSource())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUpdate(Group group) {
        this.r.lock();
        try {
            for (GroupProvider groupProvider : this.groupProviders) {
                if (!(groupProvider instanceof MutableGroupProvider) || !groupProvider.isProviderFor(group)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    public void addGroup(Group group) throws UnableToAddGroupException {
        this.addGroup(group, null);
    }

    public void addGroup(Group group, DataSource dataSource) throws UnableToAddGroupException {
        this.r.lock();
        try {
            for (GroupProvider groupProvider : this.groupProviders) {
                MutableGroupProvider mutableGroupProvider;
                if (!(groupProvider instanceof MutableGroupProvider) || !(mutableGroupProvider = (MutableGroupProvider)groupProvider).canAddGroupClass(group.getClass()) || dataSource != null && !dataSource.equals(mutableGroupProvider.getDataSource())) continue;
                try {
                    mutableGroupProvider.addGroup(group);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Added group " + group + " using group provider " + mutableGroupProvider));
                    }
                    return;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error adding group " + group + " using group provider " + mutableGroupProvider), (Throwable)e);
                }
            }
            if (dataSource == null) {
                throw new UnableToAddGroupException("No suitable group provider found for group " + group.getClass());
            }
            throw new UnableToAddGroupException("No suitable group provider found for group " + group.getClass() + " and datasource " + dataSource);
        }
        finally {
            this.r.unlock();
        }
    }

    public void updateGroup(Group group, boolean attributes) throws UnableToUpdateGroupException {
        this.r.lock();
        try {
            for (GroupProvider groupProvider : this.groupProviders) {
                if (!(groupProvider instanceof MutableGroupProvider) || !groupProvider.isProviderFor(group)) continue;
                try {
                    ((MutableGroupProvider)groupProvider).updateGroup(group, attributes);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Updated group " + group + " using group provider " + groupProvider));
                    }
                    return;
                }
                catch (Exception e) {
                    this.log.error((Object)("Error updating group " + group + " using group provider " + groupProvider), (Throwable)e);
                }
            }
            throw new UnableToUpdateGroupException("No suitable group provider found for group " + group.getClass());
        }
        finally {
            this.r.unlock();
        }
    }

    public void deleteGroup(Group group) throws UnableToDeleteGroupException {
        this.r.lock();
        try {
            for (GroupProvider groupProvider : this.groupProviders) {
                if (!(groupProvider instanceof MutableGroupProvider) || !groupProvider.isProviderFor(group)) continue;
                try {
                    ((MutableGroupProvider)groupProvider).deleteGroup(group);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Deleted group " + group + " using group provider " + groupProvider));
                    }
                    return;
                }
                catch (Exception e) {
                    this.log.error((Object)("Deleted group " + group + " using group provider " + groupProvider), (Throwable)e);
                }
            }
            throw new UnableToDeleteGroupException("No suitable group provider found for group " + group.getClass());
        }
        finally {
            this.r.unlock();
        }
    }

    public void clear() {
        this.w.lock();
        try {
            Iterator<GroupProvider> iterator = this.groupProviders.iterator();
            while (iterator.hasNext()) {
                this.log.info((Object)("Removing group provider " + iterator.next() + " from group handler"));
                iterator.remove();
            }
        }
        finally {
            this.w.unlock();
        }
    }
}

