/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.globallisteners;

import java.util.concurrent.CopyOnWriteArrayList;
import se.unlogic.hierarchy.core.interfaces.SectionCacheListener;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.sections.Section;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;

public class GlobalSectionCacheListener
implements SectionCacheListener {
    private CopyOnWriteArrayList<SectionCacheListener> cacheListeners = new CopyOnWriteArrayList();

    @Override
    public void sectionCached(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyAlreadyCachedException {
        for (SectionCacheListener cacheListener : this.cacheListeners) {
            cacheListener.sectionCached(sectionDescriptor, sectionInstance);
        }
    }

    @Override
    public void sectionUpdated(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyNotCachedException {
        for (SectionCacheListener cacheListener : this.cacheListeners) {
            cacheListener.sectionUpdated(sectionDescriptor, sectionInstance);
        }
    }

    @Override
    public void sectionUnloaded(SectionDescriptor sectionDescriptor, Section sectionInstance) throws KeyNotCachedException {
        for (SectionCacheListener cacheListener : this.cacheListeners) {
            cacheListener.sectionUnloaded(sectionDescriptor, sectionInstance);
        }
    }

    public boolean add(SectionCacheListener listener) {
        return this.cacheListeners.add(listener);
    }

    public boolean remove(SectionCacheListener listener) {
        return this.cacheListeners.remove(listener);
    }

    public void clear() {
        this.cacheListeners.clear();
    }
}

