/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.globallisteners;

import java.util.concurrent.CopyOnWriteArrayList;
import se.unlogic.hierarchy.core.interfaces.ForegroundModule;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;

public class GlobalForegroundModuleCacheListener
implements ForegroundModuleCacheListener {
    private CopyOnWriteArrayList<ForegroundModuleCacheListener> cacheListeners = new CopyOnWriteArrayList();

    @Override
    public void moduleCached(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        for (ForegroundModuleCacheListener cacheListener : this.cacheListeners) {
            cacheListener.moduleCached(moduleDescriptor, moduleInstance);
        }
    }

    @Override
    public void moduleUpdated(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        for (ForegroundModuleCacheListener cacheListener : this.cacheListeners) {
            cacheListener.moduleUpdated(moduleDescriptor, moduleInstance);
        }
    }

    @Override
    public void moduleUnloaded(ForegroundModuleDescriptor moduleDescriptor, ForegroundModule moduleInstance) {
        for (ForegroundModuleCacheListener cacheListener : this.cacheListeners) {
            cacheListener.moduleUnloaded(moduleDescriptor, moduleInstance);
        }
    }

    public boolean add(ForegroundModuleCacheListener listener) {
        return this.cacheListeners.add(listener);
    }

    public boolean remove(ForegroundModuleCacheListener listener) {
        return this.cacheListeners.remove(listener);
    }

    public void clear() {
        this.cacheListeners.clear();
    }
}

