/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.globallisteners;

import java.util.concurrent.CopyOnWriteArrayList;
import se.unlogic.hierarchy.core.interfaces.BackgroundModule;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleCacheListener;
import se.unlogic.hierarchy.core.interfaces.BackgroundModuleDescriptor;
import se.unlogic.standardutils.collections.KeyAlreadyCachedException;
import se.unlogic.standardutils.collections.KeyNotCachedException;

public class GlobalBackgroundModuleCacheListener
implements BackgroundModuleCacheListener {
    private CopyOnWriteArrayList<BackgroundModuleCacheListener> cacheListeners = new CopyOnWriteArrayList();

    @Override
    public void moduleCached(BackgroundModuleDescriptor moduleDescriptor, BackgroundModule moduleInstance) throws KeyAlreadyCachedException {
        for (BackgroundModuleCacheListener cacheListener : this.cacheListeners) {
            cacheListener.moduleCached(moduleDescriptor, moduleInstance);
        }
    }

    @Override
    public void moduleUpdated(BackgroundModuleDescriptor moduleDescriptor, BackgroundModule moduleInstance) throws KeyNotCachedException {
        for (BackgroundModuleCacheListener cacheListener : this.cacheListeners) {
            cacheListener.moduleUpdated(moduleDescriptor, moduleInstance);
        }
    }

    @Override
    public void moduleUnloaded(BackgroundModuleDescriptor moduleDescriptor, BackgroundModule moduleInstance) throws KeyNotCachedException {
        for (BackgroundModuleCacheListener cacheListener : this.cacheListeners) {
            cacheListener.moduleUnloaded(moduleDescriptor, moduleInstance);
        }
    }

    public boolean add(BackgroundModuleCacheListener listener) {
        return this.cacheListeners.add(listener);
    }

    public boolean remove(BackgroundModuleCacheListener listener) {
        return this.cacheListeners.remove(listener);
    }

    public void clear() {
        this.cacheListeners.clear();
    }
}

