/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.exceptions;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.exceptions.RequestException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.standardutils.xml.XMLUtils;

public class UnhandledModuleException
extends RequestException {
    private static final Priority PRIORITY = Level.ERROR;
    private static final long serialVersionUID = -7765550737630555135L;
    private final Throwable throwable;

    public UnhandledModuleException(SectionDescriptor sectionDescriptor, ForegroundModuleDescriptor moduleDescriptor, Throwable throwable) {
        super(sectionDescriptor, moduleDescriptor);
        if (this.getModuleDescriptor() == null) {
            throw new NullPointerException("ModuleDescriptor cannot be null!");
        }
        if (throwable == null) {
            throw new NullPointerException("Throwable cannot be null!");
        }
        this.throwable = throwable;
    }

    @Override
    public String toString() {
        return this.throwable + " thrown by foreground module " + this.getModuleDescriptor() + " in section " + this.getSectionDescriptor() + ".";
    }

    @Override
    public final Element toXML(Document doc) {
        Element unhandledModuleExceptionElement = doc.createElement("unhandledModuleException");
        unhandledModuleExceptionElement.appendChild(XMLUtils.createCDATAElement((String)"throwable", (Object)this.throwable.toString(), (Document)doc));
        unhandledModuleExceptionElement.appendChild(this.getSectionDescriptor().toXML(doc));
        unhandledModuleExceptionElement.appendChild(this.getModuleDescriptor().toXML(doc));
        return unhandledModuleExceptionElement;
    }

    @Override
    public final Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public Integer getStatusCode() {
        return 500;
    }

    @Override
    public Priority getPriority() {
        return PRIORITY;
    }
}

