/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.exceptions;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.exceptions.RequestException;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.standardutils.xml.XMLUtils;
import se.unlogic.webutils.http.URIParser;

public class URINotFoundException
extends RequestException {
    private static final Priority PRIORITY = Level.INFO;
    private static final long serialVersionUID = 3838684975659674006L;
    private final String requestedURI;

    public URINotFoundException(String requestedURI) {
        if (requestedURI == null) {
            throw new NullPointerException("requestedURI cannot be null!");
        }
        this.requestedURI = requestedURI;
    }

    public URINotFoundException(URIParser uriParser) {
        if (uriParser == null) {
            throw new NullPointerException("URIParser cannot be null!");
        }
        this.requestedURI = uriParser.getFormattedURI();
    }

    public URINotFoundException(SectionDescriptor sectionDescriptor, URIParser uriParser) {
        super(sectionDescriptor);
        if (uriParser == null) {
            throw new NullPointerException("URIParser cannot be null!");
        }
        this.requestedURI = uriParser.getFormattedURI();
    }

    @Override
    public String toString() {
        if (this.getModuleDescriptor() == null) {
            return "Requested URI " + this.requestedURI + " not found in section " + this.getSectionDescriptor() + ".";
        }
        return "Requested URI " + this.requestedURI + " not found in module " + this.getModuleDescriptor() + " in section " + this.getSectionDescriptor() + ".";
    }

    @Override
    public final Element toXML(Document doc) {
        Element uriNotFoundExceptionElement = doc.createElement("URINotFoundException");
        uriNotFoundExceptionElement.appendChild(XMLUtils.createCDATAElement((String)"requestedURI", (Object)this.requestedURI, (Document)doc));
        uriNotFoundExceptionElement.appendChild(this.getSectionDescriptor().toXML(doc));
        if (this.getModuleDescriptor() != null) {
            uriNotFoundExceptionElement.appendChild(this.getModuleDescriptor().toXML(doc));
        }
        return uriNotFoundExceptionElement;
    }

    public String getRequestedURI() {
        return this.requestedURI;
    }

    @Override
    public Integer getStatusCode() {
        return 404;
    }

    @Override
    public Priority getPriority() {
        return PRIORITY;
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }
}

