/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.exceptions;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.exceptions.RequestException;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.webutils.http.URIParser;

public class SectionDefaultURINotFoundException
extends RequestException {
    private static final long serialVersionUID = 7438086793987251298L;
    private static final Priority PRIORITY = Level.INFO;
    private final String requestedURI;
    private final boolean loggedIn;

    public SectionDefaultURINotFoundException(SectionDescriptor sectionDescriptor, URIParser uriParser, boolean loggedIn) {
        super(sectionDescriptor);
        if (uriParser == null) {
            throw new NullPointerException("URIParser cannot be null!");
        }
        this.requestedURI = uriParser.getFormattedURI();
        this.loggedIn = loggedIn;
    }

    @Override
    public String toString() {
        if (this.loggedIn) {
            return "The default URI " + this.requestedURI + " for logged in users set in section " + this.getSectionDescriptor() + " was not found.";
        }
        return "The default URI " + this.requestedURI + " for non-logged in users set in section " + this.getSectionDescriptor() + " was not found.";
    }

    @Override
    public final Element toXML(Document doc) {
        return doc.createElement("SectionDefaultURINotFoundException");
    }

    public String getRequestedURI() {
        return this.requestedURI;
    }

    @Override
    public Integer getStatusCode() {
        return 404;
    }

    @Override
    public Priority getPriority() {
        return PRIORITY;
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }
}

