/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.exceptions;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.unlogic.hierarchy.core.exceptions.RequestException;
import se.unlogic.hierarchy.core.interfaces.ForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.standardutils.xml.XMLUtils;

public class AccessDeniedException
extends RequestException {
    private static final Priority PRIORITY = Level.WARN;
    private static final long serialVersionUID = -7472197255590972057L;
    private String message;

    public AccessDeniedException(SectionDescriptor sectionDescriptor, ForegroundModuleDescriptor moduleDescriptor) {
        super(sectionDescriptor, moduleDescriptor);
    }

    public AccessDeniedException(SectionDescriptor sectionDescriptor) {
        super(sectionDescriptor);
    }

    public AccessDeniedException(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        if (this.message != null) {
            return "Access denied by module " + this.getModuleDescriptor() + " in section " + this.getSectionDescriptor() + ". Reason: " + this.message;
        }
        if (this.getModuleDescriptor() != null) {
            return "Access denied to module " + this.getModuleDescriptor() + " in section " + this.getSectionDescriptor();
        }
        return "Access denied to section " + this.getSectionDescriptor();
    }

    @Override
    public final Element toXML(Document doc) {
        Element accessDeniedExceptionElement = doc.createElement("accessDeniedException");
        if (this.message != null) {
            accessDeniedExceptionElement.appendChild(XMLUtils.createCDATAElement((String)"message", (Object)this.message, (Document)doc));
        }
        accessDeniedExceptionElement.appendChild(this.getSectionDescriptor().toXML(doc));
        if (this.getModuleDescriptor() != null) {
            accessDeniedExceptionElement.appendChild(this.getModuleDescriptor().toXML(doc));
        }
        return accessDeniedExceptionElement;
    }

    @Override
    public Integer getStatusCode() {
        return 403;
    }

    @Override
    public Priority getPriority() {
        return PRIORITY;
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }
}

