/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.VirtualMenuItem;
import se.unlogic.hierarchy.core.daos.BaseDAO;
import se.unlogic.hierarchy.core.daos.interfaces.VirtualMenuItemDAO;
import se.unlogic.hierarchy.core.populators.VirtualMenuItemPopulator;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.GeneratedKeyCollector;
import se.unlogic.standardutils.dao.querys.IntegerKeyCollector;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.populators.IntegerPopulator;

public class MySQLVirtualMenuItemDAO
extends BaseDAO
implements VirtualMenuItemDAO {
    private static VirtualMenuItemPopulator virtualMenuItemPopulator = new VirtualMenuItemPopulator();

    protected MySQLVirtualMenuItemDAO(DataSource ds) {
        super(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMenuItem getMenuItem(Integer menuItemID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ObjectQuery query = new ObjectQuery(connection, false, "SELECT * FROM openhierarchy_virtual_menu_items WHERE menuItemID = ?", (BeanResultSetPopulator)virtualMenuItemPopulator);
            query.setInt(1, menuItemID.intValue());
            VirtualMenuItem virtualMenuItem = (VirtualMenuItem)query.executeQuery();
            if (virtualMenuItem != null) {
                this.getMenuItemGroups(virtualMenuItem, connection);
                this.getMenuItemUsers(virtualMenuItem, connection);
            }
            VirtualMenuItem virtualMenuItem2 = virtualMenuItem;
            return virtualMenuItem2;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void delete(VirtualMenuItem virtualMenuItem) throws SQLException {
        UpdateQuery query = new UpdateQuery(this.dataSource.getConnection(), true, "DELETE FROM openhierarchy_virtual_menu_items WHERE menuItemID = ?");
        query.setInt(1, virtualMenuItem.getMenuItemID().intValue());
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(VirtualMenuItem virtualMenuItem) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            UpdateQuery query = transactionHandler.getUpdateQuery("UPDATE openhierarchy_virtual_menu_items SET itemtype = ?, name = ?, description = ?, url = ?, anonymousAccess = ?, userAccess = ?, adminAccess = ?, sectionID = ? WHERE menuItemID = ?");
            query.setString(1, virtualMenuItem.getItemType().toString());
            query.setObject(2, (Object)virtualMenuItem.getName());
            query.setObject(3, (Object)virtualMenuItem.getDescription());
            query.setObject(4, (Object)virtualMenuItem.getUrl());
            query.setBoolean(5, virtualMenuItem.allowsAnonymousAccess());
            query.setBoolean(6, virtualMenuItem.allowsUserAccess());
            query.setBoolean(7, virtualMenuItem.allowsAdminAccess());
            query.setInt(8, virtualMenuItem.getSectionID().intValue());
            query.setInt(9, virtualMenuItem.getMenuItemID().intValue());
            query.executeUpdate();
            this.deleteMenuItemUsers(transactionHandler, virtualMenuItem);
            if (virtualMenuItem.getAllowedUserIDs() != null && !virtualMenuItem.getAllowedUserIDs().isEmpty()) {
                this.setUsers(transactionHandler, virtualMenuItem);
            }
            this.deleteMenuItemGroups(transactionHandler, virtualMenuItem);
            if (virtualMenuItem.getAllowedGroupIDs() != null && !virtualMenuItem.getAllowedGroupIDs().isEmpty()) {
                this.setGroups(transactionHandler, virtualMenuItem);
            }
            transactionHandler.commit();
        }
        finally {
            if (transactionHandler != null && !transactionHandler.isClosed()) {
                transactionHandler.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<VirtualMenuItem> getMenuItemsInSection(Integer sectionID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM openhierarchy_virtual_menu_items WHERE sectionID = ?", (BeanResultSetPopulator)virtualMenuItemPopulator);
            query.setInt(1, sectionID.intValue());
            ArrayList virtualMenuItems = query.executeQuery();
            if (virtualMenuItems != null) {
                for (VirtualMenuItem virtualMenuItem : virtualMenuItems) {
                    this.getMenuItemGroups(virtualMenuItem, connection);
                    this.getMenuItemUsers(virtualMenuItem, connection);
                }
            }
            ArrayList arrayList = virtualMenuItems;
            return arrayList;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(VirtualMenuItem virtualMenuItem) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO openhierarchy_virtual_menu_items VALUES(null,?,?,?,?,?,?,?,?)");
            query.setString(1, virtualMenuItem.getItemType().toString());
            query.setObject(2, (Object)virtualMenuItem.getName());
            query.setObject(3, (Object)virtualMenuItem.getDescription());
            query.setObject(4, (Object)virtualMenuItem.getUrl());
            query.setBoolean(5, virtualMenuItem.allowsAnonymousAccess());
            query.setBoolean(6, virtualMenuItem.allowsUserAccess());
            query.setBoolean(7, virtualMenuItem.allowsAdminAccess());
            query.setInt(8, virtualMenuItem.getSectionID().intValue());
            IntegerKeyCollector keyCollector = new IntegerKeyCollector();
            query.executeUpdate(new GeneratedKeyCollector[]{keyCollector});
            virtualMenuItem.setMenuItemID(keyCollector.getKeyValue());
            if (virtualMenuItem.getAllowedUserIDs() != null && !virtualMenuItem.getAllowedUserIDs().isEmpty()) {
                this.setUsers(transactionHandler, virtualMenuItem);
            }
            if (virtualMenuItem.getAllowedGroupIDs() != null && !virtualMenuItem.getAllowedGroupIDs().isEmpty()) {
                this.setGroups(transactionHandler, virtualMenuItem);
            }
            transactionHandler.commit();
        }
        finally {
            if (transactionHandler != null && !transactionHandler.isClosed()) {
                transactionHandler.abort();
            }
        }
    }

    private void getMenuItemGroups(VirtualMenuItem virtualMenuItem, Connection connection) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT groupID from openhierarchy_virtual_menu_item_groups WHERE menuItemID = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setInt(1, virtualMenuItem.getMenuItemID().intValue());
        virtualMenuItem.setAllowedGroupIDs(query.executeQuery());
    }

    private void getMenuItemUsers(VirtualMenuItem virtualMenuItem, Connection connection) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT userID from openhierarchy_virtual_menu_item_users WHERE menuItemID = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setInt(1, virtualMenuItem.getMenuItemID().intValue());
        virtualMenuItem.setAllowedUserIDs(query.executeQuery());
    }

    private void deleteMenuItemGroups(TransactionHandler transactionHandler, VirtualMenuItem virtualMenuItem) throws SQLException {
        UpdateQuery query = transactionHandler.getUpdateQuery("DELETE FROM openhierarchy_virtual_menu_item_groups WHERE menuItemID = ?");
        query.setInt(1, virtualMenuItem.getMenuItemID().intValue());
        query.executeUpdate();
    }

    private void deleteMenuItemUsers(TransactionHandler transactionHandler, VirtualMenuItem virtualMenuItem) throws SQLException {
        UpdateQuery query = transactionHandler.getUpdateQuery("DELETE FROM openhierarchy_virtual_menu_item_users WHERE menuItemID = ?");
        query.setInt(1, virtualMenuItem.getMenuItemID().intValue());
        query.executeUpdate();
    }

    private void setGroups(TransactionHandler transactionHandler, VirtualMenuItem virtualMenuItem) throws SQLException {
        for (Integer groupID : virtualMenuItem.getAllowedGroupIDs()) {
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO openhierarchy_virtual_menu_item_groups VALUES (?,?)");
            query.setInt(1, virtualMenuItem.getMenuItemID().intValue());
            query.setInt(2, groupID.intValue());
            query.executeUpdate();
        }
    }

    private void setUsers(TransactionHandler transactionHandler, VirtualMenuItem virtualMenuItem) throws SQLException {
        for (Integer userID : virtualMenuItem.getAllowedUserIDs()) {
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO openhierarchy_virtual_menu_item_users VALUES (?,?)");
            query.setInt(1, virtualMenuItem.getMenuItemID().intValue());
            query.setInt(2, userID.intValue());
            query.executeUpdate();
        }
    }
}

