/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.daos.BaseDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLSectionAttributeDAO;
import se.unlogic.hierarchy.core.daos.interfaces.SectionDAO;
import se.unlogic.hierarchy.core.interfaces.SectionDescriptor;
import se.unlogic.hierarchy.core.populators.SectionDescriptorPopulator;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.QueryOperators;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.GeneratedKeyCollector;
import se.unlogic.standardutils.dao.querys.IntegerKeyCollector;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.string.StringUtils;

public class MySQLSectionDAO
extends BaseDAO
implements SectionDAO {
    private static SectionDescriptorPopulator Populator = new SectionDescriptorPopulator();
    protected final MySQLSectionAttributeDAO<SimpleSectionDescriptor> sectionAttributeDAO;

    protected MySQLSectionDAO(DataSource ds, MySQLSectionAttributeDAO<SimpleSectionDescriptor> sectionAttributeDAO) {
        super(ds);
        this.sectionAttributeDAO = sectionAttributeDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<SimpleSectionDescriptor> getSubSections(SimpleSectionDescriptor section, boolean getSubSections) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayList<SimpleSectionDescriptor> arrayList = this.getSubSections(connection, section, getSubSections);
            return arrayList;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleSectionDescriptor getRootSection(boolean getSubSections) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ObjectQuery query = new ObjectQuery(connection, false, "SELECT * FROM openhierarchy_sections WHERE parentSectionID IS NULL", (BeanResultSetPopulator)Populator);
            SimpleSectionDescriptor simpleSectionDescriptor = (SimpleSectionDescriptor)query.executeQuery();
            if (simpleSectionDescriptor != null) {
                this.getRelations(Collections.singletonList(simpleSectionDescriptor), connection, false);
                if (getSubSections) {
                    simpleSectionDescriptor.setSubSectionsList(this.getSubSections(connection, simpleSectionDescriptor, true));
                }
            }
            SimpleSectionDescriptor simpleSectionDescriptor2 = simpleSectionDescriptor;
            return simpleSectionDescriptor2;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private ArrayList<SimpleSectionDescriptor> getSubSections(Connection connection, SimpleSectionDescriptor section, boolean getSubSections) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM openhierarchy_sections WHERE parentSectionID = ? ORDER BY name", (BeanResultSetPopulator)Populator);
        query.setObject(1, (Object)section.getSectionID());
        ArrayList sectionList = query.executeQuery();
        if (sectionList != null) {
            this.getRelations(sectionList, connection, false);
            for (SimpleSectionDescriptor subSection : sectionList) {
                subSection.setFullAlias(section.getFullAlias() + "/" + subSection.getAlias());
                if (!getSubSections) continue;
                subSection.setSubSectionsList(this.getSubSections(connection, subSection, true));
            }
        }
        return sectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<SimpleSectionDescriptor> getEnabledSubSections(SectionDescriptor sectionDescriptor, boolean getSubSections) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayList<SimpleSectionDescriptor> arrayList = this.getEnabledSubSections(connection, sectionDescriptor, getSubSections);
            return arrayList;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private ArrayList<SimpleSectionDescriptor> getEnabledSubSections(Connection connection, SectionDescriptor sectionDescriptor, boolean getSubSections) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM openhierarchy_sections WHERE parentSectionID = ? and enabled = true ORDER BY name", (BeanResultSetPopulator)Populator);
        query.setInt(1, sectionDescriptor.getSectionID().intValue());
        ArrayList sectionList = query.executeQuery();
        if (sectionList != null) {
            this.getRelations(sectionList, connection, false);
            for (SimpleSectionDescriptor subSection : sectionList) {
                subSection.setFullAlias(sectionDescriptor.getFullAlias() + "/" + subSection.getAlias());
                if (!getSubSections) continue;
                subSection.setSubSectionsList(this.getEnabledSubSections(connection, subSection, true));
            }
        }
        return sectionList;
    }

    private void getSectionGroups(SimpleSectionDescriptor subSection, Connection connection) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT groupID from openhierarchy_section_groups WHERE sectionID = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setInt(1, subSection.getSectionID().intValue());
        subSection.setAllowedGroupIDs(query.executeQuery());
    }

    private void getSectionUsers(SimpleSectionDescriptor subSection, Connection connection) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT userID from openhierarchy_section_users WHERE sectionID = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setInt(1, subSection.getSectionID().intValue());
        subSection.setAllowedUserIDs(query.executeQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleSectionDescriptor getSection(int sectionID, boolean fullAlias) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ObjectQuery query = new ObjectQuery(connection, false, "SELECT * FROM openhierarchy_sections WHERE sectionID = ?", (BeanResultSetPopulator)Populator);
            query.setInt(1, sectionID);
            SimpleSectionDescriptor simpleSectionDescriptor = (SimpleSectionDescriptor)query.executeQuery();
            if (simpleSectionDescriptor != null) {
                this.getRelations(Collections.singletonList(simpleSectionDescriptor), connection, fullAlias);
            }
            SimpleSectionDescriptor simpleSectionDescriptor2 = simpleSectionDescriptor;
            return simpleSectionDescriptor2;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void getReverseFullAlias(SimpleSectionDescriptor simpleSectionDescriptor) throws SQLException {
        if (simpleSectionDescriptor.getParentSectionID() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/" + simpleSectionDescriptor.getAlias());
            SimpleSectionDescriptor parentSection = this.getSection((int)simpleSectionDescriptor.getParentSectionID(), false);
            while (parentSection != null && parentSection.getParentSectionID() != null) {
                stringBuilder.insert(0, "/" + parentSection.getAlias());
                parentSection = this.getSection((int)parentSection.getParentSectionID(), false);
            }
            simpleSectionDescriptor.setFullAlias(stringBuilder.toString());
        } else {
            simpleSectionDescriptor.setFullAlias("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(SimpleSectionDescriptor simpleSectionDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            UpdateQuery query = transactionHandler.getUpdateQuery("UPDATE openhierarchy_sections SET parentSectionID = ?, alias = ?, enabled = ?, anonymousAccess = ?, userAccess = ?, adminAccess = ?, visibleInMenu = ?, breadCrumb = ?, name = ?, description = ?, anonymousDefaultURI = ?, userDefaultURI = ?, requiredProtocol = ? WHERE sectionID = ?");
            query.setObject(1, (Object)simpleSectionDescriptor.getParentSectionID());
            query.setString(2, simpleSectionDescriptor.getAlias());
            query.setBoolean(3, simpleSectionDescriptor.isEnabled());
            query.setBoolean(4, simpleSectionDescriptor.allowsAnonymousAccess());
            query.setBoolean(5, simpleSectionDescriptor.allowsUserAccess());
            query.setBoolean(6, simpleSectionDescriptor.allowsAdminAccess());
            query.setBoolean(7, simpleSectionDescriptor.isVisibleInMenu());
            query.setBoolean(8, simpleSectionDescriptor.hasBreadCrumb());
            query.setString(9, simpleSectionDescriptor.getName());
            query.setString(10, simpleSectionDescriptor.getDescription());
            query.setString(11, simpleSectionDescriptor.getAnonymousDefaultURI());
            query.setString(12, simpleSectionDescriptor.getUserDefaultURI());
            if (simpleSectionDescriptor.getRequiredProtocol() != null) {
                query.setString(13, simpleSectionDescriptor.getRequiredProtocol().toString());
            } else {
                query.setString(13, null);
            }
            query.setInt(14, simpleSectionDescriptor.getSectionID().intValue());
            query.executeUpdate();
            this.deleteSectionUsers(transactionHandler, simpleSectionDescriptor);
            if (simpleSectionDescriptor.getAllowedUserIDs() != null && !simpleSectionDescriptor.getAllowedUserIDs().isEmpty()) {
                this.setUsers(transactionHandler, simpleSectionDescriptor);
            }
            this.deleteSectionGroups(transactionHandler, simpleSectionDescriptor);
            if (simpleSectionDescriptor.getAllowedGroupIDs() != null && !simpleSectionDescriptor.getAllowedGroupIDs().isEmpty()) {
                this.setGroups(transactionHandler, simpleSectionDescriptor);
            }
            this.sectionAttributeDAO.set(simpleSectionDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        finally {
            if (transactionHandler != null && !transactionHandler.isClosed()) {
                transactionHandler.abort();
            }
        }
    }

    private void deleteSectionGroups(TransactionHandler transactionHandler, SimpleSectionDescriptor simpleSectionDescriptor) throws SQLException {
        UpdateQuery query = transactionHandler.getUpdateQuery("DELETE FROM openhierarchy_section_groups WHERE sectionID = ?");
        query.setInt(1, simpleSectionDescriptor.getSectionID().intValue());
        query.executeUpdate();
    }

    private void deleteSectionUsers(TransactionHandler transactionHandler, SimpleSectionDescriptor simpleSectionDescriptor) throws SQLException {
        UpdateQuery query = transactionHandler.getUpdateQuery("DELETE FROM openhierarchy_section_users WHERE sectionID = ?");
        query.setInt(1, simpleSectionDescriptor.getSectionID().intValue());
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SimpleSectionDescriptor simpleSectionDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO openhierarchy_sections VALUES (null,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            query.setObject(1, (Object)simpleSectionDescriptor.getParentSectionID());
            query.setString(2, simpleSectionDescriptor.getAlias());
            query.setBoolean(3, simpleSectionDescriptor.isEnabled());
            query.setBoolean(4, simpleSectionDescriptor.allowsAnonymousAccess());
            query.setBoolean(5, simpleSectionDescriptor.allowsUserAccess());
            query.setBoolean(6, simpleSectionDescriptor.allowsAdminAccess());
            query.setBoolean(7, simpleSectionDescriptor.isVisibleInMenu());
            query.setBoolean(8, simpleSectionDescriptor.hasBreadCrumb());
            query.setString(9, simpleSectionDescriptor.getName());
            query.setString(10, simpleSectionDescriptor.getDescription());
            query.setString(11, simpleSectionDescriptor.getAnonymousDefaultURI());
            query.setString(12, simpleSectionDescriptor.getUserDefaultURI());
            if (simpleSectionDescriptor.getRequiredProtocol() != null) {
                query.setString(13, simpleSectionDescriptor.getRequiredProtocol().toString());
            } else {
                query.setString(13, null);
            }
            IntegerKeyCollector keyCollector = new IntegerKeyCollector();
            query.executeUpdate(new GeneratedKeyCollector[]{keyCollector});
            simpleSectionDescriptor.setSectionID(keyCollector.getKeyValue());
            if (simpleSectionDescriptor.getAllowedUserIDs() != null && !simpleSectionDescriptor.getAllowedUserIDs().isEmpty()) {
                this.setUsers(transactionHandler, simpleSectionDescriptor);
            }
            if (simpleSectionDescriptor.getAllowedGroupIDs() != null && !simpleSectionDescriptor.getAllowedGroupIDs().isEmpty()) {
                this.setGroups(transactionHandler, simpleSectionDescriptor);
            }
            this.sectionAttributeDAO.set(simpleSectionDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        finally {
            if (transactionHandler != null && !transactionHandler.isClosed()) {
                transactionHandler.abort();
            }
        }
    }

    private void setGroups(TransactionHandler transactionHandler, SimpleSectionDescriptor simpleSectionDescriptor) throws SQLException {
        for (Integer groupID : simpleSectionDescriptor.getAllowedGroupIDs()) {
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO openhierarchy_section_groups VALUES (?,?)");
            query.setInt(1, simpleSectionDescriptor.getSectionID().intValue());
            query.setInt(2, groupID.intValue());
            query.executeUpdate();
        }
    }

    private void setUsers(TransactionHandler transactionHandler, SimpleSectionDescriptor simpleSectionDescriptor) throws SQLException {
        for (Integer userID : simpleSectionDescriptor.getAllowedUserIDs()) {
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO openhierarchy_section_users VALUES (?,?)");
            query.setInt(1, simpleSectionDescriptor.getSectionID().intValue());
            query.setInt(2, userID.intValue());
            query.executeUpdate();
        }
    }

    @Override
    public void delete(SimpleSectionDescriptor simpleSectionDescriptor) throws SQLException {
        UpdateQuery query = new UpdateQuery(this.dataSource.getConnection(), true, "DELETE FROM openhierarchy_sections WHERE sectionID = ?");
        query.setInt(1, simpleSectionDescriptor.getSectionID().intValue());
        query.executeUpdate();
    }

    @Override
    public SimpleSectionDescriptor getSection(Integer parentSectionID, String alias) throws SQLException {
        ObjectQuery query = new ObjectQuery(this.dataSource.getConnection(), true, "SELECT * FROM openhierarchy_sections WHERE parentSectionID = ? AND alias = ?", (BeanResultSetPopulator)Populator);
        query.setObject(1, (Object)parentSectionID);
        query.setString(2, alias);
        return (SimpleSectionDescriptor)query.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleSectionDescriptor> getSectionsByIDs(List<Integer> sectionIDs, boolean fullAlias) throws SQLException {
        if (sectionIDs == null) {
            return null;
        }
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM openhierarchy_sections WHERE sectionID IN(" + StringUtils.toCommaSeparatedString(sectionIDs) + ") ORDER BY name", (BeanResultSetPopulator)Populator);
            ArrayList sectionDescriptors = query.executeQuery();
            if (sectionDescriptors != null) {
                this.getRelations(sectionDescriptors, connection, fullAlias);
            }
            ArrayList arrayList = sectionDescriptors;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    protected void getRelations(List<SimpleSectionDescriptor> sections, Connection connection, boolean fullAlias) throws SQLException {
        for (SimpleSectionDescriptor sectionDescriptor : sections) {
            this.getSectionUsers(sectionDescriptor, connection);
            this.getSectionGroups(sectionDescriptor, connection);
            this.sectionAttributeDAO.getAttributeHandler(sectionDescriptor, connection);
            if (!fullAlias || sectionDescriptor.getParentSectionID() == null) continue;
            this.getReverseFullAlias(sectionDescriptor);
        }
    }

    @Override
    public List<SimpleSectionDescriptor> getSectionsByAttribute(String name, String value, boolean fullAlias) throws SQLException {
        List<Integer> sectionIDs = this.sectionAttributeDAO.getIDsByAttribute(name, value, QueryOperators.EQUALS);
        return this.getSectionsByIDs(sectionIDs, fullAlias);
    }

    @Override
    public List<SimpleSectionDescriptor> getSectionsByAttribute(String name, boolean fullAlias) throws SQLException {
        List<Integer> sectionIDs = this.sectionAttributeDAO.getIDsByAttribute(name);
        return this.getSectionsByIDs(sectionIDs, fullAlias);
    }
}

