/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.SimpleSectionDescriptor;
import se.unlogic.hierarchy.core.daos.BaseDAO;
import se.unlogic.hierarchy.core.daos.interfaces.AttributeDAO;
import se.unlogic.hierarchy.core.handlers.SimpleMutableAttributeHandler;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.QueryOperators;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.HashMapQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.populators.StringEntryPopulator;

public class MySQLSectionAttributeDAO<Descriptor extends SimpleSectionDescriptor>
extends BaseDAO
implements AttributeDAO<Descriptor> {
    public static final StringEntryPopulator POPULATOR = new StringEntryPopulator();
    private final String tableName;

    protected MySQLSectionAttributeDAO(DataSource ds, String tableName) {
        super(ds);
        this.tableName = tableName;
    }

    @Override
    public void set(Descriptor sectionDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.set(sectionDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
    }

    @Override
    public void set(Descriptor sectionDescriptor, TransactionHandler transactionHandler) throws SQLException {
        UpdateQuery deleteQuery = transactionHandler.getUpdateQuery("DELETE FROM " + this.tableName + " WHERE sectionID = ?");
        deleteQuery.setInt(1, ((SimpleSectionDescriptor)sectionDescriptor).getSectionID().intValue());
        deleteQuery.executeUpdate();
        if (((SimpleSectionDescriptor)sectionDescriptor).getAttributeHandler() != null && !((SimpleSectionDescriptor)sectionDescriptor).getAttributeHandler().isEmpty()) {
            for (Map.Entry<String, String> entry : ((SimpleSectionDescriptor)sectionDescriptor).getAttributeHandler().getAttributeMap().entrySet()) {
                UpdateQuery updateQuery = transactionHandler.getUpdateQuery("INSERT INTO " + this.tableName + " VALUES (?,?,?)");
                updateQuery.setInt(1, ((SimpleSectionDescriptor)sectionDescriptor).getSectionID().intValue());
                updateQuery.setString(2, entry.getKey());
                updateQuery.setString(3, entry.getValue());
                updateQuery.executeUpdate();
            }
        }
    }

    @Override
    public void getAttributeHandler(Descriptor sectionDescriptor, Connection connection) throws SQLException {
        HashMapQuery query = new HashMapQuery(connection, false, "SELECT name, value FROM " + this.tableName + " WHERE sectionID = ?", (BeanResultSetPopulator)POPULATOR);
        query.setInt(1, ((SimpleSectionDescriptor)sectionDescriptor).getSectionID().intValue());
        HashMap attributeMap = query.executeQuery();
        if (attributeMap == null) {
            return;
        }
        ((SimpleSectionDescriptor)sectionDescriptor).setAttributeHandler(new SimpleMutableAttributeHandler(attributeMap, 255, 4096));
    }

    @Override
    public List<Integer> getIDsByAttribute(String name, String value, QueryOperators operator) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT sectionID FROM " + this.tableName + " WHERE name = ? AND `value` " + operator.getOperator() + " ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setString(1, name);
        query.setString(2, value);
        return query.executeQuery();
    }

    @Override
    public List<Integer> getIDsByAttribute(String name) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT sectionID FROM " + this.tableName + " WHERE name = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setString(1, name);
        return query.executeQuery();
    }
}

