/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.BaseModuleDescriptor;
import se.unlogic.hierarchy.core.daos.BaseDAO;
import se.unlogic.hierarchy.core.handlers.SimpleSettingHandler;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.datatypes.SimpleEntry;
import se.unlogic.standardutils.populators.StringEntryPopulator;

public class MySQLModuleSettingDAO<Descriptor extends BaseModuleDescriptor>
extends BaseDAO {
    public static final StringEntryPopulator POPULATOR = new StringEntryPopulator();
    private final String tableName;

    protected MySQLModuleSettingDAO(DataSource ds, String tableName) {
        super(ds);
        this.tableName = tableName;
    }

    public void set(Descriptor moduleDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.set(moduleDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
    }

    public void set(Descriptor moduleDescriptor, TransactionHandler transactionHandler) throws SQLException {
        UpdateQuery deleteQuery = transactionHandler.getUpdateQuery("DELETE FROM " + this.tableName + " WHERE moduleID = ?");
        deleteQuery.setInt(1, ((BaseModuleDescriptor)moduleDescriptor).getModuleID().intValue());
        deleteQuery.executeUpdate();
        if (((BaseModuleDescriptor)moduleDescriptor).getMutableSettingHandler() != null && !((BaseModuleDescriptor)moduleDescriptor).getMutableSettingHandler().isEmpty()) {
            for (String id : ((BaseModuleDescriptor)moduleDescriptor).getMutableSettingHandler().getIDs()) {
                for (String value : ((BaseModuleDescriptor)moduleDescriptor).getMutableSettingHandler().getStrings(id)) {
                    UpdateQuery updateQuery = transactionHandler.getUpdateQuery("INSERT INTO " + this.tableName + " VALUES (null,?,?,?)");
                    updateQuery.setInt(1, ((BaseModuleDescriptor)moduleDescriptor).getModuleID().intValue());
                    updateQuery.setString(2, id);
                    updateQuery.setString(3, value);
                    updateQuery.executeUpdate();
                }
            }
        }
    }

    public void getSettingsHandler(Descriptor moduleDescriptor, Connection connection) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT id, value FROM " + this.tableName + " WHERE moduleID = ?", (BeanResultSetPopulator)POPULATOR);
        query.setInt(1, ((BaseModuleDescriptor)moduleDescriptor).getModuleID().intValue());
        ArrayList valueList = query.executeQuery();
        if (valueList == null) {
            ((BaseModuleDescriptor)moduleDescriptor).setMutableSettingHandler(new SimpleSettingHandler());
            return;
        }
        HashMap<String, List<String>> valueMap = new HashMap<String, List<String>>();
        for (SimpleEntry entry : valueList) {
            List<String> list = valueMap.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<String>();
                valueMap.put((String)entry.getKey(), list);
            }
            list.add((String)entry.getValue());
        }
        ((BaseModuleDescriptor)moduleDescriptor).setMutableSettingHandler(new SimpleSettingHandler(valueMap));
    }
}

