/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.BaseModuleDescriptor;
import se.unlogic.hierarchy.core.daos.BaseDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleAttributeDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleSettingDAO;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.ObjectQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.db.DBUtils;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.string.StringUtils;

public abstract class MySQLModuleDAO<Descriptor extends BaseModuleDescriptor>
extends BaseDAO {
    protected final MySQLModuleSettingDAO<Descriptor> moduleSettingDAO;
    protected final MySQLModuleAttributeDAO<Descriptor> moduleAttributeDAO;
    protected final String moduleTable;
    protected final String moduleUsersTable;
    protected final String moduleGroupsTable;

    public MySQLModuleDAO(MySQLModuleSettingDAO<Descriptor> mySQLModuleSettingDAO, MySQLModuleAttributeDAO<Descriptor> moduleAttributeDAO, DataSource dataSource, String moduleTable, String moduleUsersTable, String moduleGroupsTable) {
        super(dataSource);
        this.moduleSettingDAO = mySQLModuleSettingDAO;
        this.moduleTable = moduleTable;
        this.moduleUsersTable = moduleUsersTable;
        this.moduleGroupsTable = moduleGroupsTable;
        this.moduleAttributeDAO = moduleAttributeDAO;
    }

    protected abstract BeanResultSetPopulator<Descriptor> getPopulator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Descriptor> getEnabledModules(Integer sectionID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM " + this.moduleTable + " WHERE enabled = true AND sectionID = ? ORDER BY name", this.getPopulator());
            query.setObject(1, (Object)sectionID);
            ArrayList modules = query.executeQuery();
            if (modules != null) {
                for (BaseModuleDescriptor descriptor : modules) {
                    this.getRelations(descriptor, connection);
                }
            }
            ArrayList arrayList = modules;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptor getModule(Integer moduleID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ObjectQuery query = new ObjectQuery(connection, false, "SELECT * FROM " + this.moduleTable + " WHERE moduleID = ?", this.getPopulator());
            query.setInt(1, moduleID.intValue());
            BaseModuleDescriptor descriptor = (BaseModuleDescriptor)query.executeQuery();
            if (descriptor != null) {
                this.getRelations(descriptor, connection);
            }
            BaseModuleDescriptor baseModuleDescriptor = descriptor;
            return (Descriptor)baseModuleDescriptor;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Descriptor> getModules(List<Integer> moduleIDs) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM " + this.moduleTable + " WHERE moduleID IN (?" + StringUtils.repeatString((String)",?", (int)(moduleIDs.size() - 1)) + ")", this.getPopulator());
            int index = 1;
            for (Integer moduleID : moduleIDs) {
                query.setInt(index, moduleID.intValue());
                ++index;
            }
            ArrayList descriptors = query.executeQuery();
            if (descriptors != null) {
                for (BaseModuleDescriptor descriptor : descriptors) {
                    this.getRelations(descriptor, connection);
                }
            }
            ArrayList arrayList = descriptors;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    public Descriptor getModule(Integer sectionID, String alias) throws SQLException {
        ObjectQuery query = new ObjectQuery(this.dataSource.getConnection(), true, "SELECT * FROM " + this.moduleTable + " WHERE sectionID = ? AND alias = ?", this.getPopulator());
        query.setInt(1, sectionID.intValue());
        query.setString(2, alias);
        return (Descriptor)((BaseModuleDescriptor)query.executeQuery());
    }

    private void getModuleGroups(Descriptor moduleBean, Connection connection) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT groupID from " + this.moduleGroupsTable + " WHERE moduleID = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setInt(1, ((BaseModuleDescriptor)moduleBean).getModuleID().intValue());
        ((BaseModuleDescriptor)moduleBean).setAllowedGroupIDs(query.executeQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Descriptor> getModules(Integer sectionID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT * FROM " + this.moduleTable + " WHERE sectionID = ? ORDER BY name", this.getPopulator());
            query.setObject(1, (Object)sectionID);
            ArrayList modules = query.executeQuery();
            if (modules != null) {
                for (BaseModuleDescriptor descriptor : modules) {
                    this.getRelations(descriptor, connection);
                }
            }
            ArrayList arrayList = modules;
            return arrayList;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    protected void getRelations(Descriptor descriptor, Connection connection) throws SQLException {
        this.moduleSettingDAO.getSettingsHandler(descriptor, connection);
        this.moduleAttributeDAO.getAttributeHandler(descriptor, connection);
        this.getModuleGroups(descriptor, connection);
        this.getModuleUsers(descriptor, connection);
    }

    private void getModuleUsers(Descriptor moduleBean, Connection connection) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(connection, false, "SELECT userID from " + this.moduleUsersTable + " WHERE moduleID = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setInt(1, ((BaseModuleDescriptor)moduleBean).getModuleID().intValue());
        ((BaseModuleDescriptor)moduleBean).setAllowedUserIDs(query.executeQuery());
    }

    protected void setGroups(TransactionHandler transactionHandler, Descriptor Descriptor) throws SQLException {
        for (Integer groupID : ((BaseModuleDescriptor)Descriptor).getAllowedGroupIDs()) {
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO " + this.moduleGroupsTable + " VALUES (?,?)");
            query.setInt(1, ((BaseModuleDescriptor)Descriptor).getModuleID().intValue());
            query.setInt(2, groupID.intValue());
            query.executeUpdate();
        }
    }

    protected void setUsers(TransactionHandler transactionHandler, Descriptor Descriptor) throws SQLException {
        for (Integer userID : ((BaseModuleDescriptor)Descriptor).getAllowedUserIDs()) {
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO " + this.moduleUsersTable + " VALUES (?,?)");
            query.setInt(1, ((BaseModuleDescriptor)Descriptor).getModuleID().intValue());
            query.setInt(2, userID.intValue());
            query.executeUpdate();
        }
    }

    public void delete(Descriptor descriptor) throws SQLException {
        UpdateQuery query = new UpdateQuery(this.dataSource.getConnection(), true, "DELETE FROM " + this.moduleTable + " WHERE moduleID = ?");
        query.setInt(1, ((BaseModuleDescriptor)descriptor).getModuleID().intValue());
        query.executeUpdate();
    }

    protected void deleteModuleGroups(TransactionHandler transactionHandler, Descriptor descriptor) throws SQLException {
        UpdateQuery query = transactionHandler.getUpdateQuery("DELETE FROM " + this.moduleGroupsTable + " WHERE moduleID = ?");
        query.setInt(1, ((BaseModuleDescriptor)descriptor).getModuleID().intValue());
        query.executeUpdate();
    }

    protected void deleteModuleUsers(TransactionHandler transactionHandler, Descriptor descriptor) throws SQLException {
        UpdateQuery query = transactionHandler.getUpdateQuery("DELETE FROM " + this.moduleUsersTable + " WHERE moduleID = ?");
        query.setInt(1, ((BaseModuleDescriptor)descriptor).getModuleID().intValue());
        query.executeUpdate();
    }
}

