/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.BaseModuleDescriptor;
import se.unlogic.hierarchy.core.daos.BaseDAO;
import se.unlogic.hierarchy.core.daos.interfaces.AttributeDAO;
import se.unlogic.hierarchy.core.handlers.SimpleMutableAttributeHandler;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.QueryOperators;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.ArrayListQuery;
import se.unlogic.standardutils.dao.querys.HashMapQuery;
import se.unlogic.standardutils.dao.querys.UpdateQuery;
import se.unlogic.standardutils.populators.IntegerPopulator;
import se.unlogic.standardutils.populators.StringEntryPopulator;

public class MySQLModuleAttributeDAO<Descriptor extends BaseModuleDescriptor>
extends BaseDAO
implements AttributeDAO<Descriptor> {
    public static final StringEntryPopulator POPULATOR = new StringEntryPopulator();
    private final String tableName;

    protected MySQLModuleAttributeDAO(DataSource ds, String tableName) {
        super(ds);
        this.tableName = tableName;
    }

    @Override
    public void set(Descriptor moduleDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            this.set(moduleDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
    }

    @Override
    public void set(Descriptor moduleDescriptor, TransactionHandler transactionHandler) throws SQLException {
        UpdateQuery deleteQuery = transactionHandler.getUpdateQuery("DELETE FROM " + this.tableName + " WHERE moduleID = ?");
        deleteQuery.setInt(1, ((BaseModuleDescriptor)moduleDescriptor).getModuleID().intValue());
        deleteQuery.executeUpdate();
        if (((BaseModuleDescriptor)moduleDescriptor).getAttributeHandler() != null && !((BaseModuleDescriptor)moduleDescriptor).getAttributeHandler().isEmpty()) {
            for (Map.Entry<String, String> entry : ((BaseModuleDescriptor)moduleDescriptor).getAttributeHandler().getAttributeMap().entrySet()) {
                UpdateQuery updateQuery = transactionHandler.getUpdateQuery("INSERT INTO " + this.tableName + " VALUES (?,?,?)");
                updateQuery.setInt(1, ((BaseModuleDescriptor)moduleDescriptor).getModuleID().intValue());
                updateQuery.setString(2, entry.getKey());
                updateQuery.setString(3, entry.getValue());
                updateQuery.executeUpdate();
            }
        }
    }

    @Override
    public void getAttributeHandler(Descriptor moduleDescriptor, Connection connection) throws SQLException {
        HashMapQuery query = new HashMapQuery(connection, false, "SELECT name, value FROM " + this.tableName + " WHERE moduleID = ?", (BeanResultSetPopulator)POPULATOR);
        query.setInt(1, ((BaseModuleDescriptor)moduleDescriptor).getModuleID().intValue());
        HashMap attributeMap = query.executeQuery();
        if (attributeMap == null) {
            return;
        }
        ((BaseModuleDescriptor)moduleDescriptor).setAttributeHandler(new SimpleMutableAttributeHandler(attributeMap, 255, 4096));
    }

    public List<Integer> getModulesIDsByAttribute(String name, String value) throws SQLException {
        return this.getIDsByAttribute(name, value, QueryOperators.EQUALS);
    }

    @Override
    public List<Integer> getIDsByAttribute(String name, String value, QueryOperators operator) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT moduleID FROM " + this.tableName + " WHERE name = ? AND `value` " + operator.getOperator() + " ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setString(1, name);
        query.setString(2, value);
        return query.executeQuery();
    }

    @Override
    public List<Integer> getIDsByAttribute(String name) throws SQLException {
        ArrayListQuery query = new ArrayListQuery(this.dataSource, "SELECT moduleID FROM " + this.tableName + " WHERE name = ?", (BeanResultSetPopulator)IntegerPopulator.getPopulator());
        query.setString(1, name);
        return query.executeQuery();
    }
}

