/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.SimpleForegroundModuleDescriptor;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLForegroundModuleSettingDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleAttributeDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleDAO;
import se.unlogic.hierarchy.core.daos.interfaces.ForegroundModuleDAO;
import se.unlogic.hierarchy.core.populators.ForegroundModuleDescriptorPopulator;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.dao.querys.GeneratedKeyCollector;
import se.unlogic.standardutils.dao.querys.IntegerKeyCollector;
import se.unlogic.standardutils.dao.querys.UpdateQuery;

public class MySQLForegroundModuleDAO
extends MySQLModuleDAO<SimpleForegroundModuleDescriptor>
implements ForegroundModuleDAO {
    private static final ForegroundModuleDescriptorPopulator POPULATOR = new ForegroundModuleDescriptorPopulator();

    protected MySQLForegroundModuleDAO(DataSource ds, MySQLForegroundModuleSettingDAO moduleSettingDAO, MySQLModuleAttributeDAO<SimpleForegroundModuleDescriptor> moduleAttributeDAO) {
        super(moduleSettingDAO, moduleAttributeDAO, ds, "openhierarchy_foreground_modules", "openhierarchy_foreground_module_users", "openhierarchy_foreground_module_groups");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SimpleForegroundModuleDescriptor descriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            UpdateQuery query = transactionHandler.getUpdateQuery("INSERT INTO openhierarchy_foreground_modules VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            query.setObject(1, (Object)descriptor.getModuleID());
            query.setString(2, descriptor.getClassname());
            query.setString(3, descriptor.getName());
            query.setString(4, descriptor.getAlias());
            query.setString(5, descriptor.getDescription());
            query.setString(6, descriptor.getXslPath());
            if (descriptor.getXslPathType() != null) {
                query.setString(7, descriptor.getXslPathType().toString());
            } else {
                query.setString(7, null);
            }
            query.setBoolean(8, descriptor.allowsAnonymousAccess());
            query.setBoolean(9, descriptor.allowsUserAccess());
            query.setBoolean(10, descriptor.allowsAdminAccess());
            query.setBoolean(11, descriptor.isEnabled());
            query.setBoolean(12, descriptor.isVisibleInMenu());
            query.setObject(13, (Object)descriptor.getSectionID());
            query.setObject(14, (Object)descriptor.getDataSourceID());
            query.setObject(15, (Object)descriptor.getStaticContentPackage());
            if (descriptor.getRequiredProtocol() != null) {
                query.setString(16, descriptor.getRequiredProtocol().toString());
            } else {
                query.setString(16, null);
            }
            IntegerKeyCollector keyCollector = new IntegerKeyCollector();
            query.executeUpdate(new GeneratedKeyCollector[]{keyCollector});
            descriptor.setModuleID(keyCollector.getKeyValue());
            if (descriptor.getAllowedUserIDs() != null && !descriptor.getAllowedUserIDs().isEmpty()) {
                this.setUsers(transactionHandler, descriptor);
            }
            if (descriptor.getAllowedGroupIDs() != null && !descriptor.getAllowedGroupIDs().isEmpty()) {
                this.setGroups(transactionHandler, descriptor);
            }
            if (descriptor.getMutableSettingHandler() != null && !descriptor.getMutableSettingHandler().isEmpty()) {
                this.moduleSettingDAO.set(descriptor, transactionHandler);
            }
            if (descriptor.getAttributeHandler() != null && !descriptor.getAttributeHandler().isEmpty()) {
                this.moduleAttributeDAO.set(descriptor, transactionHandler);
            }
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(SimpleForegroundModuleDescriptor descriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = new TransactionHandler(this.dataSource);
            UpdateQuery query = transactionHandler.getUpdateQuery("UPDATE openhierarchy_foreground_modules SET name = ?, alias = ?, description = ?, xslPath = ?, xslPathType = ?, anonymousAccess = ?, userAccess = ?, adminAccess = ?, enabled = ?, visibleInMenu = ?, sectionID = ?, classname = ?, dataSourceID = ?, staticContentPackage = ?, requiredProtocol = ? WHERE moduleID = ?");
            query.setString(1, descriptor.getName());
            query.setString(2, descriptor.getAlias());
            query.setString(3, descriptor.getDescription());
            query.setString(4, descriptor.getXslPath());
            if (descriptor.getXslPathType() != null) {
                query.setString(5, descriptor.getXslPathType().toString());
            } else {
                query.setString(5, null);
            }
            query.setBoolean(6, descriptor.allowsAnonymousAccess());
            query.setBoolean(7, descriptor.allowsUserAccess());
            query.setBoolean(8, descriptor.allowsAdminAccess());
            query.setBoolean(9, descriptor.isEnabled());
            query.setBoolean(10, descriptor.isVisibleInMenu());
            query.setObject(11, (Object)descriptor.getSectionID());
            query.setString(12, descriptor.getClassname());
            query.setObject(13, (Object)descriptor.getDataSourceID());
            query.setObject(14, (Object)descriptor.getStaticContentPackage());
            if (descriptor.getRequiredProtocol() != null) {
                query.setString(15, descriptor.getRequiredProtocol().toString());
            } else {
                query.setString(15, null);
            }
            query.setInt(16, descriptor.getModuleID().intValue());
            query.executeUpdate();
            this.deleteModuleUsers(transactionHandler, descriptor);
            if (descriptor.getAllowedUserIDs() != null && !descriptor.getAllowedUserIDs().isEmpty()) {
                this.setUsers(transactionHandler, descriptor);
            }
            this.deleteModuleGroups(transactionHandler, descriptor);
            if (descriptor.getAllowedGroupIDs() != null && !descriptor.getAllowedGroupIDs().isEmpty()) {
                this.setGroups(transactionHandler, descriptor);
            }
            this.moduleSettingDAO.set(descriptor, transactionHandler);
            this.moduleAttributeDAO.set(descriptor, transactionHandler);
            transactionHandler.commit();
        }
        catch (Throwable throwable) {
            TransactionHandler.autoClose(transactionHandler);
            throw throwable;
        }
        TransactionHandler.autoClose((TransactionHandler)transactionHandler);
    }

    @Override
    protected BeanResultSetPopulator<SimpleForegroundModuleDescriptor> getPopulator() {
        return POPULATOR;
    }

    @Override
    public List<SimpleForegroundModuleDescriptor> getModulesByAttribute(String name, String value) throws SQLException {
        List<Integer> moduleIDs = this.moduleAttributeDAO.getModulesIDsByAttribute(name, value);
        if (moduleIDs == null) {
            return null;
        }
        return this.getModules(moduleIDs);
    }
}

