/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.hierarchy.core.daos.implementations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import se.unlogic.hierarchy.core.beans.SimpleFilterModuleDescriptor;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLFilterModuleSettingDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleAttributeDAO;
import se.unlogic.hierarchy.core.daos.implementations.mysql.MySQLModuleSettingDAO;
import se.unlogic.hierarchy.core.daos.interfaces.FilterModuleDAO;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.db.DBUtils;

public class MySQLFilterModuleDAO
extends AnnotatedDAO<SimpleFilterModuleDescriptor>
implements FilterModuleDAO {
    protected MySQLFilterModuleSettingDAO moduleSettingDAO;
    protected MySQLModuleAttributeDAO<SimpleFilterModuleDescriptor> moduleAttributeDAO;
    protected QueryParameterFactory<SimpleFilterModuleDescriptor, Integer> moduleIDQueryParameterFactory;
    protected final HighLevelQuery<SimpleFilterModuleDescriptor> enabledModulesQuery;

    public MySQLFilterModuleDAO(DataSource dataSource, MySQLFilterModuleSettingDAO moduleSettingDAO, MySQLModuleAttributeDAO<SimpleFilterModuleDescriptor> moduleAttributeDAO) {
        super(dataSource, SimpleFilterModuleDescriptor.class, (AnnotatedDAOFactory)new SimpleAnnotatedDAOFactory());
        this.moduleSettingDAO = moduleSettingDAO;
        this.moduleAttributeDAO = moduleAttributeDAO;
        this.enabledModulesQuery = new HighLevelQuery();
        this.enabledModulesQuery.addParameter(this.getParamFactory("enabled", Boolean.TYPE).getParameter((Object)true));
        this.moduleIDQueryParameterFactory = this.getParamFactory("moduleID", Integer.class);
    }

    @Override
    public void add(SimpleFilterModuleDescriptor moduleDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = this.createTransaction();
            this.add(moduleDescriptor, transactionHandler, null);
            ((MySQLModuleSettingDAO)this.moduleSettingDAO).set(moduleDescriptor, transactionHandler);
            this.moduleAttributeDAO.set(moduleDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        finally {
            TransactionHandler.autoClose((TransactionHandler)transactionHandler);
        }
    }

    @Override
    public void update(SimpleFilterModuleDescriptor moduleDescriptor) throws SQLException {
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = this.createTransaction();
            this.update(moduleDescriptor, transactionHandler, null);
            ((MySQLModuleSettingDAO)this.moduleSettingDAO).set(moduleDescriptor, transactionHandler);
            this.moduleAttributeDAO.set(moduleDescriptor, transactionHandler);
            transactionHandler.commit();
        }
        finally {
            TransactionHandler.autoClose((TransactionHandler)transactionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleFilterModuleDescriptor> getEnabledModules() throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            List modules = this.getAll(this.enabledModulesQuery, connection);
            if (modules != null) {
                this.getRelations(modules, connection);
            }
            List list = modules;
            return list;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleFilterModuleDescriptor> getModules() throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            List modules = this.getAll(null, connection);
            if (modules != null) {
                this.getRelations(modules, connection);
            }
            List list = modules;
            return list;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFilterModuleDescriptor getModule(Integer moduleID) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            HighLevelQuery query = new HighLevelQuery();
            query.addParameter(this.moduleIDQueryParameterFactory.getParameter((Object)moduleID));
            SimpleFilterModuleDescriptor moduleDescriptor = (SimpleFilterModuleDescriptor)this.get(query, connection);
            if (moduleDescriptor != null) {
                this.getRelations(Collections.singletonList(moduleDescriptor), connection);
            }
            SimpleFilterModuleDescriptor simpleFilterModuleDescriptor = moduleDescriptor;
            return simpleFilterModuleDescriptor;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    protected void getRelations(List<SimpleFilterModuleDescriptor> modules, Connection connection) throws SQLException {
        for (SimpleFilterModuleDescriptor moduleDescriptor : modules) {
            ((MySQLModuleSettingDAO)this.moduleSettingDAO).getSettingsHandler(moduleDescriptor, connection);
            this.moduleAttributeDAO.getAttributeHandler(moduleDescriptor, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleFilterModuleDescriptor> getModulesByAttribute(String name, String value) throws SQLException {
        List<Integer> moduleIDs = this.moduleAttributeDAO.getModulesIDsByAttribute(name, value);
        if (moduleIDs == null) {
            return null;
        }
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            HighLevelQuery query = new HighLevelQuery();
            query.addParameter(this.moduleIDQueryParameterFactory.getWhereInParameter(moduleIDs));
            List moduleDescriptors = this.getAll(query, connection);
            if (moduleDescriptors != null) {
                this.getRelations(moduleDescriptors, connection);
            }
            List list = moduleDescriptors;
            return list;
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }
}

